/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configadmin.plugin.interpolation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class Interpolator {
    public static final char END = ']';
    public static final String START = "$[";
    public static final char ESCAPE = '\\';

    private static int getNextStartMarker(AtomicReference<String> valueRef, int pos) {
        String value = valueRef.get();
        int start = value.indexOf(START, pos);
        if (start == -1) {
            return -1;
        }
        if (start > 0 && value.charAt(start - 1) == '\\' && (start == 1 || value.charAt(start - 2) != '\\')) {
            valueRef.set(value.substring(0, start - 1).concat(value.substring(start)));
            return Interpolator.getNextStartMarker(valueRef, start + 1);
        }
        return start;
    }

    private static int[] getMarkerBoundaries(AtomicReference<String> valueRef, int pos) {
        int start = Interpolator.getNextStartMarker(valueRef, pos);
        if (start == -1) {
            return null;
        }
        String value = valueRef.get();
        int end = -1;
        int count = 1;
        for (int index = start + START.length(); index < value.length() && count > 0; ++index) {
            if (value.charAt(index) == ']') {
                if (value.charAt(index - 1) != '\\' || value.charAt(index - 2) == '\\') {
                    end = index;
                    --count;
                } else {
                    value = value.substring(0, index - 1).concat(value.substring(index));
                    valueRef.set(value);
                    --index;
                }
            }
            if (value.charAt(index) != '[') continue;
            if (value.charAt(index - 1) != '\\' || value.charAt(index - 2) == '\\') {
                ++count;
                continue;
            }
            value = value.substring(0, index - 1).concat(value.substring(index));
            valueRef.set(value);
            --index;
        }
        if (count > 0) {
            return null;
        }
        return new int[]{start, end};
    }

    public static Object replace(String value, Provider provider) {
        String result = value;
        int index = -1;
        while (index < result.length()) {
            String name;
            Map<String, String> directives;
            AtomicReference<String> ref = new AtomicReference<String>(result);
            int[] boundaries = Interpolator.getMarkerBoundaries(ref, index);
            result = ref.get();
            if (boundaries == null) {
                index = result.length();
                continue;
            }
            String key = result.substring(boundaries[0] + START.length(), boundaries[1]);
            int sep = key.indexOf(58);
            if (sep == -1) {
                index += START.length();
                continue;
            }
            String type = key.substring(0, sep);
            String postfix = key.substring(sep + 1);
            int dirPos = postfix.indexOf(59);
            if (dirPos != -1) {
                directives = Interpolator.parseDirectives(postfix.substring(dirPos + 1));
                name = postfix.substring(0, dirPos);
            } else {
                directives = Collections.emptyMap();
                name = postfix;
            }
            Object newName = Interpolator.replace(name, provider);
            Object replacement = provider.provide(type, newName.toString(), directives);
            if (replacement == null) {
                index += START.length();
                continue;
            }
            if (!(replacement instanceof String) && boundaries[0] == 0 && boundaries[1] == result.length() - 1) {
                return replacement;
            }
            replacement = Interpolator.replace(replacement.toString(), provider);
            String val = replacement.toString();
            result = result.substring(0, boundaries[0]).concat(val).concat(result.substring(boundaries[1] + 1));
            index = boundaries[0] + val.length();
        }
        return result;
    }

    public static Map<String, String> parseDirectives(String value) {
        HashMap<String, String> directives = new HashMap<String, String>();
        for (int index = 0; index <= value.length(); ++index) {
            boolean split = false;
            if (index == value.length()) {
                split = true;
            } else if (value.charAt(index) == ';') {
                if (index > 0 && value.charAt(index - 1) == '\\' && (index == 1 || value.charAt(index - 2) != '\\')) {
                    value = value.substring(0, index - 1).concat(value.substring(index));
                    --index;
                } else {
                    split = true;
                }
            }
            if (!split) continue;
            String[] kv = value.substring(0, index).split("=", 2);
            if (kv.length > 0) {
                String directiveValue = kv.length == 2 ? kv[1] : "";
                directives.put(kv[0], directiveValue);
            }
            if (index == value.length()) break;
            value = value.substring(index + 1);
            index = -1;
        }
        return directives;
    }

    @FunctionalInterface
    public static interface Provider {
        public Object provide(String var1, String var2, Map<String, String> var3);
    }
}

