/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain.regionscoped;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class RegionAndId {
    protected final String regionId;
    protected final String id;

    public static RegionAndId fromSlashEncoded(String id) {
        Iterable parts = Splitter.on((char)'/').split((CharSequence)Preconditions.checkNotNull((Object)id, (Object)"id"));
        Preconditions.checkArgument((Iterables.size((Iterable)parts) == 2 ? 1 : 0) != 0, (Object)"id must be in format regionId/id");
        return new RegionAndId((String)Iterables.get((Iterable)parts, (int)0), (String)Iterables.get((Iterable)parts, (int)1));
    }

    public static RegionAndId fromRegionAndId(String regionId, String id) {
        return new RegionAndId(regionId, id);
    }

    private static String slashEncodeRegionAndId(String regionId, String id) {
        return (String)Preconditions.checkNotNull((Object)regionId, (Object)"regionId") + "/" + (String)Preconditions.checkNotNull((Object)id, (Object)"id");
    }

    public String slashEncode() {
        return RegionAndId.slashEncodeRegionAndId(this.regionId, this.id);
    }

    protected RegionAndId(String regionId, String id) {
        this.regionId = (String)Preconditions.checkNotNull((Object)regionId, (Object)"regionId");
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
    }

    public String getRegion() {
        return this.regionId;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.regionId, this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegionAndId other = (RegionAndId)obj;
        return Objects.equal((Object)this.regionId, (Object)other.regionId) && Objects.equal((Object)this.id, (Object)other.id);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("regionId", (Object)this.regionId).add("id", (Object)this.id);
    }

    public String toString() {
        return this.string().toString();
    }
}

