/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.felix.gogo.jline.Builtin;
import org.apache.felix.gogo.jline.Posix;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.gogo.runtime.Reflective;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Parser;
import org.apache.karaf.shell.api.console.Registry;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.impl.console.CommandWrapper;
import org.apache.karaf.shell.impl.console.ConsoleSessionImpl;
import org.apache.karaf.shell.impl.console.HeadlessSessionImpl;
import org.apache.karaf.shell.impl.console.RegistryImpl;
import org.apache.karaf.shell.impl.console.commands.ExitCommand;
import org.apache.karaf.shell.impl.console.commands.Procedural;
import org.apache.karaf.shell.impl.console.commands.SubShellCommand;
import org.apache.karaf.shell.impl.console.commands.help.HelpCommand;

public class SessionFactoryImpl
extends RegistryImpl
implements SessionFactory,
Registry {
    final CommandProcessorImpl commandProcessor;
    final ThreadIO threadIO;
    final Map<String, SubShellCommand> subshells = new HashMap<String, SubShellCommand>();
    boolean closed;

    public SessionFactoryImpl(ThreadIO threadIO) {
        super(null);
        this.threadIO = threadIO;
        this.commandProcessor = new CommandProcessorImpl(threadIO){

            @Override
            public Object invoke(CommandSessionImpl session, Object target, String name, List<Object> args) throws Exception {
                return SessionFactoryImpl.this.invoke(session, target, name, args);
            }

            @Override
            public Path redirect(CommandSessionImpl session, Path path, int mode) {
                return SessionFactoryImpl.this.redirect(session, path, mode);
            }
        };
        this.register(new ExitCommand());
        new HelpCommand(this);
        this.register(new ShellCommand("addCommand", "Add a command", this.commandProcessor, "addCommand"));
        this.register(new ShellCommand("removeCommand", "Remove a command", this.commandProcessor, "removeCommand"));
        this.register(new ShellCommand("eval", "Evaluate", this.commandProcessor, "eval"));
        Builtin builtin = new Builtin();
        for (String name : new String[]{"format", "getopt", "new", "set", "tac", "type", "jobs", "fg", "bg", "keymap", "setopt", "unsetopt", "complete", "history", "widget", "__files", "__directories", "__usage_completion"}) {
            this.register(new ShellCommand(name, null, builtin, name));
        }
        Procedural procedural = new Procedural();
        for (String name : new String[]{"each", "if", "not", "throw", "try", "until", "while", "break", "continue"}) {
            this.register(new ShellCommand(name, null, procedural, name));
        }
        Posix posix = new Posix(this.commandProcessor);
        for (String name : new String[]{"cat", "echo", "grep", "sort", "sleep", "cd", "pwd", "ls", "less", "nano", "head", "tail", "clear", "wc", "date", "tmux", "ttop"}) {
            this.register(new ShellCommand(name, null, posix, name));
        }
    }

    protected Object invoke(CommandSessionImpl session, Object target, String name, List<Object> args) throws Exception {
        return Reflective.invoke(session, target, name, args);
    }

    protected Path redirect(CommandSessionImpl session, Path path, int mode) {
        return session.currentDir().resolve(path);
    }

    public CommandProcessorImpl getCommandProcessor() {
        return this.commandProcessor;
    }

    @Override
    public Registry getRegistry() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Object service) {
        Map map = this.services;
        synchronized (map) {
            if (service instanceof Command) {
                Command command = (Command)service;
                String scope = command.getScope();
                String name = command.getName();
                if (!"*".equals(scope)) {
                    if (!this.subshells.containsKey(scope)) {
                        SubShellCommand subShell = new SubShellCommand(scope);
                        this.subshells.put(scope, subShell);
                        this.register(subShell);
                    }
                    this.subshells.get(scope).increment();
                }
                this.commandProcessor.addCommand(scope, (Object)this.wrap(command), name);
            }
            super.register(service);
        }
    }

    protected Function wrap(Command command) {
        return new CommandWrapper(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Object service) {
        Map map = this.services;
        synchronized (map) {
            super.unregister(service);
            if (service instanceof Command) {
                Command command = (Command)service;
                String scope = command.getScope();
                String name = command.getName();
                this.commandProcessor.removeCommand(scope, name);
                if (!"*".equals(scope) && this.subshells.get(scope).decrement() == 0) {
                    SubShellCommand subShell = this.subshells.remove(scope);
                    this.unregister(subShell);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session create(InputStream in, PrintStream out, PrintStream err, Terminal term, String encoding, Runnable closeCallback) {
        CommandProcessorImpl commandProcessorImpl = this.commandProcessor;
        synchronized (commandProcessorImpl) {
            if (this.closed) {
                throw new IllegalStateException("SessionFactory has been closed");
            }
            ConsoleSessionImpl session = new ConsoleSessionImpl(this, this.commandProcessor, this.threadIO, in, out, err, term, encoding, closeCallback);
            if (this.session == null) {
                this.session = session;
            }
            return session;
        }
    }

    @Override
    public Session create(InputStream in, PrintStream out, PrintStream err) {
        return this.create(in, out, err, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session create(InputStream in, PrintStream out, PrintStream err, Session parent) {
        CommandProcessorImpl commandProcessorImpl = this.commandProcessor;
        synchronized (commandProcessorImpl) {
            if (this.closed) {
                throw new IllegalStateException("SessionFactory has been closed");
            }
            HeadlessSessionImpl session = new HeadlessSessionImpl(this, this.commandProcessor, in, out, err, parent);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CommandProcessorImpl commandProcessorImpl = this.commandProcessor;
        synchronized (commandProcessorImpl) {
            this.closed = true;
            this.commandProcessor.stop();
        }
    }

    private static class ShellCommand
    implements Command {
        private final String name;
        private final String desc;
        private final Executable consumer;

        public ShellCommand(String name, String desc, Executable consumer) {
            this.name = name;
            this.desc = desc;
            this.consumer = consumer;
        }

        public ShellCommand(String name, String desc, ExecutableStr consumer) {
            this(name, desc, ShellCommand.wrap(consumer));
        }

        public ShellCommand(String name, String desc, Object target, String method) {
            this(name, desc, ShellCommand.wrap(target, method));
        }

        private static Executable wrap(Object target, String name) {
            return (session, args) -> Reflective.invoke(session, target, name, args);
        }

        private static Executable wrap(ExecutableStr command) {
            return (session, args) -> {
                command.execute(session, ShellCommand.asStringArray(args));
                return null;
            };
        }

        private static String[] asStringArray(List<Object> args) {
            String[] argv = new String[args.size()];
            for (int i = 0; i < argv.length; ++i) {
                argv[i] = Objects.toString(args.get(i));
            }
            return argv;
        }

        @Override
        public String getScope() {
            return "shell";
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public Completer getCompleter(boolean scoped) {
            return null;
        }

        @Override
        public Parser getParser() {
            return null;
        }

        @Override
        public Object execute(Session session, List<Object> arguments) throws Exception {
            CommandSession cmdSession = (CommandSession)session.get(".commandSession");
            return this.consumer.execute(cmdSession, arguments);
        }

        static interface ExecutableStr {
            public void execute(CommandSession var1, String[] var2) throws Exception;
        }

        static interface Executable {
            public Object execute(CommandSession var1, List<Object> var2) throws Exception;
        }
    }
}

