/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.kafka;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.entity.messaging.MessageBroker;
import org.apache.brooklyn.entity.messaging.kafka.Kafka;
import org.apache.brooklyn.entity.messaging.kafka.KafkaBrokerImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperNode;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="Apache Kafka", iconUrl="classpath:///kafka-logo.png")
@ImplementedBy(value=KafkaBrokerImpl.class)
public interface KafkaBroker
extends SoftwareProcess,
MessageBroker,
UsesJmx,
Kafka {
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = Kafka.SUGGESTED_VERSION;
    @SetFromFlag(value="kafkaPort")
    public static final PortAttributeSensorAndConfigKey KAFKA_PORT = new PortAttributeSensorAndConfigKey("kafka.port", "Kafka port", (Object)"9092+");
    @SetFromFlag(value="kafkaServerConfig")
    public static final ConfigKey<String> KAFKA_BROKER_CONFIG_TEMPLATE = new BasicConfigKey(String.class, "kafka.broker.configTemplate", "Kafka broker configuration template (in freemarker format)", (Object)"classpath://org/apache/brooklyn/entity/messaging/kafka/server.properties");
    @SetFromFlag(value="zookeeper")
    public static final ConfigKey<ZooKeeperNode> ZOOKEEPER = new BasicConfigKey(ZooKeeperNode.class, "kafka.broker.zookeeper", "Kafka zookeeper entity");
    public static final PortAttributeSensorAndConfigKey INTERNAL_JMX_PORT = new PortAttributeSensorAndConfigKey("internal.jmx.direct.port", "JMX internal port (started by Kafka broker, if using UsesJmx.JMX_AGENT_MODE is not null)", (Object)PortRanges.fromString((String)"9999+"));
    public static final AttributeSensor<Integer> BROKER_ID = Sensors.newIntegerSensor((String)"kafka.broker.id", (String)"Kafka unique broker ID");
    public static final AttributeSensor<Long> FETCH_REQUEST_COUNT = Sensors.newLongSensor((String)"kafka.broker.fetch.total", (String)"Fetch request count");
    public static final AttributeSensor<Long> TOTAL_FETCH_TIME = Sensors.newLongSensor((String)"kafka.broker.fetch.time.total", (String)"Total fetch request processing time (millis)");
    public static final AttributeSensor<Double> MAX_FETCH_TIME = Sensors.newDoubleSensor((String)"kafka.broker.fetch.time.max", (String)"Max fetch request processing time (millis)");
    public static final AttributeSensor<Long> PRODUCE_REQUEST_COUNT = Sensors.newLongSensor((String)"kafka.broker.produce.total", (String)"Produce request count");
    public static final AttributeSensor<Long> TOTAL_PRODUCE_TIME = Sensors.newLongSensor((String)"kafka.broker.produce.time.total", (String)"Total produce request processing time (millis)");
    public static final AttributeSensor<Double> MAX_PRODUCE_TIME = Sensors.newDoubleSensor((String)"kafka.broker.produce.time.max", (String)"Max produce request processing time (millis)");
    public static final AttributeSensor<Long> BYTES_RECEIVED = Sensors.newLongSensor((String)"kafka.broker.bytes.received", (String)"Total bytes received");
    public static final AttributeSensor<Long> BYTES_SENT = Sensors.newLongSensor((String)"kafka.broker.bytes.sent", (String)"Total bytes sent");

    public Integer getKafkaPort();

    public Integer getBrokerId();

    public ZooKeeperNode getZookeeper();
}

