/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.dns.geoscaling;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.text.Strings;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class GeoscalingWebClient {
    public static final Logger log = LoggerFactory.getLogger(GeoscalingWebClient.class);
    public static final long PROVIDE_NETWORK_INFO = 1L;
    public static final long PROVIDE_CITY_INFO = 2L;
    public static final long PROVIDE_COUNTRY_INFO = 4L;
    public static final long PROVIDE_EXTRA_INFO = 8L;
    public static final long PROVIDE_UPTIME_INFO = 16L;
    private static final String HOST = "www.geoscaling.com";
    private static final String PATH = "dns2/index.php";
    private HttpClient httpClient;
    private Tidy tidy;
    private List<Domain> primaryDomains = null;

    public GeoscalingWebClient() {
        this(HttpTool.httpClientBuilder().build());
    }

    public GeoscalingWebClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.tidy = new Tidy();
        this.tidy.setErrout(new PrintWriter(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        }));
    }

    public GeoscalingWebClient(String username, String password) {
        this();
        this.login(username, password);
    }

    public void login(String username, String password) {
        try {
            String url = MessageFormat.format("https://{0}/{1}?module=auth", HOST, PATH);
            HttpPost request = new HttpPost(url);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2);
            nameValuePairs.add(new BasicNameValuePair("username", username));
            nameValuePairs.add(new BasicNameValuePair("password", password));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            this.sendRequest((HttpUriRequest)request, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to log-in to GeoScaling service: " + e, e);
        }
    }

    public void logout() {
        try {
            String url = MessageFormat.format("https://{0}/{1}?module=auth&logout", HOST, PATH);
            this.sendRequest((HttpUriRequest)new HttpGet(url), true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to log-out of GeoScaling service: " + e, e);
        }
    }

    public List<Domain> getPrimaryDomains() {
        if (this.primaryDomains == null) {
            this.primaryDomains = this.fetchPrimaryDomains();
        }
        return this.primaryDomains;
    }

    public Domain getPrimaryDomain(String name) {
        name = name.toLowerCase();
        for (Domain d : this.getPrimaryDomains()) {
            if (!d.name.equals(name)) continue;
            return d;
        }
        return null;
    }

    public Domain getPrimaryDomain(int id) {
        for (Domain d : this.getPrimaryDomains()) {
            if (d.id != id) continue;
            return d;
        }
        return null;
    }

    public void createPrimaryDomain(String name) {
        try {
            name = name.toLowerCase();
            String url = MessageFormat.format("https://{0}/{1}?module=domains", HOST, PATH);
            HttpPost request = new HttpPost(url);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2);
            nameValuePairs.add(new BasicNameValuePair("MAX_FILE_SIZE", "65536"));
            nameValuePairs.add(new BasicNameValuePair("domain", FilenameUtils.removeExtension((String)name)));
            nameValuePairs.add(new BasicNameValuePair("tld", FilenameUtils.getExtension((String)name)));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            this.sendRequest((HttpUriRequest)request, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create GeoScaling smart subdomain: " + e, e);
        }
        this.primaryDomains = this.fetchPrimaryDomains();
    }

    private List<Domain> fetchPrimaryDomains() {
        try {
            LinkedList<Domain> domains = new LinkedList<Domain>();
            String url = MessageFormat.format("https://{0}/{1}?module=domains", HOST, PATH);
            HttpResponse response = this.sendRequest((HttpUriRequest)new HttpGet(url), false);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                Document document = this.tidy.parseDOM(entity.getContent(), null);
                NodeList links = document.getElementsByTagName("a");
                for (int i = 0; i < links.getLength(); ++i) {
                    Element link = (Element)links.item(i);
                    String href = link.getAttribute("href");
                    Pattern p = Pattern.compile("module=domain.*&id=(\\d+)");
                    Matcher m = p.matcher(href);
                    if (!m.find(0)) continue;
                    int id = Integer.parseInt(m.group(1));
                    String name = GeoscalingWebClient.getTextContent(link).trim();
                    if (name.length() == 0) continue;
                    domains.add(new Domain(id, name));
                }
                EntityUtils.consume((HttpEntity)entity);
            }
            return domains;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve GeoScaling subdomains: " + e, e);
        }
    }

    private void deletePrimaryDomain(int primaryDomainId) {
        try {
            String url = MessageFormat.format("https://{0}/{1}?module=domain&id={2,number,#}&delete=1", HOST, PATH, primaryDomainId);
            this.sendRequest((HttpUriRequest)new HttpGet(url), true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete GeoScaling primary domain: " + e, e);
        }
    }

    private List<SmartSubdomain> fetchSmartSubdomains(Domain parent) {
        try {
            LinkedList<SmartSubdomain> subdomains = new LinkedList<SmartSubdomain>();
            String url = MessageFormat.format("https://{0}/{1}?module=smart_subdomains&id={2,number,#}", HOST, PATH, parent.id);
            HttpResponse response = this.sendRequest((HttpUriRequest)new HttpGet(url), false);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                Document document = this.tidy.parseDOM(entity.getContent(), null);
                NodeList links = document.getElementsByTagName("a");
                for (int i = 0; i < links.getLength(); ++i) {
                    Element link = (Element)links.item(i);
                    String href = link.getAttribute("href");
                    Pattern p = Pattern.compile("module=smart_subdomain.*&subdomain_id=(\\d+)");
                    Matcher m = p.matcher(href);
                    if (!m.find(0)) continue;
                    int subdomainId = Integer.parseInt(m.group(1));
                    String name = GeoscalingWebClient.getTextContent(link);
                    if (name.trim().length() == 0) continue;
                    name = name.substring(0, name.length() - parent.name.length() - 1);
                    subdomains.add(new SmartSubdomain(parent, subdomainId, name));
                }
                EntityUtils.consume((HttpEntity)entity);
            }
            return subdomains;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to retrieve GeoScaling smart subdomains: " + e, e);
        }
    }

    private void createSmartSubdomain(int primaryDomainId, String smartSubdomainName) {
        try {
            smartSubdomainName = smartSubdomainName.toLowerCase();
            String url = MessageFormat.format("https://{0}/{1}?module=smart_subdomains&id={2,number,#}", HOST, PATH, primaryDomainId);
            HttpPost request = new HttpPost(url);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2);
            nameValuePairs.add(new BasicNameValuePair("MAX_FILE_SIZE", "65536"));
            nameValuePairs.add(new BasicNameValuePair("smart_subdomain_name", smartSubdomainName));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            this.sendRequest((HttpUriRequest)request, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create GeoScaling smart subdomain: " + e, e);
        }
    }

    private void deleteSmartSubdomain(int primaryDomainId, int smartSubdomainId) {
        try {
            String url = MessageFormat.format("https://{0}/{1}?module=smart_subdomains&id={2,number,#}&delete={3,number,#}", HOST, PATH, primaryDomainId, smartSubdomainId);
            this.sendRequest((HttpUriRequest)new HttpGet(url), true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to delete GeoScaling smart subdomain: " + e, e);
        }
    }

    private void configureSmartSubdomain(int primaryDomainId, int smartSubdomainId, String smartSubdomainName, long flags, String phpScript) {
        try {
            smartSubdomainName = smartSubdomainName.toLowerCase();
            String url = MessageFormat.format("https://{0}/{1}?module=smart_subdomain&id={2,number,#}&subdomain_id={3,number,#}", HOST, PATH, primaryDomainId, smartSubdomainId);
            HttpPost request = new HttpPost(url);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2);
            nameValuePairs.add(new BasicNameValuePair("MAX_FILE_SIZE", "65536"));
            nameValuePairs.add(new BasicNameValuePair("name", smartSubdomainName));
            if ((flags & 1L) != 0L) {
                nameValuePairs.add(new BasicNameValuePair("share_as_info", "on"));
            }
            if ((flags & 2L) != 0L) {
                nameValuePairs.add(new BasicNameValuePair("share_city_info", "on"));
            }
            if ((flags & 4L) != 0L) {
                nameValuePairs.add(new BasicNameValuePair("share_country_info", "on"));
            }
            if ((flags & 8L) != 0L) {
                nameValuePairs.add(new BasicNameValuePair("share_extra_info", "on"));
            }
            if ((flags & 0x10L) != 0L) {
                nameValuePairs.add(new BasicNameValuePair("share_uptime_info", "on"));
            }
            nameValuePairs.add(new BasicNameValuePair("code", phpScript));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            this.sendRequest((HttpUriRequest)request, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update GeoScaling smart subdomain: " + e, e);
        }
    }

    private void editSubdomainRecord(int primaryDomainId, String record, String type, String content) {
        try {
            String url = MessageFormat.format("https://{0}/{1}?", HOST, "dns2/ajax/add_record.php");
            HttpPost request = new HttpPost(url);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(2);
            nameValuePairs.add(new BasicNameValuePair("id", "" + primaryDomainId));
            nameValuePairs.add(new BasicNameValuePair("name", record));
            nameValuePairs.add(new BasicNameValuePair("type", type));
            nameValuePairs.add(new BasicNameValuePair("content", content));
            nameValuePairs.add(new BasicNameValuePair("ttl", "300"));
            nameValuePairs.add(new BasicNameValuePair("prio", "0"));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            this.sendRequest((HttpUriRequest)request, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update GeoScaling smart subdomain: " + e, e);
        }
    }

    protected HttpResponse sendRequest(HttpUriRequest request, boolean consumeResponse) throws ClientProtocolException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Geoscaling request: " + request.getURI() + (request instanceof HttpPost ? " " + ((HttpPost)request).getEntity() : ""));
        }
        HttpResponse response = this.httpClient.execute(request);
        if (log.isDebugEnabled()) {
            log.debug("Geoscaling response: " + response);
        }
        if (consumeResponse) {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        return response;
    }

    private static String getTextContent(Node n) {
        StringBuffer sb = new StringBuffer();
        NodeList childNodes = n.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 3) {
                sb.append(child.getNodeValue());
                continue;
            }
            sb.append(GeoscalingWebClient.getTextContent(child));
        }
        return sb.toString();
    }

    public class SmartSubdomain {
        public final Domain parent;
        public final int id;
        public String name;

        public SmartSubdomain(Domain parent, int id, String name) {
            this.parent = parent;
            this.id = id;
            this.name = name.toLowerCase();
        }

        public void configure(long flags, String phpScript) {
            GeoscalingWebClient.this.configureSmartSubdomain(this.parent.id, this.id, this.name, flags, phpScript);
        }

        public void delete() {
            GeoscalingWebClient.this.deleteSmartSubdomain(this.parent.id, this.id);
            this.parent.smartSubdomains = GeoscalingWebClient.this.fetchSmartSubdomains(this.parent);
        }

        public String toString() {
            return "SmartSubdomain[" + this.name + " (" + this.id + ")]";
        }

        public int hashCode() {
            return this.id;
        }
    }

    public class Domain {
        public final int id;
        public final String name;
        private List<SmartSubdomain> smartSubdomains = null;

        public Domain(int id, String name) {
            this.id = id;
            this.name = name.toLowerCase();
        }

        public List<SmartSubdomain> getSmartSubdomains() {
            if (this.smartSubdomains == null) {
                this.smartSubdomains = GeoscalingWebClient.this.fetchSmartSubdomains(this);
            }
            return this.smartSubdomains;
        }

        public SmartSubdomain getSmartSubdomain(String name) {
            name = name.toLowerCase();
            for (SmartSubdomain s : this.getSmartSubdomains()) {
                if (!s.name.equals(name)) continue;
                return s;
            }
            return null;
        }

        public void editRecord(String subdomainPart, String type, String content) {
            subdomainPart = Strings.removeFromEnd((String)subdomainPart, (String)("." + this.name));
            GeoscalingWebClient.this.editSubdomainRecord(this.id, subdomainPart, type, content);
        }

        public SmartSubdomain getSmartSubdomain(int id) {
            for (SmartSubdomain s : this.getSmartSubdomains()) {
                if (s.id != id) continue;
                return s;
            }
            return null;
        }

        public void createSmartSubdomain(String name) {
            GeoscalingWebClient.this.createSmartSubdomain(this.id, name);
            this.smartSubdomains = GeoscalingWebClient.this.fetchSmartSubdomains(this);
        }

        public void delete() {
            GeoscalingWebClient.this.deletePrimaryDomain(this.id);
            GeoscalingWebClient.this.primaryDomains = GeoscalingWebClient.this.fetchPrimaryDomains();
        }

        public String toString() {
            return "Domain[" + this.name + " (" + this.id + ")]";
        }

        public int hashCode() {
            return this.id;
        }
    }
}

