/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageLayer;
import io.fabric8.openshift.api.model.ImageLayerBuilder;
import io.fabric8.openshift.api.model.ImageLayerFluent;
import io.fabric8.openshift.api.model.ImageManifest;
import io.fabric8.openshift.api.model.ImageManifestBuilder;
import io.fabric8.openshift.api.model.ImageManifestFluent;
import io.fabric8.openshift.api.model.ImageSignature;
import io.fabric8.openshift.api.model.ImageSignatureBuilder;
import io.fabric8.openshift.api.model.ImageSignatureFluent;
import io.fabric8.openshift.api.model.runtime.RawExtension;
import io.fabric8.openshift.api.model.runtime.RawExtensionBuilder;
import io.fabric8.openshift.api.model.runtime.RawExtensionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImageFluent<A extends ImageFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String dockerImageConfig;
    private ArrayList<ImageLayerBuilder> dockerImageLayers = new ArrayList();
    private String dockerImageManifest;
    private String dockerImageManifestMediaType;
    private ArrayList<ImageManifestBuilder> dockerImageManifests = new ArrayList();
    private RawExtensionBuilder dockerImageMetadata;
    private String dockerImageMetadataVersion;
    private String dockerImageReference;
    private List<String> dockerImageSignatures = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private ArrayList<ImageSignatureBuilder> signatures = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ImageFluent() {
    }

    public ImageFluent(Image instance) {
        Image image = instance = instance != null ? instance : new Image();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDockerImageConfig(instance.getDockerImageConfig());
            this.withDockerImageLayers(instance.getDockerImageLayers());
            this.withDockerImageManifest(instance.getDockerImageManifest());
            this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
            this.withDockerImageManifests(instance.getDockerImageManifests());
            this.withDockerImageMetadata(instance.getDockerImageMetadata());
            this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
            this.withDockerImageReference(instance.getDockerImageReference());
            this.withDockerImageSignatures(instance.getDockerImageSignatures());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSignatures(instance.getSignatures());
            this.withApiVersion(instance.getApiVersion());
            this.withDockerImageConfig(instance.getDockerImageConfig());
            this.withDockerImageLayers(instance.getDockerImageLayers());
            this.withDockerImageManifest(instance.getDockerImageManifest());
            this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
            this.withDockerImageManifests(instance.getDockerImageManifests());
            this.withDockerImageMetadata(instance.getDockerImageMetadata());
            this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
            this.withDockerImageReference(instance.getDockerImageReference());
            this.withDockerImageSignatures(instance.getDockerImageSignatures());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSignatures(instance.getSignatures());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getDockerImageConfig() {
        return this.dockerImageConfig;
    }

    public A withDockerImageConfig(String dockerImageConfig) {
        this.dockerImageConfig = dockerImageConfig;
        return (A)((Object)this);
    }

    public boolean hasDockerImageConfig() {
        return this.dockerImageConfig != null;
    }

    public A addToDockerImageLayers(int index, ImageLayer item) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList();
        }
        ImageLayerBuilder builder = new ImageLayerBuilder(item);
        if (index < 0 || index >= this.dockerImageLayers.size()) {
            this._visitables.get((Object)"dockerImageLayers").add(builder);
            this.dockerImageLayers.add(builder);
        } else {
            this._visitables.get((Object)"dockerImageLayers").add(index, builder);
            this.dockerImageLayers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDockerImageLayers(int index, ImageLayer item) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList();
        }
        ImageLayerBuilder builder = new ImageLayerBuilder(item);
        if (index < 0 || index >= this.dockerImageLayers.size()) {
            this._visitables.get((Object)"dockerImageLayers").add(builder);
            this.dockerImageLayers.add(builder);
        } else {
            this._visitables.get((Object)"dockerImageLayers").set(index, builder);
            this.dockerImageLayers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDockerImageLayers(ImageLayer ... items) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList();
        }
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get((Object)"dockerImageLayers").add(builder);
            this.dockerImageLayers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDockerImageLayers(Collection<ImageLayer> items) {
        if (this.dockerImageLayers == null) {
            this.dockerImageLayers = new ArrayList();
        }
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get((Object)"dockerImageLayers").add(builder);
            this.dockerImageLayers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDockerImageLayers(ImageLayer ... items) {
        if (this.dockerImageLayers == null) {
            return (A)((Object)this);
        }
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get((Object)"dockerImageLayers").remove((Object)builder);
            this.dockerImageLayers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDockerImageLayers(Collection<ImageLayer> items) {
        if (this.dockerImageLayers == null) {
            return (A)((Object)this);
        }
        for (ImageLayer item : items) {
            ImageLayerBuilder builder = new ImageLayerBuilder(item);
            this._visitables.get((Object)"dockerImageLayers").remove((Object)builder);
            this.dockerImageLayers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDockerImageLayers(Predicate<ImageLayerBuilder> predicate) {
        if (this.dockerImageLayers == null) {
            return (A)((Object)this);
        }
        Iterator<ImageLayerBuilder> each = this.dockerImageLayers.iterator();
        List visitables = this._visitables.get((Object)"dockerImageLayers");
        while (each.hasNext()) {
            ImageLayerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ImageLayer> buildDockerImageLayers() {
        return this.dockerImageLayers != null ? ImageFluent.build(this.dockerImageLayers) : null;
    }

    public ImageLayer buildDockerImageLayer(int index) {
        return this.dockerImageLayers.get(index).build();
    }

    public ImageLayer buildFirstDockerImageLayer() {
        return this.dockerImageLayers.get(0).build();
    }

    public ImageLayer buildLastDockerImageLayer() {
        return this.dockerImageLayers.get(this.dockerImageLayers.size() - 1).build();
    }

    public ImageLayer buildMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
        for (ImageLayerBuilder item : this.dockerImageLayers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
        for (ImageLayerBuilder item : this.dockerImageLayers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDockerImageLayers(List<ImageLayer> dockerImageLayers) {
        if (this.dockerImageLayers != null) {
            this._visitables.get((Object)"dockerImageLayers").clear();
        }
        if (dockerImageLayers != null) {
            this.dockerImageLayers = new ArrayList();
            for (ImageLayer item : dockerImageLayers) {
                this.addToDockerImageLayers(item);
            }
        } else {
            this.dockerImageLayers = null;
        }
        return (A)((Object)this);
    }

    public A withDockerImageLayers(ImageLayer ... dockerImageLayers) {
        if (this.dockerImageLayers != null) {
            this.dockerImageLayers.clear();
            this._visitables.remove((Object)"dockerImageLayers");
        }
        if (dockerImageLayers != null) {
            for (ImageLayer item : dockerImageLayers) {
                this.addToDockerImageLayers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDockerImageLayers() {
        return this.dockerImageLayers != null && !this.dockerImageLayers.isEmpty();
    }

    public A addNewDockerImageLayer(String mediaType, String name, Long size) {
        return this.addToDockerImageLayers(new ImageLayer(mediaType, name, size));
    }

    public DockerImageLayersNested<A> addNewDockerImageLayer() {
        return new DockerImageLayersNested(-1, null);
    }

    public DockerImageLayersNested<A> addNewDockerImageLayerLike(ImageLayer item) {
        return new DockerImageLayersNested(-1, item);
    }

    public DockerImageLayersNested<A> setNewDockerImageLayerLike(int index, ImageLayer item) {
        return new DockerImageLayersNested(index, item);
    }

    public DockerImageLayersNested<A> editDockerImageLayer(int index) {
        if (this.dockerImageLayers.size() <= index) {
            throw new RuntimeException("Can't edit dockerImageLayers. Index exceeds size.");
        }
        return this.setNewDockerImageLayerLike(index, this.buildDockerImageLayer(index));
    }

    public DockerImageLayersNested<A> editFirstDockerImageLayer() {
        if (this.dockerImageLayers.size() == 0) {
            throw new RuntimeException("Can't edit first dockerImageLayers. The list is empty.");
        }
        return this.setNewDockerImageLayerLike(0, this.buildDockerImageLayer(0));
    }

    public DockerImageLayersNested<A> editLastDockerImageLayer() {
        int index = this.dockerImageLayers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dockerImageLayers. The list is empty.");
        }
        return this.setNewDockerImageLayerLike(index, this.buildDockerImageLayer(index));
    }

    public DockerImageLayersNested<A> editMatchingDockerImageLayer(Predicate<ImageLayerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dockerImageLayers.size(); ++i) {
            if (!predicate.test(this.dockerImageLayers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dockerImageLayers. No match found.");
        }
        return this.setNewDockerImageLayerLike(index, this.buildDockerImageLayer(index));
    }

    public String getDockerImageManifest() {
        return this.dockerImageManifest;
    }

    public A withDockerImageManifest(String dockerImageManifest) {
        this.dockerImageManifest = dockerImageManifest;
        return (A)((Object)this);
    }

    public boolean hasDockerImageManifest() {
        return this.dockerImageManifest != null;
    }

    public String getDockerImageManifestMediaType() {
        return this.dockerImageManifestMediaType;
    }

    public A withDockerImageManifestMediaType(String dockerImageManifestMediaType) {
        this.dockerImageManifestMediaType = dockerImageManifestMediaType;
        return (A)((Object)this);
    }

    public boolean hasDockerImageManifestMediaType() {
        return this.dockerImageManifestMediaType != null;
    }

    public A addToDockerImageManifests(int index, ImageManifest item) {
        if (this.dockerImageManifests == null) {
            this.dockerImageManifests = new ArrayList();
        }
        ImageManifestBuilder builder = new ImageManifestBuilder(item);
        if (index < 0 || index >= this.dockerImageManifests.size()) {
            this._visitables.get((Object)"dockerImageManifests").add(builder);
            this.dockerImageManifests.add(builder);
        } else {
            this._visitables.get((Object)"dockerImageManifests").add(index, builder);
            this.dockerImageManifests.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDockerImageManifests(int index, ImageManifest item) {
        if (this.dockerImageManifests == null) {
            this.dockerImageManifests = new ArrayList();
        }
        ImageManifestBuilder builder = new ImageManifestBuilder(item);
        if (index < 0 || index >= this.dockerImageManifests.size()) {
            this._visitables.get((Object)"dockerImageManifests").add(builder);
            this.dockerImageManifests.add(builder);
        } else {
            this._visitables.get((Object)"dockerImageManifests").set(index, builder);
            this.dockerImageManifests.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDockerImageManifests(ImageManifest ... items) {
        if (this.dockerImageManifests == null) {
            this.dockerImageManifests = new ArrayList();
        }
        for (ImageManifest item : items) {
            ImageManifestBuilder builder = new ImageManifestBuilder(item);
            this._visitables.get((Object)"dockerImageManifests").add(builder);
            this.dockerImageManifests.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDockerImageManifests(Collection<ImageManifest> items) {
        if (this.dockerImageManifests == null) {
            this.dockerImageManifests = new ArrayList();
        }
        for (ImageManifest item : items) {
            ImageManifestBuilder builder = new ImageManifestBuilder(item);
            this._visitables.get((Object)"dockerImageManifests").add(builder);
            this.dockerImageManifests.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDockerImageManifests(ImageManifest ... items) {
        if (this.dockerImageManifests == null) {
            return (A)((Object)this);
        }
        for (ImageManifest item : items) {
            ImageManifestBuilder builder = new ImageManifestBuilder(item);
            this._visitables.get((Object)"dockerImageManifests").remove((Object)builder);
            this.dockerImageManifests.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDockerImageManifests(Collection<ImageManifest> items) {
        if (this.dockerImageManifests == null) {
            return (A)((Object)this);
        }
        for (ImageManifest item : items) {
            ImageManifestBuilder builder = new ImageManifestBuilder(item);
            this._visitables.get((Object)"dockerImageManifests").remove((Object)builder);
            this.dockerImageManifests.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDockerImageManifests(Predicate<ImageManifestBuilder> predicate) {
        if (this.dockerImageManifests == null) {
            return (A)((Object)this);
        }
        Iterator<ImageManifestBuilder> each = this.dockerImageManifests.iterator();
        List visitables = this._visitables.get((Object)"dockerImageManifests");
        while (each.hasNext()) {
            ImageManifestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ImageManifest> buildDockerImageManifests() {
        return this.dockerImageManifests != null ? ImageFluent.build(this.dockerImageManifests) : null;
    }

    public ImageManifest buildDockerImageManifest(int index) {
        return this.dockerImageManifests.get(index).build();
    }

    public ImageManifest buildFirstDockerImageManifest() {
        return this.dockerImageManifests.get(0).build();
    }

    public ImageManifest buildLastDockerImageManifest() {
        return this.dockerImageManifests.get(this.dockerImageManifests.size() - 1).build();
    }

    public ImageManifest buildMatchingDockerImageManifest(Predicate<ImageManifestBuilder> predicate) {
        for (ImageManifestBuilder item : this.dockerImageManifests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDockerImageManifest(Predicate<ImageManifestBuilder> predicate) {
        for (ImageManifestBuilder item : this.dockerImageManifests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDockerImageManifests(List<ImageManifest> dockerImageManifests) {
        if (this.dockerImageManifests != null) {
            this._visitables.get((Object)"dockerImageManifests").clear();
        }
        if (dockerImageManifests != null) {
            this.dockerImageManifests = new ArrayList();
            for (ImageManifest item : dockerImageManifests) {
                this.addToDockerImageManifests(item);
            }
        } else {
            this.dockerImageManifests = null;
        }
        return (A)((Object)this);
    }

    public A withDockerImageManifests(ImageManifest ... dockerImageManifests) {
        if (this.dockerImageManifests != null) {
            this.dockerImageManifests.clear();
            this._visitables.remove((Object)"dockerImageManifests");
        }
        if (dockerImageManifests != null) {
            for (ImageManifest item : dockerImageManifests) {
                this.addToDockerImageManifests(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDockerImageManifests() {
        return this.dockerImageManifests != null && !this.dockerImageManifests.isEmpty();
    }

    public DockerImageManifestsNested<A> addNewDockerImageManifest() {
        return new DockerImageManifestsNested(-1, null);
    }

    public DockerImageManifestsNested<A> addNewDockerImageManifestLike(ImageManifest item) {
        return new DockerImageManifestsNested(-1, item);
    }

    public DockerImageManifestsNested<A> setNewDockerImageManifestLike(int index, ImageManifest item) {
        return new DockerImageManifestsNested(index, item);
    }

    public DockerImageManifestsNested<A> editDockerImageManifest(int index) {
        if (this.dockerImageManifests.size() <= index) {
            throw new RuntimeException("Can't edit dockerImageManifests. Index exceeds size.");
        }
        return this.setNewDockerImageManifestLike(index, this.buildDockerImageManifest(index));
    }

    public DockerImageManifestsNested<A> editFirstDockerImageManifest() {
        if (this.dockerImageManifests.size() == 0) {
            throw new RuntimeException("Can't edit first dockerImageManifests. The list is empty.");
        }
        return this.setNewDockerImageManifestLike(0, this.buildDockerImageManifest(0));
    }

    public DockerImageManifestsNested<A> editLastDockerImageManifest() {
        int index = this.dockerImageManifests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dockerImageManifests. The list is empty.");
        }
        return this.setNewDockerImageManifestLike(index, this.buildDockerImageManifest(index));
    }

    public DockerImageManifestsNested<A> editMatchingDockerImageManifest(Predicate<ImageManifestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dockerImageManifests.size(); ++i) {
            if (!predicate.test(this.dockerImageManifests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dockerImageManifests. No match found.");
        }
        return this.setNewDockerImageManifestLike(index, this.buildDockerImageManifest(index));
    }

    public RawExtension buildDockerImageMetadata() {
        return this.dockerImageMetadata != null ? this.dockerImageMetadata.build() : null;
    }

    public A withDockerImageMetadata(RawExtension dockerImageMetadata) {
        this._visitables.get((Object)"dockerImageMetadata").remove((Object)this.dockerImageMetadata);
        if (dockerImageMetadata != null) {
            this.dockerImageMetadata = new RawExtensionBuilder(dockerImageMetadata);
            this._visitables.get((Object)"dockerImageMetadata").add(this.dockerImageMetadata);
        } else {
            this.dockerImageMetadata = null;
            this._visitables.get((Object)"dockerImageMetadata").remove((Object)this.dockerImageMetadata);
        }
        return (A)((Object)this);
    }

    public boolean hasDockerImageMetadata() {
        return this.dockerImageMetadata != null;
    }

    public A withNewOpenshiftDockerImageMetadata(Object value) {
        return this.withDockerImageMetadata(new RawExtension(value));
    }

    public OpenshiftDockerImageMetadataNested<A> withNewOpenshiftDockerImageMetadata() {
        return new OpenshiftDockerImageMetadataNested(null);
    }

    public OpenshiftDockerImageMetadataNested<A> withNewDockerImageMetadataLike(RawExtension item) {
        return new OpenshiftDockerImageMetadataNested(item);
    }

    public OpenshiftDockerImageMetadataNested<A> editOpenshiftDockerImageMetadata() {
        return this.withNewDockerImageMetadataLike(Optional.ofNullable(this.buildDockerImageMetadata()).orElse(null));
    }

    public OpenshiftDockerImageMetadataNested<A> editOrNewDockerImageMetadata() {
        return this.withNewDockerImageMetadataLike(Optional.ofNullable(this.buildDockerImageMetadata()).orElse(new RawExtensionBuilder().build()));
    }

    public OpenshiftDockerImageMetadataNested<A> editOrNewDockerImageMetadataLike(RawExtension item) {
        return this.withNewDockerImageMetadataLike(Optional.ofNullable(this.buildDockerImageMetadata()).orElse(item));
    }

    public String getDockerImageMetadataVersion() {
        return this.dockerImageMetadataVersion;
    }

    public A withDockerImageMetadataVersion(String dockerImageMetadataVersion) {
        this.dockerImageMetadataVersion = dockerImageMetadataVersion;
        return (A)((Object)this);
    }

    public boolean hasDockerImageMetadataVersion() {
        return this.dockerImageMetadataVersion != null;
    }

    public String getDockerImageReference() {
        return this.dockerImageReference;
    }

    public A withDockerImageReference(String dockerImageReference) {
        this.dockerImageReference = dockerImageReference;
        return (A)((Object)this);
    }

    public boolean hasDockerImageReference() {
        return this.dockerImageReference != null;
    }

    public A addToDockerImageSignatures(int index, String item) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        this.dockerImageSignatures.add(index, item);
        return (A)((Object)this);
    }

    public A setToDockerImageSignatures(int index, String item) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        this.dockerImageSignatures.set(index, item);
        return (A)((Object)this);
    }

    public A addToDockerImageSignatures(String ... items) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        for (String item : items) {
            this.dockerImageSignatures.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDockerImageSignatures(Collection<String> items) {
        if (this.dockerImageSignatures == null) {
            this.dockerImageSignatures = new ArrayList<String>();
        }
        for (String item : items) {
            this.dockerImageSignatures.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDockerImageSignatures(String ... items) {
        if (this.dockerImageSignatures == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dockerImageSignatures.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDockerImageSignatures(Collection<String> items) {
        if (this.dockerImageSignatures == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dockerImageSignatures.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDockerImageSignatures() {
        return this.dockerImageSignatures;
    }

    public String getDockerImageSignature(int index) {
        return this.dockerImageSignatures.get(index);
    }

    public String getFirstDockerImageSignature() {
        return this.dockerImageSignatures.get(0);
    }

    public String getLastDockerImageSignature() {
        return this.dockerImageSignatures.get(this.dockerImageSignatures.size() - 1);
    }

    public String getMatchingDockerImageSignature(Predicate<String> predicate) {
        for (String item : this.dockerImageSignatures) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDockerImageSignature(Predicate<String> predicate) {
        for (String item : this.dockerImageSignatures) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDockerImageSignatures(List<String> dockerImageSignatures) {
        if (dockerImageSignatures != null) {
            this.dockerImageSignatures = new ArrayList<String>();
            for (String item : dockerImageSignatures) {
                this.addToDockerImageSignatures(item);
            }
        } else {
            this.dockerImageSignatures = null;
        }
        return (A)((Object)this);
    }

    public A withDockerImageSignatures(String ... dockerImageSignatures) {
        if (this.dockerImageSignatures != null) {
            this.dockerImageSignatures.clear();
            this._visitables.remove((Object)"dockerImageSignatures");
        }
        if (dockerImageSignatures != null) {
            for (String item : dockerImageSignatures) {
                this.addToDockerImageSignatures(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDockerImageSignatures() {
        return this.dockerImageSignatures != null && !this.dockerImageSignatures.isEmpty();
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToSignatures(int index, ImageSignature item) {
        if (this.signatures == null) {
            this.signatures = new ArrayList();
        }
        ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
        if (index < 0 || index >= this.signatures.size()) {
            this._visitables.get((Object)"signatures").add(builder);
            this.signatures.add(builder);
        } else {
            this._visitables.get((Object)"signatures").add(index, builder);
            this.signatures.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSignatures(int index, ImageSignature item) {
        if (this.signatures == null) {
            this.signatures = new ArrayList();
        }
        ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
        if (index < 0 || index >= this.signatures.size()) {
            this._visitables.get((Object)"signatures").add(builder);
            this.signatures.add(builder);
        } else {
            this._visitables.get((Object)"signatures").set(index, builder);
            this.signatures.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSignatures(ImageSignature ... items) {
        if (this.signatures == null) {
            this.signatures = new ArrayList();
        }
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get((Object)"signatures").add(builder);
            this.signatures.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSignatures(Collection<ImageSignature> items) {
        if (this.signatures == null) {
            this.signatures = new ArrayList();
        }
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get((Object)"signatures").add(builder);
            this.signatures.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSignatures(ImageSignature ... items) {
        if (this.signatures == null) {
            return (A)((Object)this);
        }
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get((Object)"signatures").remove((Object)builder);
            this.signatures.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSignatures(Collection<ImageSignature> items) {
        if (this.signatures == null) {
            return (A)((Object)this);
        }
        for (ImageSignature item : items) {
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            this._visitables.get((Object)"signatures").remove((Object)builder);
            this.signatures.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSignatures(Predicate<ImageSignatureBuilder> predicate) {
        if (this.signatures == null) {
            return (A)((Object)this);
        }
        Iterator<ImageSignatureBuilder> each = this.signatures.iterator();
        List visitables = this._visitables.get((Object)"signatures");
        while (each.hasNext()) {
            ImageSignatureBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ImageSignature> buildSignatures() {
        return this.signatures != null ? ImageFluent.build(this.signatures) : null;
    }

    public ImageSignature buildSignature(int index) {
        return this.signatures.get(index).build();
    }

    public ImageSignature buildFirstSignature() {
        return this.signatures.get(0).build();
    }

    public ImageSignature buildLastSignature() {
        return this.signatures.get(this.signatures.size() - 1).build();
    }

    public ImageSignature buildMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
        for (ImageSignatureBuilder item : this.signatures) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
        for (ImageSignatureBuilder item : this.signatures) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSignatures(List<ImageSignature> signatures) {
        if (this.signatures != null) {
            this._visitables.get((Object)"signatures").clear();
        }
        if (signatures != null) {
            this.signatures = new ArrayList();
            for (ImageSignature item : signatures) {
                this.addToSignatures(item);
            }
        } else {
            this.signatures = null;
        }
        return (A)((Object)this);
    }

    public A withSignatures(ImageSignature ... signatures) {
        if (this.signatures != null) {
            this.signatures.clear();
            this._visitables.remove((Object)"signatures");
        }
        if (signatures != null) {
            for (ImageSignature item : signatures) {
                this.addToSignatures(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSignatures() {
        return this.signatures != null && !this.signatures.isEmpty();
    }

    public SignaturesNested<A> addNewSignature() {
        return new SignaturesNested(-1, null);
    }

    public SignaturesNested<A> addNewSignatureLike(ImageSignature item) {
        return new SignaturesNested(-1, item);
    }

    public SignaturesNested<A> setNewSignatureLike(int index, ImageSignature item) {
        return new SignaturesNested(index, item);
    }

    public SignaturesNested<A> editSignature(int index) {
        if (this.signatures.size() <= index) {
            throw new RuntimeException("Can't edit signatures. Index exceeds size.");
        }
        return this.setNewSignatureLike(index, this.buildSignature(index));
    }

    public SignaturesNested<A> editFirstSignature() {
        if (this.signatures.size() == 0) {
            throw new RuntimeException("Can't edit first signatures. The list is empty.");
        }
        return this.setNewSignatureLike(0, this.buildSignature(0));
    }

    public SignaturesNested<A> editLastSignature() {
        int index = this.signatures.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last signatures. The list is empty.");
        }
        return this.setNewSignatureLike(index, this.buildSignature(index));
    }

    public SignaturesNested<A> editMatchingSignature(Predicate<ImageSignatureBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.signatures.size(); ++i) {
            if (!predicate.test(this.signatures.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching signatures. No match found.");
        }
        return this.setNewSignatureLike(index, this.buildSignature(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageFluent that = (ImageFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.dockerImageConfig, that.dockerImageConfig)) {
            return false;
        }
        if (!Objects.equals(this.dockerImageLayers, that.dockerImageLayers)) {
            return false;
        }
        if (!Objects.equals(this.dockerImageManifest, that.dockerImageManifest)) {
            return false;
        }
        if (!Objects.equals(this.dockerImageManifestMediaType, that.dockerImageManifestMediaType)) {
            return false;
        }
        if (!Objects.equals(this.dockerImageManifests, that.dockerImageManifests)) {
            return false;
        }
        if (!Objects.equals((Object)this.dockerImageMetadata, (Object)that.dockerImageMetadata)) {
            return false;
        }
        if (!Objects.equals(this.dockerImageMetadataVersion, that.dockerImageMetadataVersion)) {
            return false;
        }
        if (!Objects.equals(this.dockerImageReference, that.dockerImageReference)) {
            return false;
        }
        if (!Objects.equals(this.dockerImageSignatures, that.dockerImageSignatures)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.signatures, that.signatures)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.dockerImageConfig, this.dockerImageLayers, this.dockerImageManifest, this.dockerImageManifestMediaType, this.dockerImageManifests, this.dockerImageMetadata, this.dockerImageMetadataVersion, this.dockerImageReference, this.dockerImageSignatures, this.kind, this.metadata, this.signatures, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.dockerImageConfig != null) {
            sb.append("dockerImageConfig:");
            sb.append(this.dockerImageConfig + ",");
        }
        if (this.dockerImageLayers != null && !this.dockerImageLayers.isEmpty()) {
            sb.append("dockerImageLayers:");
            sb.append(this.dockerImageLayers + ",");
        }
        if (this.dockerImageManifest != null) {
            sb.append("dockerImageManifest:");
            sb.append(this.dockerImageManifest + ",");
        }
        if (this.dockerImageManifestMediaType != null) {
            sb.append("dockerImageManifestMediaType:");
            sb.append(this.dockerImageManifestMediaType + ",");
        }
        if (this.dockerImageManifests != null && !this.dockerImageManifests.isEmpty()) {
            sb.append("dockerImageManifests:");
            sb.append(this.dockerImageManifests + ",");
        }
        if (this.dockerImageMetadata != null) {
            sb.append("dockerImageMetadata:");
            sb.append((Object)((Object)this.dockerImageMetadata) + ",");
        }
        if (this.dockerImageMetadataVersion != null) {
            sb.append("dockerImageMetadataVersion:");
            sb.append(this.dockerImageMetadataVersion + ",");
        }
        if (this.dockerImageReference != null) {
            sb.append("dockerImageReference:");
            sb.append(this.dockerImageReference + ",");
        }
        if (this.dockerImageSignatures != null && !this.dockerImageSignatures.isEmpty()) {
            sb.append("dockerImageSignatures:");
            sb.append(this.dockerImageSignatures + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.signatures != null && !this.signatures.isEmpty()) {
            sb.append("signatures:");
            sb.append(this.signatures + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SignaturesNested<N>
    extends ImageSignatureFluent<SignaturesNested<N>>
    implements Nested<N> {
        ImageSignatureBuilder builder;
        int index;

        SignaturesNested(int index, ImageSignature item) {
            this.index = index;
            this.builder = new ImageSignatureBuilder(this, item);
        }

        public N and() {
            return (N)ImageFluent.this.setToSignatures(this.index, this.builder.build());
        }

        public N endSignature() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)ImageFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class OpenshiftDockerImageMetadataNested<N>
    extends RawExtensionFluent<OpenshiftDockerImageMetadataNested<N>>
    implements Nested<N> {
        RawExtensionBuilder builder;

        OpenshiftDockerImageMetadataNested(RawExtension item) {
            this.builder = new RawExtensionBuilder(this, item);
        }

        public N and() {
            return (N)ImageFluent.this.withDockerImageMetadata(this.builder.build());
        }

        public N endOpenshiftDockerImageMetadata() {
            return this.and();
        }
    }

    public class DockerImageManifestsNested<N>
    extends ImageManifestFluent<DockerImageManifestsNested<N>>
    implements Nested<N> {
        ImageManifestBuilder builder;
        int index;

        DockerImageManifestsNested(int index, ImageManifest item) {
            this.index = index;
            this.builder = new ImageManifestBuilder(this, item);
        }

        public N and() {
            return (N)ImageFluent.this.setToDockerImageManifests(this.index, this.builder.build());
        }

        public N endDockerImageManifest() {
            return this.and();
        }
    }

    public class DockerImageLayersNested<N>
    extends ImageLayerFluent<DockerImageLayersNested<N>>
    implements Nested<N> {
        ImageLayerBuilder builder;
        int index;

        DockerImageLayersNested(int index, ImageLayer item) {
            this.index = index;
            this.builder = new ImageLayerBuilder(this, item);
        }

        public N and() {
            return (N)ImageFluent.this.setToDockerImageLayers(this.index, this.builder.build());
        }

        public N endDockerImageLayer() {
            return this.and();
        }
    }
}

