/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.config;

import com.google.common.annotations.Beta;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.config.ConfigInheritances;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.ConfigValueAtContainer;
import org.apache.brooklyn.util.collections.CollectionMerger;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;

public interface ConfigInheritance
extends Serializable {
    @Deprecated
    public static final ConfigInheritance NONE = new Legacy.None();
    @Deprecated
    public static final ConfigInheritance ALWAYS = new Legacy.Always();
    @Deprecated
    public static final ConfigInheritance DEEP_MERGE = new Legacy.Merged();

    @Deprecated
    public InheritanceMode isInherited(ConfigKey<?> var1, Object var2, Object var3);

    public <TContainer, TValue> boolean isReinheritable(@Nullable ConfigValueAtContainer<TContainer, TValue> var1, ConfigInheritanceContext var2);

    public <TContainer, TValue> boolean considerParent(@Nonnull ConfigValueAtContainer<TContainer, TValue> var1, @Nullable ConfigValueAtContainer<TContainer, TValue> var2, ConfigInheritanceContext var3);

    public <TContainer, TValue> ReferenceWithError<ConfigValueAtContainer<TContainer, TValue>> resolveWithParent(@Nonnull ConfigValueAtContainer<TContainer, TValue> var1, @Nonnull ConfigValueAtContainer<TContainer, TValue> var2, ConfigInheritanceContext var3);

    @Deprecated
    public static class Legacy {
        private static Map<ConfigInheritance, ConfigInheritance> REPLACEMENTS = MutableMap.of();

        public static ConfigInheritance fromString(String val) {
            if (Strings.isBlank(val)) {
                return null;
            }
            switch (val.toLowerCase().trim()) {
                case "none": {
                    return NONE;
                }
                case "always": {
                    return ALWAYS;
                }
                case "deepmerge": 
                case "deep_merge": {
                    return DEEP_MERGE;
                }
            }
            throw new IllegalArgumentException("Invalid config-inheritance '" + val + "' (legal values are none, always or merge)");
        }

        public static void registerReplacement(ConfigInheritance old, ConfigInheritance replacement) {
            REPLACEMENTS.put(old, replacement);
        }

        private static ConfigInheritance orReplacement(ConfigInheritance orig) {
            ConfigInheritance repl = REPLACEMENTS.get(orig);
            if (repl != null) {
                return repl;
            }
            return orig;
        }

        private static class Merged
        extends LegacyAbstractConversion {
            private Merged() {
            }

            @Override
            public InheritanceMode getMode() {
                return InheritanceMode.DEEP_MERGE;
            }

            private ConfigInheritance readResolve() {
                return Legacy.orReplacement(DEEP_MERGE);
            }
        }

        private static class None
        extends LegacyAbstractConversion {
            private None() {
            }

            @Override
            public InheritanceMode getMode() {
                return InheritanceMode.NONE;
            }

            private ConfigInheritance readResolve() {
                return Legacy.orReplacement(NONE);
            }
        }

        private static class Always
        extends LegacyAbstractConversion {
            private Always() {
            }

            @Override
            public InheritanceMode getMode() {
                return InheritanceMode.IF_NO_EXPLICIT_VALUE;
            }

            private ConfigInheritance readResolve() {
                return Legacy.orReplacement(ALWAYS);
            }
        }

        private static abstract class LegacyAbstractConversion
        implements ConfigInheritance {
            private LegacyAbstractConversion() {
            }

            @Override
            public <TContainer, TValue> boolean isReinheritable(ConfigValueAtContainer<TContainer, TValue> parent, ConfigInheritanceContext context) {
                return this.getMode() != InheritanceMode.NONE;
            }

            @Override
            public <TContainer, TValue> boolean considerParent(ConfigValueAtContainer<TContainer, TValue> local, @Nullable ConfigValueAtContainer<TContainer, TValue> parent, ConfigInheritanceContext context) {
                if (parent == null) {
                    return false;
                }
                if (this.getMode() == InheritanceMode.NONE) {
                    return false;
                }
                if (this.getMode() == InheritanceMode.IF_NO_EXPLICIT_VALUE) {
                    return !local.isValueExplicitlySet();
                }
                return true;
            }

            @Override
            public <TContainer, TValue> ReferenceWithError<ConfigValueAtContainer<TContainer, TValue>> resolveWithParent(ConfigValueAtContainer<TContainer, TValue> local, ConfigValueAtContainer<TContainer, TValue> parent, ConfigInheritanceContext context) {
                if (!parent.isValueExplicitlySet()) {
                    return ReferenceWithError.newInstanceWithoutError(new ConfigInheritances.BasicConfigValueAtContainer<TContainer, TValue>(local));
                }
                if (!local.isValueExplicitlySet()) {
                    return ReferenceWithError.newInstanceWithoutError(new ConfigInheritances.BasicConfigValueAtContainer<TContainer, TValue>(parent));
                }
                if (this.getMode() == InheritanceMode.DEEP_MERGE) {
                    ConfigInheritances.BasicConfigValueAtContainer<TContainer, TValue> result = new ConfigInheritances.BasicConfigValueAtContainer<TContainer, TValue>(local);
                    result.setValue(LegacyAbstractConversion.deepMerge(local.asMaybe(), parent.asMaybe()));
                    return ReferenceWithError.newInstanceWithoutError(result);
                }
                throw new IllegalStateException("Unknown config conflict resolution strategy '" + (Object)((Object)this.getMode()) + "' evaluating " + local + "/" + parent);
            }

            private static <T> Maybe<? extends T> deepMerge(Maybe<? extends T> val1, Maybe<? extends T> val2) {
                if (val2.isAbsent() || val2.isNull()) {
                    return val1;
                }
                if (val1.isAbsent()) {
                    return val2;
                }
                if (val1.isNull()) {
                    return val1;
                }
                if (val1.get() instanceof Map && val2.get() instanceof Map) {
                    Maybe<Map<?, ?>> result = Maybe.of(CollectionMerger.builder().build().merge((Map)val1.get(), (Map)val2.get()));
                    return result;
                }
                return val1;
            }

            @Override
            public InheritanceMode isInherited(ConfigKey<?> key, Object from, Object to) {
                return this.getMode();
            }

            protected abstract InheritanceMode getMode();
        }
    }

    @Deprecated
    @Beta
    public static enum InheritanceMode {
        NONE,
        IF_NO_EXPLICIT_VALUE,
        DEEP_MERGE;

    }

    public static interface ConfigInheritanceContext {
    }
}

