/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.ssh;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import org.apache.brooklyn.util.ssh.BashCommandsConfigurable;

public class IptablesCommandsConfigurable {
    private final BashCommandsConfigurable bash;

    public IptablesCommandsConfigurable(BashCommandsConfigurable bash) {
        this.bash = bash;
    }

    @Beta
    public String iptablesService(String cmd) {
        return this.bash.sudo(this.bash.alternatives(this.bash.ifExecutableElse1("service", "service iptables " + cmd), "/sbin/service iptables " + cmd));
    }

    @Beta
    public String iptablesServiceStop() {
        return this.iptablesService("stop");
    }

    @Beta
    public String iptablesServiceStart() {
        return this.iptablesService("start");
    }

    @Beta
    public String iptablesServiceRestart() {
        return this.iptablesService("restart");
    }

    @Beta
    public String iptablesServiceStatus() {
        return this.iptablesService("status");
    }

    @Beta
    public String firewalldService(String cmd) {
        return this.bash.sudo(this.bash.alternatives(this.bash.ifExecutableElse1("systemctl", "systemctl " + cmd + " firewalld"), "/usr/bin/systemctl " + cmd + " firewalld"));
    }

    @Beta
    public String firewalldServiceStop() {
        return this.firewalldService("stop");
    }

    @Beta
    public String firewalldServiceStart() {
        return this.firewalldService("start");
    }

    @Beta
    public String firewalldServiceRestart() {
        return this.firewalldService("restart");
    }

    @Beta
    public String firewalldServiceStatus() {
        return this.firewalldService("status");
    }

    @Beta
    public String firewalldServiceIsActive() {
        return this.firewalldService("is-active");
    }

    public String saveIptablesRules() {
        return this.bash.alternatives(this.bash.sudo("service iptables save"), this.bash.chain(this.bash.installPackage("iptables-persistent"), this.bash.sudo("/etc/init.d/iptables-persistent save")));
    }

    public String cleanUpIptablesRules() {
        return this.bash.sudo("/sbin/iptables -F");
    }

    public String listIptablesRule() {
        return this.bash.sudo("/sbin/iptables -L -v -n");
    }

    public String insertIptablesRule(Chain chain, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return this.addIptablesRule("-I", chain, (Optional<String>)Optional.absent(), protocol, port, policy);
    }

    public String insertIptablesRule(Chain chain, String networkInterface, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return this.addIptablesRule("-I", chain, (Optional<String>)Optional.of((Object)networkInterface), protocol, port, policy);
    }

    public String appendIptablesRule(Chain chain, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return this.addIptablesRule("-A", chain, (Optional<String>)Optional.absent(), protocol, port, policy);
    }

    public String appendIptablesRule(Chain chain, String networkInterface, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return this.addIptablesRule("-A", chain, (Optional<String>)Optional.of((Object)networkInterface), protocol, port, policy);
    }

    public String addIptablesRule(String direction, Chain chain, Optional<String> networkInterface, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        String addIptablesRule = networkInterface.isPresent() ? String.format("/sbin/iptables %s %s -i %s -p %s --dport %d -j %s", new Object[]{direction, chain, networkInterface.get(), protocol, port, policy}) : String.format("/sbin/iptables %s %s -p %s --dport %d -j %s", new Object[]{direction, chain, protocol, port, policy});
        return this.bash.sudo(addIptablesRule);
    }

    public String addFirewalldRule(Chain chain, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return this.addFirewalldRule(chain, (Optional<String>)Optional.absent(), protocol, port, policy);
    }

    public String addFirewalldRule(Chain chain, Optional<String> networkInterface, org.apache.brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        String command = new String("/usr/bin/firewall-cmd");
        String commandPermanent = new String("/usr/bin/firewall-cmd --permanent");
        String interfaceParameter = String.format("%s", networkInterface.isPresent() ? " -i " + (String)networkInterface.get() : "");
        String commandParameters = String.format(" --direct --add-rule ipv4 filter %s 0 %s -p %s --dport %d -j %s", new Object[]{chain, interfaceParameter, protocol, port, policy});
        return this.bash.sudo(this.bash.chain(command + commandParameters, commandPermanent + commandParameters));
    }

    @Deprecated
    public static enum Protocol {
        TCP("tcp"),
        UDP("udp"),
        ALL("all");

        final String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String toString() {
            return this.protocol;
        }

        org.apache.brooklyn.util.net.Protocol convert() {
            switch (this) {
                case TCP: {
                    return org.apache.brooklyn.util.net.Protocol.TCP;
                }
                case UDP: {
                    return org.apache.brooklyn.util.net.Protocol.UDP;
                }
                case ALL: {
                    return org.apache.brooklyn.util.net.Protocol.ALL;
                }
            }
            throw new IllegalStateException("Unexpected protocol " + (Object)((Object)this));
        }
    }

    public static enum Policy {
        ACCEPT,
        REJECT,
        DROP,
        LOG;

    }

    public static enum Chain {
        INPUT,
        FORWARD,
        OUTPUT;

    }
}

