/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.stream;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.brooklyn.util.exceptions.Exceptions;

public abstract class InputStreamSource
implements Supplier<InputStream> {
    private final String name;

    public static InputStreamSource of(String name, byte[] bytes) {
        return new InputStreamSourceFromBytes(name, bytes);
    }

    public static InputStreamSource of(String name, String data, Charset charset) {
        return new InputStreamSourceFromBytes(name, data.getBytes(charset));
    }

    public static InputStreamSource of(String name, String data) {
        return new InputStreamSourceFromBytes(name, data.getBytes());
    }

    public static InputStreamSource of(String name, File data) {
        return new InputStreamSourceFromFile(name, data);
    }

    public static InputStreamSource ofRenewableSupplier(String name, Supplier<InputStream> supplier) {
        return new InputStreamSourceFromSupplier(name, supplier);
    }

    public InputStreamSource(String name) {
        this.name = name;
    }

    public String toString() {
        return "InputStreamSource(" + this.name + ")";
    }

    public static class InputStreamSourceFromFile
    extends InputStreamSource {
        private final File data;

        protected InputStreamSourceFromFile(String name, File data) {
            super(name);
            this.data = data;
        }

        public File getFile() {
            return this.data;
        }

        @Override
        public InputStream get() {
            try {
                return new FileInputStream(this.data);
            }
            catch (FileNotFoundException e) {
                throw Exceptions.propagate(e);
            }
        }
    }

    public static class InputStreamSourceFromBytes
    extends InputStreamSource {
        private final byte[] bytes;

        protected InputStreamSourceFromBytes(String name, byte[] bytes) {
            super(name);
            this.bytes = bytes;
        }

        @Override
        public InputStream get() {
            return new ByteArrayInputStream(this.bytes);
        }
    }

    public static class InputStreamSourceFromSupplier
    extends InputStreamSource {
        private final Supplier<InputStream> supplier;

        protected InputStreamSourceFromSupplier(String name, Supplier<InputStream> supplier) {
            super(name);
            this.supplier = supplier;
        }

        @Override
        public InputStream get() {
            return this.supplier.get();
        }
    }
}

