/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.server.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import org.apache.brooklyn.camp.server.dto.LinkDto;
import org.apache.brooklyn.camp.server.dto.ResourceDto;
import org.apache.brooklyn.camp.server.rest.resource.ApidocRestResource;
import org.apache.brooklyn.camp.server.rest.util.DtoFactory;
import org.apache.brooklyn.camp.spi.AbstractResource;
import org.apache.brooklyn.camp.spi.ApplicationComponent;
import org.apache.brooklyn.camp.spi.ApplicationComponentTemplate;
import org.apache.brooklyn.camp.spi.Assembly;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.Link;
import org.apache.brooklyn.camp.spi.PlatformComponent;
import org.apache.brooklyn.camp.spi.PlatformComponentTemplate;
import org.apache.brooklyn.camp.spi.PlatformRootSummary;

public class PlatformDto
extends ResourceDto {
    private List<LinkDto> assemblyTemplates;
    private List<LinkDto> platformComponentTemplates;
    private List<LinkDto> applicationComponentTemplates;
    private List<LinkDto> assemblies;
    private List<LinkDto> platformComponents;
    private List<LinkDto> applicationComponents;
    private LinkDto apidoc;

    protected PlatformDto() {
    }

    protected PlatformDto(DtoFactory dtoFactory, PlatformRootSummary x) {
        super(dtoFactory, (AbstractResource)x);
        this.platformComponentTemplates = new ArrayList<LinkDto>();
        for (Link t : dtoFactory.getPlatform().platformComponentTemplates().links()) {
            this.platformComponentTemplates.add(LinkDto.newInstance(dtoFactory, PlatformComponentTemplate.class, t));
        }
        this.applicationComponentTemplates = new ArrayList<LinkDto>();
        for (Link t : dtoFactory.getPlatform().applicationComponentTemplates().links()) {
            this.applicationComponentTemplates.add(LinkDto.newInstance(dtoFactory, ApplicationComponentTemplate.class, t));
        }
        this.assemblyTemplates = new ArrayList<LinkDto>();
        for (Link t : dtoFactory.getPlatform().assemblyTemplates().links()) {
            this.assemblyTemplates.add(LinkDto.newInstance(dtoFactory, AssemblyTemplate.class, t));
        }
        this.platformComponents = new ArrayList<LinkDto>();
        for (Link t : dtoFactory.getPlatform().platformComponents().links()) {
            this.platformComponents.add(LinkDto.newInstance(dtoFactory, PlatformComponent.class, t));
        }
        this.applicationComponents = new ArrayList<LinkDto>();
        for (Link t : dtoFactory.getPlatform().applicationComponents().links()) {
            this.applicationComponents.add(LinkDto.newInstance(dtoFactory, ApplicationComponent.class, t));
        }
        this.assemblies = new ArrayList<LinkDto>();
        for (Link t : dtoFactory.getPlatform().assemblies().links()) {
            this.assemblies.add(LinkDto.newInstance(dtoFactory, Assembly.class, t));
        }
        this.apidoc = LinkDto.newInstance(dtoFactory.getUriFactory().uriOfRestResource(ApidocRestResource.class), "API documentation");
    }

    public List<LinkDto> getAssemblyTemplates() {
        return this.assemblyTemplates;
    }

    public List<LinkDto> getPlatformComponentTemplates() {
        return this.platformComponentTemplates;
    }

    public List<LinkDto> getApplicationComponentTemplates() {
        return this.applicationComponentTemplates;
    }

    public List<LinkDto> getAssemblies() {
        return this.assemblies;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<LinkDto> getPlatformComponents() {
        return this.platformComponents;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<LinkDto> getApplicationComponents() {
        return this.applicationComponents;
    }

    public LinkDto getApidoc() {
        return this.apidoc;
    }

    public static PlatformDto newInstance(DtoFactory dtoFactory, PlatformRootSummary x) {
        return new PlatformDto(dtoFactory, x);
    }
}

