/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import java.util.Collection;
import java.util.Set;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.classloading.BrooklynClassLoadingContextSequential;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.core.objs.BasicSpecParameter;
import org.apache.brooklyn.core.plan.PlanToSpecTransformer;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCatalogToSpecTransformer
implements PlanToSpecTransformer {
    private static final Logger log = LoggerFactory.getLogger(JavaCatalogToSpecTransformer.class);
    private ManagementContext mgmt;

    @Override
    public void setManagementContext(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    @Override
    public String getShortDescription() {
        return "Java type instantiator";
    }

    @Override
    public boolean accepts(String planType) {
        return false;
    }

    @Override
    public EntitySpec<? extends Application> createApplicationSpec(String plan) throws UnsupportedTypePlanException {
        throw new UnsupportedTypePlanException(this.getClass().getName() + " doesn't parse application plans.");
    }

    @Override
    public <T, SpecT extends AbstractBrooklynObjectSpec<? extends T, SpecT>> SpecT createCatalogSpec(CatalogItem<T, SpecT> item, Set<String> encounteredTypes) throws UnsupportedTypePlanException {
        String javaType = item.getJavaType();
        if (javaType != null) {
            PolicySpec spec;
            Class<?> type;
            try {
                BrooklynClassLoadingContextSequential ctx = new BrooklynClassLoadingContextSequential(this.mgmt, new BrooklynClassLoadingContext[0]);
                ctx.add(CatalogUtils.newClassLoadingContextForCatalogItems(this.mgmt, item.getCatalogItemId(), item.getCatalogItemIdSearchPath()));
                ctx.addSecondary(JavaBrooklynClassLoadingContext.create(this.mgmt));
                type = ctx.loadClass(javaType);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new IllegalStateException("Unable to load old-style java catalog item type " + javaType + " for item " + item, e);
            }
            if (Entity.class.isAssignableFrom(type)) {
                Class<?> entityType = type;
                spec = EntitySpec.create(entityType).parameters(BasicSpecParameter.fromClass(this.mgmt, entityType));
            } else if (Policy.class.isAssignableFrom(type)) {
                Class<?> policyType = type;
                spec = PolicySpec.create(policyType);
            } else if (Enricher.class.isAssignableFrom(type)) {
                Class<?> enricherType = type;
                spec = EnricherSpec.create(enricherType);
            } else {
                throw new IllegalStateException("Catalog item " + item + " java type " + javaType + " is not a Brooklyn supported object.");
            }
            spec.catalogItemIdAndSearchPath(item.getCatalogItemId(), (Collection)item.getCatalogItemIdSearchPath());
            PolicySpec untypedSpc = spec;
            return (SpecT)untypedSpc;
        }
        throw new UnsupportedTypePlanException(this.getClass().getName() + " parses only old-style catalog items containing only 'type: JavaClass' or javaType in DTO");
    }
}

