/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigInheritance;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.TemplatedStringAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.time.Duration;

public class BrooklynConfigKeys {
    @Deprecated
    public static final ConfigKey<String> BROOKLYN_PERSISTENCE_DIR = BrooklynServerConfig.PERSISTENCE_DIR;
    @Deprecated
    public static final ConfigKey<String> BROOKLYN_DATA_DIR = BrooklynServerConfig.BROOKLYN_DATA_DIR;
    public static final ConfigKey<String> ONBOX_BASE_DIR = ConfigKeys.newStringConfigKey("onbox.base.dir", "Default base directory on target machines where Brooklyn config data is stored; default depends on the location, either ~/brooklyn-managed-processes or /tmp/brooklyn-${username} on localhost");
    public static final ConfigKey<Boolean> SKIP_ON_BOX_BASE_DIR_RESOLUTION = ConfigKeys.newBooleanConfigKey("onbox.base.dir.skipResolution", "Whether to skip on-box directory resolution (which can require ssh'ing), and just assume the directory exists; can be set on machine or on entity", false);
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newStringConfigKey("install.version", "The suggested version of the software to be installed");
    public static final ConfigKey<String> INSTALL_UNIQUE_LABEL = ConfigKeys.newStringConfigKey("install.unique_label", "Provides a label which uniquely identifies an installation, used in the computation of the install dir; this should include something readable, and must include a hash of all data which differentiates an installation (e.g. version, plugins, etc), but should be the same where install dirs can be shared to allow for re-use");
    public static final ConfigKey<Boolean> SKIP_ENTITY_START = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("skip.start")).deprecatedNames("entity.started")).description("Whether to skip the startup process entirely (useful for auto-running software, such as in containers)")).build();
    public static final ConfigKey<Boolean> SKIP_ENTITY_START_IF_RUNNING = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("skip.start.ifRunning")).deprecatedNames("entity.running")).description("Whether to skip the startup process if the entity is detected as already running")).build();
    public static final ConfigKey<Boolean> SKIP_ENTITY_INSTALLATION = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("skip.install")).deprecatedNames("install.skip")).description("Whether to skip the install commands entirely (useful for pre-installed images)")).build();
    public static final ConfigKey<String> PRE_INSTALL_COMMAND = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class, "pre.install.command").description("Command to be run prior to the install phase")).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED)).build();
    public static final ConfigKey<String> POST_INSTALL_COMMAND = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class, "post.install.command").description("Command to be run after the install phase")).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED)).build();
    public static final ConfigKey<String> PRE_CUSTOMIZE_COMMAND = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class, "pre.customize.command").description("Command to be run prior to the customize phase")).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED)).build();
    public static final ConfigKey<String> POST_CUSTOMIZE_COMMAND = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class, "post.customize.command").description("Command to be run after the customize phase")).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED)).build();
    public static final ConfigKey<String> PRE_LAUNCH_COMMAND = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class, "pre.launch.command").description("Command to be run prior to the launch phase")).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED)).build();
    public static final ConfigKey<String> POST_LAUNCH_COMMAND = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class, "post.launch.command").description("Command to be run after the launch phase")).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED)).build();
    public static final MapConfigKey<Object> SHELL_ENVIRONMENT = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder<Object>(Object.class, "shell.env").description("Map of environment variables to pass to the runtime shell. Non-string values are serialized to json before passed to the shell.")).defaultValue(ImmutableMap.of())).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED_ELSE_DEEP_MERGE)).build();
    public static final AttributeSensorAndConfigKey<String, String> INSTALL_DIR = new TemplatedStringAttributeSensorAndConfigKey("install.dir", "Directory in which this software will be installed (if downloading/unpacking artifacts explicitly); uses FreeMarker templating format", "${config['" + ONBOX_BASE_DIR.getName() + "']!config['" + BROOKLYN_DATA_DIR.getName() + "']!'/<ERROR>-ONBOX_BASE_DIR-not-set'}/installs/${(config['install.unique_label']??)?string(config['install.unique_label']!'X',(entity.entityType.simpleName)+((config['install.version']??)?string('_'+(config['install.version']!'X'),'')))}");
    public static final AttributeSensorAndConfigKey<String, String> RUN_DIR = new TemplatedStringAttributeSensorAndConfigKey("run.dir", "Directory from which this software to be run; uses FreeMarker templating format", "${config['" + ONBOX_BASE_DIR.getName() + "']!config['" + BROOKLYN_DATA_DIR.getName() + "']!'/<ERROR>-ONBOX_BASE_DIR-not-set'}/apps/${entity.applicationId}/entities/${entity.entityType.simpleName}_${entity.id}");
    public static final AttributeSensorAndConfigKey<String, String> EXPANDED_INSTALL_DIR = new TemplatedStringAttributeSensorAndConfigKey("expandedinstall.dir", "Directory for installed artifacts (e.g. expanded dir after unpacking .tgz)", null);
    public static final ConfigKey<Boolean> PROVISION_LATCH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("latch.provision")).deprecatedNames("provision.latch")).description("Latch for blocking machine provisioning; if non-null will wait for this to resolve (normal use is with '$brooklyn:attributeWhenReady')")).build();
    public static final ConfigKey<Boolean> START_LATCH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("latch.start")).deprecatedNames("start.latch")).description("Latch for blocking start (done post-provisioning for software processes); if non-null will wait for this to resolve (normal use is with '$brooklyn:attributeWhenReady')")).build();
    @Beta
    public static final ConfigKey<Boolean> STOP_LATCH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("latch.stop")).deprecatedNames("stop.latch")).description("Latch for blocking stop; if non-null will wait for at most 1 minute for this to resolve (normal use is with '$brooklyn:attributeWhenReady')")).build();
    public static final ConfigKey<Boolean> SETUP_LATCH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("latch.setup")).deprecatedNames("setup.latch")).description("Latch for blocking setup; if non-null will wait for this to resolve (normal use is with '$brooklyn:attributeWhenReady')")).build();
    public static final ConfigKey<Boolean> PRE_INSTALL_RESOURCES_LATCH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("latch.preInstall.resources")).deprecatedNames("resources.preInstall.latch")).description("Latch for blocking files being copied before the pre-install; if non-null will wait for this to resolve (normal use is with '$brooklyn:attributeWhenReady')")).build();
    public static final ConfigKey<Boolean> INSTALL_RESOURCES_LATCH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("latch.install.resources")).deprecatedNames("resources.install.latch")).description("Latch for blocking files being copied before the install; if non-null will wait for this to resolve (normal use is with '$brooklyn:attributeWhenReady')")).build();
    public static final ConfigKey<Boolean> INSTALL_LATCH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("latch.install")).deprecatedNames("install.latch")).description("Latch for blocking install; if non-null will wait for this to resolve (normal use is with '$brooklyn:attributeWhenReady')")).build();
    public static final ConfigKey<Boolean> CUSTOMIZE_RESOURCES_LATCH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("latch.customize.resources")).deprecatedNames("resources.customize.latch")).description("Latch for blocking files being copied before customize; if non-null will wait for this to resolve (normal use is with '$brooklyn:attributeWhenReady')")).build();
    public static final ConfigKey<Boolean> CUSTOMIZE_LATCH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("latch.customize")).deprecatedNames("customize.latch")).description("Latch for blocking customize; if non-null will wait for this to resolve (normal use is with '$brooklyn:attributeWhenReady')")).build();
    public static final ConfigKey<Boolean> RUNTIME_RESOURCES_LATCH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("latch.launch.resources")).deprecatedNames("resources.runtime.latch")).description("Latch for blocking files being copied before the launch; if non-null will wait for this to resolve (normal use is with '$brooklyn:attributeWhenReady')")).build();
    public static final ConfigKey<Boolean> LAUNCH_LATCH = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Boolean.class).name("latch.launch")).deprecatedNames("launch.latch")).description("Latch for blocking luanch; if non-null will wait for this to resolve (normal use is with '$brooklyn:attributeWhenReady')")).build();
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKey("start.timeout", "Time to wait, after launching, for SERVICE_UP before failing", Duration.seconds((Number)120));
    public static final String BROOKLYN_SSH_CONFIG_KEY_PREFIX = "brooklyn.ssh.config.";
    public static final String BROOKLYN_WINRM_CONFIG_KEY_PREFIX = "brooklyn.winrm.config.";
    public static final ConfigKey<String> SSH_TOOL_CLASS;
    public static final ConfigKey<String> WINRM_TOOL_CLASS;
    @Deprecated
    public static final ConfigKey<String> LEGACY_SSH_TOOL_CLASS;
    public static final ConfigKey<String> SSH_CONFIG_HOST;
    public static final ConfigKey<Integer> SSH_CONFIG_PORT;
    public static final ConfigKey<String> SSH_CONFIG_USER;
    public static final ConfigKey<String> SSH_CONFIG_PASSWORD;
    public static final ConfigKey<String> SSH_CONFIG_SCRIPT_DIR;
    public static final ConfigKey<String> SSH_CONFIG_SCRIPT_HEADER;
    public static final ConfigKey<String> SSH_CONFIG_DIRECT_HEADER;
    public static final ConfigKey<Boolean> SSH_CONFIG_NO_DELETE_SCRIPT;
    public static final ConfigKey<Boolean> SSH_CONFIG_SCRIPTS_IGNORE_CERTS;
    public static final MapConfigKey<Object> PROVISIONING_PROPERTIES;
    public static final ConfigKey<String> ICON_URL;
    public static final ConfigKey<String> PLAN_ID;
    public static final ConfigKey<String> TEMPLATE_ID;

    private BrooklynConfigKeys() {
    }

    static {
        assert (BROOKLYN_SSH_CONFIG_KEY_PREFIX.equals(BROOKLYN_SSH_CONFIG_KEY_PREFIX)) : "static final initializer classload ordering problem";
        SSH_TOOL_CLASS = ConfigKeys.newStringConfigKey("brooklyn.ssh.config.sshToolClass", "SshTool implementation to use (or null for default)", null);
        WINRM_TOOL_CLASS = ConfigKeys.newStringConfigKey("brooklyn.winrm.config.winrmToolClass", "WinRmTool implementation to use (or null for default)", null);
        LEGACY_SSH_TOOL_CLASS = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, (ConfigKey)Preconditions.checkNotNull(SshTool.PROP_TOOL_CLASS, (Object)"static final initializer classload ordering problem"));
        SSH_CONFIG_HOST = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, SshTool.PROP_HOST);
        SSH_CONFIG_PORT = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, SshTool.PROP_PORT);
        SSH_CONFIG_USER = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, SshTool.PROP_USER);
        SSH_CONFIG_PASSWORD = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, SshTool.PROP_PASSWORD);
        SSH_CONFIG_SCRIPT_DIR = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, (ConfigKey)Preconditions.checkNotNull(ShellTool.PROP_SCRIPT_DIR, (Object)"static final initializer classload ordering problem"));
        SSH_CONFIG_SCRIPT_HEADER = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, ShellTool.PROP_SCRIPT_HEADER);
        SSH_CONFIG_DIRECT_HEADER = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, ShellTool.PROP_DIRECT_HEADER);
        SSH_CONFIG_NO_DELETE_SCRIPT = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, ShellTool.PROP_NO_DELETE_SCRIPT);
        SSH_CONFIG_SCRIPTS_IGNORE_CERTS = ConfigKeys.newBooleanConfigKey("brooklyn.ssh.config.scripts.ignoreCerts", "Whether to generate OS commands that ignore certs, e.g. curl -k");
        PROVISIONING_PROPERTIES = ((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)((MapConfigKey.Builder)new MapConfigKey.Builder<Object>(Object.class, "provisioning.properties").description("Custom properties to be passed in to the location when provisioning a new machine")).defaultValue(ImmutableMap.of())).typeInheritance(BasicConfigInheritance.DEEP_MERGE)).runtimeInheritance(BasicConfigInheritance.NOT_REINHERITED_ELSE_DEEP_MERGE)).build();
        ICON_URL = ConfigKeys.newStringConfigKey("iconUrl");
        PLAN_ID = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class, "camp.plan.id").description("Identifier supplied in the deployment plan for component to which this entity corresponds (human-readable, for correlating across plan, template, and instance)")).runtimeInheritance(BasicConfigInheritance.NEVER_INHERITED)).build();
        TEMPLATE_ID = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class, "camp.template.id").description("UID of the component in the template from which this entity was created")).runtimeInheritance(BasicConfigInheritance.NEVER_INHERITED)).build();
    }
}

