/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.feed;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.feed.AttributePollHandler;
import org.apache.brooklyn.core.feed.DelegatingPollHandler;
import org.apache.brooklyn.core.feed.PollConfig;
import org.apache.brooklyn.core.feed.PollHandler;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.objs.AbstractEntityAdjunct;
import org.apache.brooklyn.core.sensor.AbstractAddTriggerableSensor;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.DynamicSequentialTask;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.ScheduledTask;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Poller<V> {
    public static final Logger log = LoggerFactory.getLogger(Poller.class);
    private final Entity entity;
    private final AbstractEntityAdjunct adjunct;
    private final boolean onlyIfServiceUp;
    private final Set<Callable<?>> oneOffJobs = new LinkedHashSet();
    private final Set<PollJob<V>> pollJobs = new LinkedHashSet<PollJob<V>>();
    private final Set<Task<?>> oneOffTasks = new LinkedHashSet();
    private final Set<ScheduledTask> scheduledTasks = new LinkedHashSet<ScheduledTask>();
    private volatile boolean started = false;

    public <PI, PC extends PollConfig> void scheduleFeed(AbstractFeed feed, SetMultimap<PI, PC> polls, Function<PI, Callable<?>> jobFactory) {
        for (Object identifer : polls.keySet()) {
            Set pollConfigs = polls.get(identifer);
            LinkedHashSet handlers = Sets.newLinkedHashSet();
            for (PollConfig config : pollConfigs) {
                handlers.add(new AttributePollHandler(config, this.entity, feed));
            }
            Callable<?> pollCallable = jobFactory.apply(identifer);
            DelegatingPollHandler handlerDelegate = new DelegatingPollHandler(handlers);
            this.schedulePoll(feed, pollConfigs, pollCallable, handlerDelegate);
        }
    }

    public void schedulePoll(AbstractEntityAdjunct feed, Set<? extends PollConfig> pollConfigs, Callable pollCallable, PollHandler pollHandler) {
        boolean subscribed = false;
        long minPeriodMillis = Long.MAX_VALUE;
        boolean overallSkipInitialRun = false;
        MutableSet conditions = MutableSet.of();
        for (PollConfig pollConfig : pollConfigs) {
            conditions.add(pollConfig.getCondition());
            if (pollConfig.getPeriod() > 0L) {
                minPeriodMillis = Math.min(minPeriodMillis, pollConfig.getPeriod());
            }
            MutableSet triggersResolved = MutableSet.of();
            if (pollConfig.getOtherTriggers() != null) {
                triggersResolved.addAll(AbstractAddTriggerableSensor.resolveTriggers(feed.getEntity(), pollConfig.getOtherTriggers()));
            }
            if (this.onlyIfServiceUp) {
                triggersResolved.add(Pair.of((Object)feed.getEntity(), Attributes.SERVICE_UP));
            }
            for (Pair pair : triggersResolved) {
                this.subscribe(pollCallable, pollHandler, (Entity)pair.getLeft(), (Sensor)pair.getRight(), Boolean.TRUE.equals(pollConfig.getSkipInitialRun()), pollConfig.getCondition());
                subscribed = true;
            }
            overallSkipInitialRun |= Boolean.TRUE.equals(pollConfig.getSkipInitialRun());
        }
        if (!(minPeriodMillis <= 0L || minPeriodMillis >= Duration.PRACTICALLY_FOREVER.toMilliseconds() && subscribed)) {
            Object condition = null;
            if (!conditions.isEmpty()) {
                condition = conditions.size() == 1 ? (Supplier<DslPredicates.DslPredicate>)Iterables.getOnlyElement((Iterable)conditions) : (conditions.contains(null) ? null : () -> Poller.lambda$schedulePoll$0((Set)conditions));
            }
            this.scheduleAtFixedRate(pollCallable, pollHandler, Duration.millis((Number)minPeriodMillis), overallSkipInitialRun, (Supplier<DslPredicates.DslPredicate>)condition);
        }
    }

    public Poller(Entity entity, AbstractEntityAdjunct adjunct, boolean onlyIfServiceUp) {
        this.entity = entity;
        this.adjunct = adjunct;
        this.onlyIfServiceUp = onlyIfServiceUp;
    }

    public void submit(Callable<?> job) {
        if (this.started) {
            throw new IllegalStateException("Cannot submit additional tasks after poller has started");
        }
        this.oneOffJobs.add(job);
    }

    public void scheduleAtFixedRate(Callable<V> job, PollHandler<? super V> handler, long periodMillis) {
        this.scheduleAtFixedRate(job, handler, Duration.millis((Number)periodMillis), false, null);
    }

    public void scheduleAtFixedRate(Callable<V> job, PollHandler<? super V> handler, Duration period) {
        this.scheduleAtFixedRate(job, handler, period, false, null);
    }

    public void scheduleAtFixedRate(Callable<V> job, PollHandler<? super V> handler, Duration period, Supplier<DslPredicates.DslPredicate> pollCondition) {
        this.scheduleAtFixedRate(job, handler, period, false, pollCondition);
    }

    public void scheduleAtFixedRate(Callable<V> job, PollHandler<? super V> handler, Duration period, boolean skipInitialRun, Supplier<DslPredicates.DslPredicate> pollCondition) {
        if (this.started) {
            throw new IllegalStateException("Cannot schedule additional tasks after poller has started");
        }
        PollJob<? super V> foo = new PollJob<V>(job, handler, period, null, null, skipInitialRun, pollCondition);
        this.pollJobs.add(foo);
    }

    public void subscribe(Callable<V> job, PollHandler<? super V> handler, Entity sensorSource, Sensor<?> sensor, Supplier<DslPredicates.DslPredicate> condition) {
        this.subscribe(job, handler, sensorSource, sensor, false, condition);
    }

    public void subscribe(Callable<V> job, PollHandler<? super V> handler, Entity sensorSource, Sensor<?> sensor, boolean skipInitialRun, Supplier<DslPredicates.DslPredicate> condition) {
        this.pollJobs.add(new PollJob<V>(job, handler, null, sensorSource, sensor, skipInitialRun, condition));
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug("Starting poll for {} (using {})", new Object[]{this.entity, this});
        }
        if (this.started) {
            throw new IllegalStateException(String.format("Attempt to start poller %s of entity %s when already running", this, this.entity));
        }
        this.started = true;
        for (Callable<?> oneOffJob : this.oneOffJobs) {
            Task task = Tasks.builder().dynamic(false).body(oneOffJob).displayName("Poll").description("One-time poll job " + oneOffJob).build();
            this.oneOffTasks.add(this.adjunct.getExecutionContext().submit(task));
        }
        Duration minPeriod = null;
        MutableSet sensorSummaries = MutableSet.of();
        Function<PollJob, String> scheduleNameFn = pollJob -> MutableList.of((Object)(this.adjunct != null ? this.adjunct.getDisplayName() : null), (Object)pollJob.handler.getDescription()).stream().filter(Strings::isNonBlank).collect(Collectors.joining("; "));
        BiFunction<Runnable, String, Task> tf = (job, scheduleName) -> {
            DynamicSequentialTask<Void> task = new DynamicSequentialTask<Void>((Map<?, ?>)MutableMap.of((Object)"displayName", (Object)scheduleName, (Object)"entity", (Object)this.entity), () -> {
                if (!Entities.isManagedActive(this.entity)) {
                    return null;
                }
                if (this.onlyIfServiceUp && !Boolean.TRUE.equals(this.entity.getAttribute(Attributes.SERVICE_UP))) {
                    return null;
                }
                job.run();
                return null;
            });
            BrooklynTaskTags.addTagDynamically(task, "NON-TRANSIENT");
            return task;
        };
        SetMultimap nonScheduledJobs = Multimaps.newSetMultimap((Map)MutableMap.of(), MutableSet::of);
        this.pollJobs.stream().filter(pj -> !pj.skipInitialRun).forEach(arg_0 -> Poller.lambda$start$5((Multimap)nonScheduledJobs, arg_0));
        for (PollJob<V> pollJob2 : this.pollJobs) {
            String scheduleName2 = scheduleNameFn.apply(pollJob2);
            boolean added = false;
            if (pollJob2.pollPeriod != null && pollJob2.pollPeriod.compareTo(Duration.ZERO) > 0) {
                ScheduledTask.Builder tb = ScheduledTask.builder(() -> (Task)tf.apply(pollJob.wrappedJob, scheduleName2)).cancelOnException(false).tag(this.adjunct != null ? BrooklynTaskTags.tagForContextAdjunct(this.adjunct) : null);
                added = true;
                tb.displayName("Periodic: " + scheduleName2);
                tb.period(pollJob2.pollPeriod);
                if (pollJob2.skipInitialRun) {
                    tb.delay(pollJob2.pollPeriod);
                }
                if (minPeriod == null || pollJob2.pollPeriod.isShorterThan(minPeriod)) {
                    minPeriod = pollJob2.pollPeriod;
                }
                ScheduledTask st = tb.build();
                this.scheduledTasks.add(st);
                log.debug("Submitting scheduled task " + st + " for poll/feed " + this + ", job " + pollJob2);
                Entities.submit(this.entity, st);
                nonScheduledJobs.removeAll(pollJob2.job);
            }
            if (pollJob2.pollTriggerSensor != null) {
                added = true;
                if (pollJob2.subscription != null) {
                    throw new IllegalStateException(String.format("Attempt to start poller %s of entity %s when already has subscription %s", this, this.entity, pollJob2.subscription));
                }
                String summary = pollJob2.pollTriggerSensor.getName();
                if (pollJob2.pollTriggerEntity != null && !pollJob2.pollTriggerEntity.equals(this.entity)) {
                    summary = summary + " on " + pollJob2.pollTriggerEntity;
                }
                log.debug("Adding subscription to " + summary + " for poll/feed " + this + ", job " + pollJob2);
                sensorSummaries.add(summary);
                pollJob2.subscription = this.adjunct.subscriptions().subscribe(pollJob2.pollTriggerEntity != null ? pollJob2.pollTriggerEntity : this.adjunct.getEntity(), pollJob2.pollTriggerSensor, event -> {
                    try {
                        this.adjunct.getExecutionContext().submit((TaskAdaptable)tf.apply(pollJob.wrappedJob, scheduleName2));
                    }
                    catch (Exception e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                });
            }
            if (added || !log.isDebugEnabled()) continue;
            log.debug("Empty poll job " + pollJob2 + " in " + this + " for " + this.entity + "; if all jobs are empty (or trigger only), will add a trivial one-time initial task");
        }
        nonScheduledJobs.asMap().forEach((jobC, jobP) -> {
            Runnable job = ((PollJob)jobP.iterator().next()).wrappedJob;
            String jobSummaries = jobP.stream().map(j -> j.handler.getDescription()).filter(Strings::isNonBlank).collect(Collectors.joining(", "));
            String name = (this.adjunct != null ? this.adjunct.getDisplayName() : "anonymous") + (Strings.isNonBlank((CharSequence)jobSummaries) ? "; " + jobSummaries : "");
            Task<Object> t = Tasks.builder().dynamic(true).displayName("Initial: " + name).body(() -> ((Task)DynamicTasks.queue((TaskAdaptable)tf.apply(job, name))).getUnchecked()).tag(this.adjunct != null ? BrooklynTaskTags.tagForContextAdjunct(this.adjunct) : null).build();
            log.debug("Submitting initial task " + t + " for poll/feed " + this + ", job " + job + " (because otherwise is trigger-only)");
            Entities.submit(this.entity, t);
        });
        if (this.adjunct != null) {
            if (sensorSummaries.isEmpty()) {
                if (minPeriod == null || minPeriod.equals((Object)Duration.PRACTICALLY_FOREVER) || !minPeriod.isPositive()) {
                    this.adjunct.highlightTriggers("Not configured with a period or triggers");
                } else {
                    this.highlightTriggerPeriod(minPeriod);
                }
            } else if (minPeriod == null) {
                this.adjunct.highlightTriggers("Triggered by: " + Strings.join((Iterable)sensorSummaries, (String)"; "));
            } else {
                this.adjunct.highlightTriggers("Running every " + minPeriod + " and on triggers: " + Strings.join((Iterable)sensorSummaries, (String)"; "));
            }
        }
    }

    void highlightTriggerPeriod(Duration minPeriod) {
        this.adjunct.highlightTriggers("Running every " + minPeriod);
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug("Stopping poll for {} (using {})", new Object[]{this.entity, this});
        }
        if (!this.started) {
            throw new IllegalStateException(String.format("Attempt to stop poller %s of entity %s when not running", this, this.entity));
        }
        this.started = false;
        for (Task<?> task : this.oneOffTasks) {
            if (task == null) continue;
            task.cancel(true);
        }
        for (ScheduledTask scheduledTask : this.scheduledTasks) {
            if (scheduledTask == null) continue;
            scheduledTask.cancel();
        }
        for (PollJob pollJob : this.pollJobs) {
            if (pollJob.subscription == null) continue;
            this.adjunct.subscriptions().unsubscribe(pollJob.subscription);
            pollJob.subscription = null;
        }
        this.oneOffTasks.clear();
        this.scheduledTasks.clear();
    }

    public boolean isRunning() {
        boolean hasActiveTasks = false;
        for (Task task : this.scheduledTasks) {
            if (!task.isBegun() || task.isDone()) continue;
            hasActiveTasks = true;
            break;
        }
        boolean hasSubscriptions = this.pollJobs.stream().anyMatch(j -> j.subscription != null);
        if (!this.started && hasActiveTasks) {
            log.warn("Poller should not be running, but has active tasks, tasks: " + this.scheduledTasks);
        }
        if (!this.started && hasSubscriptions) {
            log.warn("Poller should not be running, but has subscriptions on jobs: " + this.pollJobs);
        }
        return this.started && (hasActiveTasks || hasSubscriptions);
    }

    protected boolean isEmpty() {
        return this.pollJobs.isEmpty();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entity", (Object)this.entity).toString();
    }

    private static /* synthetic */ void lambda$start$5(Multimap nonScheduledJobs, PollJob pollJob) {
        nonScheduledJobs.put(pollJob.job, (Object)pollJob);
    }

    private static /* synthetic */ DslPredicates.DslPredicate lambda$schedulePoll$0(Set conditions) {
        DslPredicates.DslPredicateDefault aggregate = new DslPredicates.DslPredicateDefault();
        aggregate.any = conditions.stream().collect(Collectors.toList());
        return aggregate;
    }

    private static class PollJob<V> {
        final PollHandler<? super V> handler;
        final Duration pollPeriod;
        boolean skipInitialRun = false;
        final Callable<?> job;
        final Runnable wrappedJob;
        final Entity pollTriggerEntity;
        final Sensor<?> pollTriggerSensor;
        final Supplier<DslPredicates.DslPredicate> pollCondition;
        SubscriptionHandle subscription;
        private boolean loggedPreviousException = false;

        PollJob(Callable<V> job, PollHandler<? super V> handler, Duration period) {
            this(job, handler, period, null, null, false, null);
        }

        PollJob(final Callable<V> job, final PollHandler<? super V> handler, Duration period, Entity sensorSource, Sensor<?> sensor, boolean skipInitialRun, final Supplier<DslPredicates.DslPredicate> pollCondition) {
            this.handler = handler;
            this.pollPeriod = period;
            this.pollTriggerEntity = sensorSource;
            this.pollTriggerSensor = sensor;
            this.skipInitialRun = skipInitialRun;
            this.pollCondition = pollCondition;
            this.job = job;
            this.wrappedJob = new Runnable(){

                @Override
                public void run() {
                    try {
                        DslPredicates.DslPredicate pc;
                        if (pollCondition != null && (pc = (DslPredicates.DslPredicate)pollCondition.get()) != null && !pc.apply(BrooklynTaskTags.getContextEntity(Tasks.current()))) {
                            if (log.isTraceEnabled()) {
                                log.trace("Skipping execution for PollJob {} because condition does not apply", (Object)job);
                            }
                            log.debug("Skipping poll/feed execution because condition does not apply");
                            return;
                        }
                        Object val = job.call();
                        if (handler.checkSuccess(val)) {
                            handler.onSuccess(val);
                        } else {
                            handler.onFailure(val);
                        }
                        loggedPreviousException = false;
                    }
                    catch (Exception e) {
                        if (loggedPreviousException) {
                            if (log.isTraceEnabled()) {
                                log.trace("PollJob for {}, repeated consecutive failures, handling {} using {}", new Object[]{job, e, handler});
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("PollJob for {}, repeated consecutive failures, handling {} using {}", new Object[]{job, e, handler});
                            }
                            loggedPreviousException = true;
                        }
                        handler.onException(e);
                    }
                }
            };
        }
    }
}

