/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.internal.storage.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.brooklyn.core.internal.storage.Reference;

class BackedReference<T>
implements Reference<T> {
    private final Map<String, ? super T> backingMap;
    private final String key;

    BackedReference(Map<String, ? super T> backingMap, String key) {
        this.backingMap = (Map)Preconditions.checkNotNull(backingMap, (Object)"backingMap");
        this.key = key;
    }

    @Override
    public T get() {
        return this.backingMap.get(this.key);
    }

    @Override
    public T set(T val) {
        if (val == null) {
            return this.backingMap.remove(this.key);
        }
        return this.backingMap.put(this.key, val);
    }

    public String toString() {
        return "" + this.get();
    }

    @Override
    public boolean isNull() {
        return this.get() == null;
    }

    @Override
    public void clear() {
        this.set(null);
    }

    @Override
    public boolean contains(Object other) {
        return Objects.equal(this.get(), (Object)other);
    }
}

