/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.entitlement;

import java.util.Map;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.javalang.JavaClassNames;

public class WebEntitlementContext
implements EntitlementContext {
    public static final String USER_GROUPS = "brooklyn.entitlements.user.groups";
    public static final String USER_GROUPS_ORIGIN = "brooklyn.entitlements.user.groups.origin";
    final String user;
    final String sourceIp;
    final String requestUri;
    final Map<String, Object> attributes = MutableMap.of();
    final String requestUniqueIdentifier;

    public WebEntitlementContext(String user, String sourceIp, String requestUri, String requestUniqueIdentifier) {
        this(user, sourceIp, requestUri, requestUniqueIdentifier, null);
    }

    public WebEntitlementContext(String user, String sourceIp, String requestUri, String requestUniqueIdentifier, Map<String, Object> attributes) {
        this.user = user;
        this.sourceIp = sourceIp;
        this.requestUri = requestUri;
        this.requestUniqueIdentifier = requestUniqueIdentifier;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public String user() {
        return this.user;
    }

    public String sourceIp() {
        return this.sourceIp;
    }

    public String requestUri() {
        return this.requestUri;
    }

    public String requestUniqueIdentifier() {
        return this.requestUniqueIdentifier;
    }

    public Map<String, Object> attributes() {
        return this.attributes;
    }

    public String toString() {
        return JavaClassNames.simpleClassName(this.getClass()) + "[" + this.user + "@" + this.sourceIp + ":" + this.requestUniqueIdentifier + "]";
    }
}

