/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityInitializer;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepResolution;
import org.apache.brooklyn.core.workflow.steps.appmodel.HasBlueprintWorkflowStep;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.yaml.Yamls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyInitializerWorkflowStep
extends WorkflowStepDefinition
implements HasBlueprintWorkflowStep {
    private static final Logger LOG = LoggerFactory.getLogger(ApplyInitializerWorkflowStep.class);
    public static final String SHORTHAND = "[ ${type} [ \" at \" ${entity} ] ]";
    public static final ConfigKey<Object> ENTITY = ConfigKeys.newConfigKey(Object.class, "entity");

    @Override
    public Logger logger() {
        return LOG;
    }

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    public void validateStep(@Nullable ManagementContext mgmt, @Nullable WorkflowExecutionContext workflow) {
        super.validateStep(mgmt, workflow);
        this.validateStepBlueprint(mgmt, workflow);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        EntityInitializer initializer;
        Object entityToFind = context.getInput(ENTITY);
        Entity entity = entityToFind != null ? (Entity)WorkflowStepResolution.findEntity(context, entityToFind).get() : context.getEntity();
        Object blueprint = this.resolveBlueprint(context);
        try {
            if (blueprint instanceof EntityInitializer) {
                initializer = (EntityInitializer)blueprint;
            } else {
                if (!(blueprint instanceof String)) {
                    blueprint = BeanWithTypeUtils.newYamlMapper(null, false, null, false).writeValueAsString(blueprint);
                }
                Object yo = Iterables.getOnlyElement((Iterable)Yamls.parseAll((String)((String)blueprint)));
                initializer = (EntityInitializer)TypeCoercions.tryCoerce(yo, EntityInitializer.class).get();
            }
        }
        catch (Exception e) {
            throw Exceptions.propagateAnnotated((String)"Cannot make policy or adjunct from blueprint", (Throwable)e);
        }
        initializer.apply((EntityLocal)entity);
        return context.getPreviousStepOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }
}

