/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.steps.variables.WorkflowTransformDefault;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.text.Strings;

public class TransformPrependAppend
extends WorkflowTransformDefault {
    boolean atEnd;
    String expression;

    public TransformPrependAppend(boolean atEnd) {
        this.atEnd = atEnd;
    }

    @Override
    protected void initCheckingDefinition() {
        MutableList d = MutableList.copyOf(this.definition.subList(1, this.definition.size()));
        if (d.size() != 1) {
            throw new IllegalArgumentException("Transform requires a single argument being the item to prepend or append");
        }
        this.expression = (String)d.get(0);
    }

    public Object apply(Object v) {
        Object expressionResolved = this.context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, (Object)this.expression, Object.class);
        if (v instanceof String || Boxing.isPrimitiveOrBoxedObject((Object)v)) {
            if (!(expressionResolved instanceof String) && !Boxing.isPrimitiveOrBoxedObject((Object)expressionResolved)) {
                throw new IllegalStateException("Argument must be a string or primitive to prepend/append");
            }
            if (this.atEnd) {
                return Strings.toString((Object)v) + expressionResolved;
            }
            return expressionResolved + Strings.toString((Object)v);
        }
        if (v instanceof Iterable) {
            MutableList list = MutableList.copyOf((Iterable)((Iterable)v));
            if (this.atEnd) {
                list.add(expressionResolved);
            } else {
                list.add(0, expressionResolved);
            }
            return list;
        }
        throw new IllegalStateException("Input must be a list or a string/primitive to prepend/append");
    }
}

