/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.classloading.BrooklynClassLoadingContextSequential;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.BundleUpgradeParser;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.LoaderDispatcher;
import org.apache.brooklyn.util.core.osgi.Osgis;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderUtils.class);
    static final String WHITE_LIST_KEY = "org.apache.brooklyn.classloader.fallback.bundles";
    static final String CLASS_NAME_DELIMITER = ":";
    private static final String WHITE_LIST_DEFAULT = "org\\.apache\\.brooklyn\\..*:" + BrooklynVersion.getOsgiVersion();
    private Map<String, String> SYMBOLIC_NAME_UPDATES = ImmutableMap.builder().put((Object)"org.apache.commons.codec", (Object)"org.apache.commons.commons-codec").build();
    private final ClassLoader classLoader;
    private final Entity entity;
    private final ManagementContext mgmt;

    public ClassLoaderUtils(Object callingObj, Entity entity) {
        this(callingObj.getClass(), entity);
    }

    public ClassLoaderUtils(Object callingObj, @Nullable ManagementContext mgmt) {
        this(callingObj.getClass(), mgmt);
    }

    public ClassLoaderUtils(Class<?> callingClass) {
        Preconditions.checkNotNull(callingClass, (Object)"callingClass");
        this.classLoader = this.getValidClassLoader(callingClass.getClassLoader());
        this.entity = null;
        this.mgmt = null;
    }

    public ClassLoaderUtils(@Nullable ClassLoader cl) {
        this.classLoader = this.getValidClassLoader(cl);
        this.entity = null;
        this.mgmt = null;
    }

    public ClassLoaderUtils(@Nullable ClassLoader cl, @Nullable ManagementContext mgmt) {
        this.classLoader = this.getValidClassLoader(cl);
        this.entity = null;
        this.mgmt = mgmt;
    }

    public ClassLoaderUtils(Class<?> callingClass, Entity entity) {
        Preconditions.checkNotNull(callingClass, (Object)"callingClass");
        this.classLoader = this.getValidClassLoader(callingClass.getClassLoader());
        this.entity = (Entity)Preconditions.checkNotNull((Object)entity, (Object)"entity");
        this.mgmt = ((EntityInternal)entity).getManagementContext();
    }

    public ClassLoaderUtils(Class<?> callingClass, @Nullable ManagementContext mgmt) {
        Preconditions.checkNotNull(callingClass, (Object)"callingClass");
        this.classLoader = this.getValidClassLoader(callingClass.getClassLoader());
        this.entity = null;
        this.mgmt = mgmt;
    }

    protected ClassLoader getValidClassLoader(ClassLoader cl) {
        return cl != null ? cl : this.getClass().getClassLoader();
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Maybe cls = this.load(name, LoaderDispatcher.ClassLoaderDispatcher.INSTANCE);
        if (cls.isPresent()) {
            return (Class)cls.get();
        }
        throw new ClassNotFoundException("Class " + name + " not found on the application class path, nor in the bundle white list.", this.getReturnException(cls));
    }

    public Class<?> loadClass(String symbolicName, @Nullable String version, String className) throws ClassNotFoundException {
        try {
            return (Class)this.tryLoadFromBundle(LoaderDispatcher.ClassLoaderDispatcher.INSTANCE, symbolicName, version, className).get();
        }
        catch (IllegalStateException e) {
            throw new ClassNotFoundException("Class " + className + " could not be loaded from bundle " + this.toBundleString(symbolicName, version), e);
        }
    }

    public URL getResource(String name) {
        return (URL)this.load(this.stripLeadingSlash(name), LoaderDispatcher.ResourceLoaderDispatcher.INSTANCE).orNull();
    }

    public Iterable<URL> getResources(String name) {
        Maybe<Iterable<URL>> ret = this.load(this.stripLeadingSlash(name), LoaderDispatcher.MultipleResourceLoaderDispatcher.INSTANCE);
        if (ret.isPresent()) {
            return (Iterable)ret.get();
        }
        return ImmutableList.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> Maybe<T> load(String name, LoaderDispatcher<T> dispatcher) {
        String className;
        String version;
        String symbolicName;
        if (this.looksLikeBundledClassName(name)) {
            String[] arr = name.split(CLASS_NAME_DELIMITER);
            if (arr.length > 3) {
                throw new IllegalStateException("'" + name + "' doesn't look like a class name and contains too many colons to be parsed as bundle:version:class triple.");
            }
            if (arr.length == 3) {
                symbolicName = arr[0];
                version = arr[1];
                className = arr[2];
            } else {
                if (arr.length != 2) throw new IllegalStateException("'" + name + "' contains a bundle:version:class delimiter, but only one of those specified");
                symbolicName = arr[0];
                version = null;
                className = arr[1];
            }
        } else {
            symbolicName = null;
            version = null;
            className = name;
        }
        if (symbolicName != null && version != null) {
            return this.tryLoadFromBundle(dispatcher, symbolicName, version, className);
        }
        if (symbolicName == null) return this.loadClass(name, dispatcher, className);
        Maybe<T> cls = this.tryLoadFromBundle(dispatcher, symbolicName, version, className);
        if (cls.isPresent()) {
            return cls;
        }
        Maybe<T> result = this.loadClass(name, dispatcher, className);
        String notFoundWithSymbolicNameMessage = "No class '" + className + "' in bundle '" + symbolicName + "' (using spec '" + name + "')";
        if (!result.isPresent()) return Maybe.absent((String)notFoundWithSymbolicNameMessage);
        log.warn(notFoundWithSymbolicNameMessage + "; found using deprecated no-bundle syntax, but this behaviour is deprecated and likely to be unsupported in future. Change so invalid bundle is not supplied.");
        return this.loadClass(name, dispatcher, className);
    }

    private <T> Maybe<T> loadClass(String name, LoaderDispatcher<T> dispatcher, String className) {
        Maybe<T> cls;
        String catalogItemId;
        if (this.entity != null && this.mgmt != null && (catalogItemId = this.entity.getCatalogItemId()) != null) {
            CatalogItem<?, ?> item;
            BrooklynClassLoadingContextSequential loader = new BrooklynClassLoadingContextSequential(this.mgmt, new BrooklynClassLoadingContext[0]);
            loader.add(CatalogUtils.newClassLoadingContextForCatalogItems(this.mgmt, catalogItemId, this.entity.getCatalogItemIdSearchPath()));
            cls = dispatcher.tryLoadFrom(loader, className);
            if (cls.isPresent()) {
                return cls;
            }
            RegisteredType type = this.mgmt.getTypeRegistry().get(catalogItemId);
            if (type != null) {
                BrooklynClassLoadingContextSequential loader2 = new BrooklynClassLoadingContextSequential(this.mgmt, new BrooklynClassLoadingContext[0]);
                MutableList libs = MutableList.of();
                for (OsgiBundleWithUrl o : type.getLibraries()) {
                    libs.add(o.getVersionedName().toString());
                }
                loader2.add(CatalogUtils.newClassLoadingContextForCatalogItems(this.mgmt, type.getContainingBundle(), (List<String>)libs));
                cls = dispatcher.tryLoadFrom(loader2, className);
                if (cls.isPresent()) {
                    return cls;
                }
            }
            if ((item = CatalogUtils.getCatalogItemOptionalVersion(this.mgmt, catalogItemId)) != null) {
                BrooklynClassLoadingContextSequential loader3 = new BrooklynClassLoadingContextSequential(this.mgmt, new BrooklynClassLoadingContext[0]);
                try {
                    loader3.add(CatalogUtils.newClassLoadingContextForCatalogItems(this.mgmt, item.getCatalogItemId(), item.getCatalogItemIdSearchPath()));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (Exception e) {
                    log.warn("Error accessing looking up " + className + " relative to " + catalogItemId + " (ignoring, will try loading other ways but may fail): " + e, (Throwable)e);
                }
                cls = dispatcher.tryLoadFrom(loader3, className);
                if (cls.isPresent()) {
                    return cls;
                }
            } else {
                log.warn("Entity " + this.entity + " refers to non-existent catalog item " + catalogItemId + ". Trying to load class " + name);
            }
        }
        if ((cls = this.tryLoadFromBundleWhiteList(dispatcher, className)).isPresent()) {
            return cls;
        }
        cls = dispatcher.tryLoadFrom(this.classLoader, className);
        if (cls.isPresent()) {
            return cls;
        }
        if (this.mgmt != null && (cls = dispatcher.tryLoadFrom(this.mgmt.getCatalogClassLoader(), className)).isPresent()) {
            return cls;
        }
        return Maybe.absentNull();
    }

    protected <T> Maybe<T> tryLoadFromBundle(LoaderDispatcher<T> dispatcher, String originalSymbolicName, String version, String name) {
        Framework framework = this.getFramework();
        String symbolicName = originalSymbolicName = Strings.removeAllFromStart((String)originalSymbolicName, (String[])new String[]{"/", "\\"});
        if (this.isSymbolicNameChanged(symbolicName)) {
            log.debug("Using {} as symbolicName instead of {} as it is in UPDATED_SYMBOLICS_NAMES list", (Object)symbolicName, (Object)originalSymbolicName);
            symbolicName = this.findUpdatedSymbolicName(symbolicName);
        }
        if (framework != null) {
            Maybe bundle;
            if (Strings.isBlank((CharSequence)version)) {
                try {
                    Bundle b;
                    ClassLoader cl = this.classLoader.loadClass(name).getClassLoader();
                    if (cl instanceof BundleReference && Objects.equal((Object)symbolicName, (Object)(b = ((BundleReference)cl).getBundle()).getSymbolicName())) {
                        version = b.getVersion().toString();
                    }
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    log.trace("Error deducing class - not unusual", (Throwable)e);
                }
            }
            if ((bundle = Maybe.of(Osgis.bundleFinder(framework).symbolicName(symbolicName).version(version).findAll().stream().reduce((v1, v2) -> v2))).isAbsent()) {
                String requestedV = symbolicName + CLASS_NAME_DELIMITER + (Strings.isBlank((CharSequence)version) ? "0.0.0_DEFAULT_VERSION" : version);
                String upgradedV = BundleUpgradeParser.CatalogUpgrades.getBundleUpgradedIfNecessary(this.mgmt, requestedV);
                if (!Objects.equal((Object)upgradedV, (Object)requestedV)) {
                    log.debug("Upgraded access to bundle " + requestedV + " for loading " + name + " to use bundle " + upgradedV);
                    bundle = Maybe.of(Osgis.bundleFinder(framework).id(upgradedV).findAll().stream().reduce((v1, v2) -> v2));
                }
                if (bundle.isAbsent()) {
                    throw new IllegalStateException("Bundle " + this.toBundleString(symbolicName, version) + " not found to load.");
                }
            }
            return dispatcher.tryLoadFrom((Bundle)bundle.get(), name);
        }
        Maybe<T> result = dispatcher.tryLoadFrom(this.classLoader, name);
        if (result.isAbsent()) {
            if (name == null || name.startsWith("//") || symbolicName == null || "classpath".equals(symbolicName) || "http".equals(symbolicName) || "https".equals(symbolicName) || "file".equals(symbolicName)) {
                if (log.isTraceEnabled()) {
                    log.trace("Request for bundle '" + symbolicName + "' " + (Strings.isNonBlank((CharSequence)version) ? "(" + version + ") " : "") + (originalSymbolicName.equals(symbolicName) ? "" : ". Original symbolic name: " + originalSymbolicName) + "was ignored as no framework available; and failed to find '" + name + "' in plain old classpath");
                }
            } else {
                log.warn("Request for bundle '" + symbolicName + "' " + (Strings.isNonBlank((CharSequence)version) ? "(" + version + ") " : "") + (originalSymbolicName.equals(symbolicName) ? "" : ". Original symbolic name: " + originalSymbolicName) + "was ignored as no framework available; and failed to find '" + name + "' in plain old classpath");
            }
        }
        return result;
    }

    @Beta
    public boolean isBundleWhiteListed(Bundle bundle) {
        WhiteListBundlePredicate p = this.createBundleMatchingPredicate();
        return p.apply(bundle);
    }

    private Framework getFramework() {
        Maybe<OsgiManager> osgiManager;
        if (this.mgmt != null && (osgiManager = ((ManagementContextInternal)this.mgmt).getOsgiManager()).isPresent()) {
            OsgiManager osgi = (OsgiManager)osgiManager.get();
            return osgi.getFramework();
        }
        Bundle bundle = FrameworkUtil.getBundle(ClassLoaderUtils.class);
        if (bundle != null) {
            BundleContext bundleContext = bundle.getBundleContext();
            return (Framework)bundleContext.getBundle(0L);
        }
        return null;
    }

    private boolean looksLikeBundledClassName(String name) {
        return name.indexOf(CLASS_NAME_DELIMITER) != -1;
    }

    protected <T> Maybe<T> tryLoadFromBundleWhiteList(LoaderDispatcher<T> dispatcher, String className) {
        Framework framework = this.getFramework();
        if (framework == null) {
            return Maybe.absentNull();
        }
        List<Bundle> bundles = Osgis.bundleFinder(framework).satisfying(this.createBundleMatchingPredicate()).satisfying((Predicate<? super Bundle>)((Predicate)b -> b.getState() == 32)).findAll();
        MutableMap errors = MutableMap.of();
        for (Bundle b2 : bundles) {
            try {
                Maybe<T> item = dispatcher.tryLoadFrom(b2, className);
                if (!item.isPresent()) continue;
                return item;
            }
            catch (Exception e) {
                log.debug("Skipping bundle " + b2 + " for search of " + className + " due to: " + e);
                if (log.isTraceEnabled()) {
                    log.trace("Stack trace details", (Throwable)e);
                }
                errors.put(b2, e);
            }
        }
        return Maybe.absent(() -> ClassLoaderUtils.lambda$tryLoadFromBundleWhiteList$3((Map)errors, className));
    }

    protected WhiteListBundlePredicate createBundleMatchingPredicate() {
        String whiteList = System.getProperty(WHITE_LIST_KEY, WHITE_LIST_DEFAULT);
        String[] arr = whiteList.split(CLASS_NAME_DELIMITER);
        String symbolicName = arr[0];
        String version = null;
        if (arr.length > 2) {
            throw new IllegalStateException("Class loading fallback bundle white list '" + whiteList + "' not in the expected format <symbolic name regex>[:<version regex>].");
        }
        if (arr.length == 2) {
            version = arr[1];
        }
        return new WhiteListBundlePredicate(symbolicName, version);
    }

    private String toBundleString(String symbolicName, String version) {
        return symbolicName + CLASS_NAME_DELIMITER + (version != null ? version : "any") + (this.isSymbolicNameChanged(symbolicName) ? " (originally " + this.SYMBOLIC_NAME_UPDATES.get(symbolicName) + ")" : "");
    }

    protected Exception getReturnException(Maybe<Class<?>> cls) {
        if (cls.isNull()) {
            return null;
        }
        try {
            cls.get();
            return null;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            return e;
        }
    }

    private String stripLeadingSlash(String name) {
        int last;
        Object[] arr = name.split(CLASS_NAME_DELIMITER);
        if (arr[last = arr.length - 1].startsWith("/")) {
            arr[last] = ((String)arr[last]).substring(1);
        }
        return Joiner.on((String)CLASS_NAME_DELIMITER).join(arr);
    }

    private boolean isSymbolicNameChanged(String symbolicName) {
        return this.SYMBOLIC_NAME_UPDATES.containsKey(symbolicName);
    }

    private String findUpdatedSymbolicName(String orignalSymbolicName) {
        String result = orignalSymbolicName;
        while (this.isSymbolicNameChanged(result)) {
            result = this.SYMBOLIC_NAME_UPDATES.get(result);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + MoreObjects.toStringHelper((Object)this).add("claddLoader", (Object)this.classLoader).add("entity", (Object)this.entity).add("mgmt", (Object)this.mgmt) + "]";
    }

    private static /* synthetic */ RuntimeException lambda$tryLoadFromBundleWhiteList$3(Map errors, String className) {
        if (errors.isEmpty()) {
            return new IllegalStateException("Unable to find class '" + className + "' in whitelisted bundles");
        }
        return Exceptions.propagate((String)("Unable to find class '" + className + "' in whitelisted bundles, with errors in bundles " + errors.keySet()), errors.values());
    }

    protected static class WhiteListBundlePredicate
    implements Predicate<Bundle> {
        private final Pattern symbolicName;
        private final Pattern version;

        private WhiteListBundlePredicate(String symbolicName, String version) {
            this.symbolicName = Pattern.compile((String)Preconditions.checkNotNull((Object)symbolicName, (Object)"symbolicName"));
            this.version = version != null ? Pattern.compile(version) : null;
        }

        public boolean apply(Bundle input) {
            return input.getSymbolicName() != null && input.getVersion() != null && this.symbolicName.matcher(input.getSymbolicName()).matches() && (this.version == null || this.version.matcher(input.getVersion().toString()).matches());
        }
    }
}

