/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.text;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class DataUriSchemeParser {
    public static final String PROTOCOL_PREFIX = "data:";
    public static final String DEFAULT_MIME_TYPE = "text/plain";
    public static final String DEFAULT_CHARSET = "US-ASCII";
    private final String url;
    private int parseIndex = 0;
    private boolean isParsed = false;
    private boolean allowMissingComma = false;
    private boolean allowSlashesAfterColon = false;
    private boolean allowOtherLaxities = false;
    private String mimeType;
    private byte[] data;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();

    public DataUriSchemeParser(String url) {
        this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"url");
    }

    public static String toString(String url) {
        return new DataUriSchemeParser(url).lax().parse().getDataAsString();
    }

    public static byte[] toBytes(String url) {
        return new DataUriSchemeParser(url).lax().parse().getData();
    }

    public String getCharset() {
        String charset = this.parameters.get("charset");
        if (charset != null) {
            return charset;
        }
        return DEFAULT_CHARSET;
    }

    public String getMimeType() {
        this.assertParsed();
        if (this.mimeType != null) {
            return this.mimeType;
        }
        return DEFAULT_MIME_TYPE;
    }

    public Map<String, String> getParameters() {
        return ImmutableMap.copyOf(this.parameters);
    }

    public byte[] getData() {
        this.assertParsed();
        return this.data;
    }

    public ByteArrayInputStream getDataAsInputStream() {
        return new ByteArrayInputStream(this.getData());
    }

    public String getDataAsString() {
        return new String(this.getData(), Charset.forName(this.getCharset()));
    }

    public synchronized DataUriSchemeParser lax() {
        return this.allowMissingComma(true).allowSlashesAfterColon(true).allowOtherLaxities(true);
    }

    public synchronized DataUriSchemeParser allowMissingComma(boolean allowMissingComma) {
        this.assertNotParsed();
        this.allowMissingComma = allowMissingComma;
        return this;
    }

    public synchronized DataUriSchemeParser allowSlashesAfterColon(boolean allowSlashesAfterColon) {
        this.assertNotParsed();
        this.allowSlashesAfterColon = allowSlashesAfterColon;
        return this;
    }

    private synchronized DataUriSchemeParser allowOtherLaxities(boolean allowOtherLaxities) {
        this.assertNotParsed();
        this.allowOtherLaxities = allowOtherLaxities;
        return this;
    }

    private void assertNotParsed() {
        if (this.isParsed) {
            throw new IllegalStateException("Operation not permitted after parsing");
        }
    }

    private void assertParsed() {
        if (!this.isParsed) {
            throw new IllegalStateException("Operation not permitted before parsing");
        }
    }

    public synchronized DataUriSchemeParser parse() {
        try {
            return this.parseChecked();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public synchronized DataUriSchemeParser parseChecked() throws UnsupportedEncodingException, MalformedURLException {
        if (this.isParsed) {
            return this;
        }
        this.skipOptional(PROTOCOL_PREFIX);
        if (this.allowSlashesAfterColon) {
            while (this.skipOptional("/")) {
            }
        }
        if (this.allowMissingComma && this.remainder().indexOf(44) == -1) {
            this.mimeType = DEFAULT_MIME_TYPE;
            this.parameters.put("charset", DEFAULT_CHARSET);
        } else {
            this.parseMediaType();
            this.parseParameterOrParameterValues();
            this.skipRequired(",");
        }
        this.parseData();
        this.isParsed = true;
        return this;
    }

    private void parseMediaType() throws MalformedURLException {
        if (this.remainder().startsWith(";") || this.remainder().startsWith(",")) {
            return;
        }
        int slash = this.remainder().indexOf("/");
        if (slash == -1) {
            throw new MalformedURLException("Missing required '/' in MIME type of data: URL");
        }
        String type = this.read(slash);
        this.skipRequired("/");
        int next = this.nextSemiOrComma();
        String subtype = this.read(next);
        this.mimeType = type + "/" + subtype;
    }

    private String read(int next) {
        String result = this.remainder().substring(0, next);
        this.parseIndex += next;
        return result;
    }

    private int nextSemiOrComma() throws MalformedURLException {
        int semi = this.remainder().indexOf(59);
        int comma = this.remainder().indexOf(44);
        if (semi < 0 && comma < 0) {
            throw new MalformedURLException("Missing required ',' in data: URL");
        }
        if (semi < 0) {
            return comma;
        }
        if (comma < 0) {
            return semi;
        }
        return Math.min(semi, comma);
    }

    private void parseParameterOrParameterValues() throws MalformedURLException {
        while (this.remainder().startsWith(";")) {
            String value;
            String word;
            ++this.parseIndex;
            int eq = this.remainder().indexOf(61);
            int nextSemiOrComma = this.nextSemiOrComma();
            if (eq == -1 || eq > nextSemiOrComma) {
                word = this.read(nextSemiOrComma);
                value = null;
            } else {
                word = this.read(eq);
                if (this.remainder().startsWith("\"")) {
                    ++this.parseIndex;
                    int nextUnescapedQuote = this.nextUnescapedQuote();
                    value = "\"" + this.read(nextUnescapedQuote);
                } else {
                    value = this.read(this.nextSemiOrComma());
                }
            }
            this.parameters.put(word, value);
        }
        return;
    }

    private int nextUnescapedQuote() throws MalformedURLException {
        String r = this.remainder();
        boolean escaped = false;
        for (int i = 0; i < r.length(); ++i) {
            if (escaped) {
                escaped = false;
                continue;
            }
            if (r.charAt(i) == '\"') {
                return i;
            }
            if (r.charAt(i) != '\\') continue;
            escaped = true;
        }
        throw new MalformedURLException("Unclosed double-quote in data: URL");
    }

    private void parseData() throws UnsupportedEncodingException, MalformedURLException {
        if (this.parameters.containsKey("base64")) {
            this.checkNoParamValue("base64");
            this.data = BaseEncoding.base64().decode((CharSequence)this.remainder());
        } else if (this.parameters.containsKey("base64url")) {
            this.checkNoParamValue("base64url");
            this.data = BaseEncoding.base64Url().decode((CharSequence)this.remainder());
        } else {
            this.data = URLDecoder.decode(this.remainder(), this.getCharset()).getBytes(Charset.forName(this.getCharset()));
        }
    }

    private void checkNoParamValue(String param) throws MalformedURLException {
        if (this.allowOtherLaxities) {
            return;
        }
        String value = this.parameters.get(param);
        if (value != null) {
            throw new MalformedURLException(param + " parameter must not take a value (" + value + ") in data: URL");
        }
    }

    private String remainder() {
        return this.url.substring(this.parseIndex);
    }

    private boolean skipOptional(String word) {
        if (this.remainder().startsWith(word)) {
            this.parseIndex += word.length();
            return true;
        }
        return false;
    }

    private void skipRequired(String word) throws MalformedURLException {
        if (!this.remainder().startsWith(word)) {
            throw new MalformedURLException("Missing required '" + word + "' at position " + this.parseIndex + " of data: URL");
        }
        this.parseIndex += word.length();
    }
}

