/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.xstream;

import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.Serializable;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaPreventionMapper
extends MapperWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(LambdaPreventionMapper.class);
    private static final Pattern lambdaPattern = Pattern.compile(".*\\$\\$Lambda\\$[0-9]+/.*");
    public static final ConfigKey<LambdaPersistenceMode> LAMBDA_PERSISTENCE = ConfigKeys.newConfigKey(LambdaPersistenceMode.class, "brooklyn.persistence.advanced.lambdas", "How to handle attempts to persist data (entities, esp effectors; feeds; etc) containing lambdas; default since Apache Brooklyn 1.1 is to 'FAIL' on lambdas that don't implement Serializable and 'WARN' on those which do, because the former is guaranteed not to work and the latter is JVM-specific, and in all cases a concrete class is preferable. This setting can be used to restore previous behavior where required, where Brooklyn will silently 'ACCEPT' them even though it often won't restore on de-serialization, or a halfway house of 'WARN' (once only per type). Note the lambdas which implement Serializable may work in some JVMs but then break if deserialized to a different VM,and lambdas that do not implement Serializable will always serialize then restore as null. The default FAIL will flag these errors on creation. The two cases 'if_serializale' and 'if_non_serializable' can be customized using sub-keys.", LambdaPersistenceMode.FAIL);
    public static final ConfigKey<LambdaPersistenceMode> LAMBDA_PERSISTENCE_SERIALIZABLE = ConfigKeys.newConfigKey(LambdaPersistenceMode.class, "brooklyn.persistence.advanced.lambdas.if_serializable", null, LambdaPersistenceMode.WARN);
    public static final ConfigKey<LambdaPersistenceMode> LAMBDA_PERSISTENCE_NON_SERIALIZABLE = ConfigKeys.newConfigKey(LambdaPersistenceMode.class, "brooklyn.persistence.advanced.lambdas.if_non_serializable", null, LambdaPersistenceMode.FAIL);
    static Set<String> warnedTypes = MutableSet.of();
    private final LambdaPersistenceMode persistenceMode;
    private final LambdaPersistenceMode persistenceModeIfSerializable;
    private final LambdaPersistenceMode persistenceModeIfNonSerializable;

    public static Function<MapperWrapper, MapperWrapper> factory(ConfigBag properties) {
        return LambdaPreventionMapper.factory(properties.getFirst(LAMBDA_PERSISTENCE, new ConfigKey[0]), properties.getFirst(LAMBDA_PERSISTENCE_SERIALIZABLE, LAMBDA_PERSISTENCE), properties.getFirst(LAMBDA_PERSISTENCE_NON_SERIALIZABLE, LAMBDA_PERSISTENCE));
    }

    public static Function<MapperWrapper, MapperWrapper> factory(@Nonnull LambdaPersistenceMode persistenceMode, @Nullable LambdaPersistenceMode persistenceModeIfSerializable, @Nullable LambdaPersistenceMode persistenceModeIfNonSerializable) {
        return wrapper -> new LambdaPreventionMapper((Mapper)wrapper, persistenceMode, persistenceModeIfSerializable, persistenceModeIfNonSerializable);
    }

    public LambdaPreventionMapper(Mapper wrapped, @Nonnull LambdaPersistenceMode persistenceMode, @Nullable LambdaPersistenceMode persistenceModeIfSerializable, @Nullable LambdaPersistenceMode persistenceModeIfNonSerializable) {
        super(wrapped);
        this.persistenceMode = persistenceMode;
        this.persistenceModeIfSerializable = persistenceModeIfSerializable;
        this.persistenceModeIfNonSerializable = persistenceModeIfNonSerializable;
    }

    public String serializedClass(Class type) {
        if (LambdaPreventionMapper.isLambdaType(type)) {
            LambdaPersistenceMode mode = null;
            mode = Serializable.class.isAssignableFrom(type) ? this.persistenceModeIfSerializable : this.persistenceModeIfNonSerializable;
            if (mode == null) {
                mode = this.persistenceMode;
            }
            if (mode == null) {
                mode = (LambdaPersistenceMode)((Object)LAMBDA_PERSISTENCE.getDefaultValue());
            }
            switch (mode) {
                case ACCEPT: {
                    break;
                }
                case FAIL: {
                    throw new IllegalStateException("Attempt to XML serialize lambda: " + type + "; forbidden by configuration");
                }
                case WARN: {
                    if (!warnedTypes.add(type.toString())) break;
                    LOG.warn("Attempt to XML serialize lambda: " + type + "; allowed, but may cause problems on de-serialization");
                }
            }
        }
        return super.serializedClass(type);
    }

    public static final boolean isLambdaType(Class<?> type) {
        return type != null && type.isSynthetic() && lambdaPattern.matcher(type.getSimpleName()).matches();
    }

    static enum LambdaPersistenceMode {
        ACCEPT,
        WARN,
        FAIL;

    }
}

