/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.ClusterFluent;

public class ClusterBuilder
extends ClusterFluent<ClusterBuilder>
implements VisitableBuilder<Cluster, ClusterBuilder> {
    ClusterFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterBuilder() {
        this(false);
    }

    public ClusterBuilder(Boolean validationEnabled) {
        this(new Cluster(), validationEnabled);
    }

    public ClusterBuilder(ClusterFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterBuilder(ClusterFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Cluster(), validationEnabled);
    }

    public ClusterBuilder(ClusterFluent<?> fluent, Cluster instance) {
        this(fluent, instance, false);
    }

    public ClusterBuilder(ClusterFluent<?> fluent, Cluster instance, Boolean validationEnabled) {
        this.fluent = fluent;
        Cluster cluster = instance = instance != null ? instance : new Cluster();
        if (instance != null) {
            fluent.withCertificateAuthority(instance.getCertificateAuthority());
            fluent.withCertificateAuthorityData(instance.getCertificateAuthorityData());
            fluent.withDisableCompression(instance.getDisableCompression());
            fluent.withExtensions(instance.getExtensions());
            fluent.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
            fluent.withProxyUrl(instance.getProxyUrl());
            fluent.withServer(instance.getServer());
            fluent.withTlsServerName(instance.getTlsServerName());
            fluent.withCertificateAuthority(instance.getCertificateAuthority());
            fluent.withCertificateAuthorityData(instance.getCertificateAuthorityData());
            fluent.withDisableCompression(instance.getDisableCompression());
            fluent.withExtensions(instance.getExtensions());
            fluent.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
            fluent.withProxyUrl(instance.getProxyUrl());
            fluent.withServer(instance.getServer());
            fluent.withTlsServerName(instance.getTlsServerName());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ClusterBuilder(Cluster instance) {
        this(instance, (Boolean)false);
    }

    public ClusterBuilder(Cluster instance, Boolean validationEnabled) {
        this.fluent = this;
        Cluster cluster = instance = instance != null ? instance : new Cluster();
        if (instance != null) {
            this.withCertificateAuthority(instance.getCertificateAuthority());
            this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
            this.withDisableCompression(instance.getDisableCompression());
            this.withExtensions(instance.getExtensions());
            this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
            this.withProxyUrl(instance.getProxyUrl());
            this.withServer(instance.getServer());
            this.withTlsServerName(instance.getTlsServerName());
            this.withCertificateAuthority(instance.getCertificateAuthority());
            this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
            this.withDisableCompression(instance.getDisableCompression());
            this.withExtensions(instance.getExtensions());
            this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
            this.withProxyUrl(instance.getProxyUrl());
            this.withServer(instance.getServer());
            this.withTlsServerName(instance.getTlsServerName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Cluster build() {
        Cluster buildable = new Cluster(this.fluent.getCertificateAuthority(), this.fluent.getCertificateAuthorityData(), this.fluent.getDisableCompression(), this.fluent.buildExtensions(), this.fluent.getInsecureSkipTlsVerify(), this.fluent.getProxyUrl(), this.fluent.getServer(), this.fluent.getTlsServerName());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

