/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.networking;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.brooklyn.location.jclouds.BasicJcloudsLocationCustomizer;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.jclouds.networking.JcloudsLocationSecurityGroupCustomizer;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.net.Networking;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.Template;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class SharedLocationSecurityGroupCustomizer
extends BasicJcloudsLocationCustomizer {
    private String locationName = null;
    private String cidr = null;
    private int[] inboundPorts;
    private RangeSet<Integer> tcpPortRanges;
    private RangeSet<Integer> udpPortRanges;
    private Boolean openIcmp;
    private boolean enabled = true;

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public void setTcpPortRanges(List<String> tcpPortRanges) {
        this.tcpPortRanges = Networking.portRulesToRanges(tcpPortRanges);
    }

    public void setUdpPortRanges(List<String> udpPortRanges) {
        this.udpPortRanges = Networking.portRulesToRanges(udpPortRanges);
    }

    public void setOpenIcmp(Boolean openIcmp) {
        this.openIcmp = openIcmp;
    }

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, Template template) {
        if (!this.enabled) {
            return;
        }
        super.customize(location, computeService, template);
        this.inboundPorts = template.getOptions().getInboundPorts();
        JcloudsLocationSecurityGroupCustomizer instance = this.getInstance(this.getSharedGroupId(location));
        if (this.cidr != null) {
            instance.setSshCidrSupplier((Supplier<Cidr>)Suppliers.ofInstance((Object)new Cidr(this.cidr)));
        }
        instance.customize(location, computeService, template);
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, JcloudsMachineLocation machine) {
        this.applySecurityGroupCustomizations(location, computeService, machine);
    }

    public Collection<SecurityGroup> applySecurityGroupCustomizations(JcloudsLocation location, ComputeService computeService, JcloudsMachineLocation machine) {
        super.customize(location, computeService, machine);
        if (!this.enabled) {
            return ImmutableList.of();
        }
        JcloudsLocationSecurityGroupCustomizer instance = this.getInstance(this.getSharedGroupId(location));
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.getIpPermissions(instance, this.tcpPortRanges, IpProtocol.TCP));
        builder.addAll(this.getIpPermissions(instance, this.udpPortRanges, IpProtocol.UDP));
        if (Boolean.TRUE.equals(this.openIcmp)) {
            builder.addAll((Iterable)ImmutableList.of((Object)IpPermission.builder().ipProtocol(IpProtocol.ICMP).fromPort(-1).toPort(-1).cidrBlock(instance.getBrooklynCidrBlock()).build()));
        }
        if (this.inboundPorts != null) {
            for (int inboundPort : this.inboundPorts) {
                IpPermission ipPermission = IpPermission.builder().fromPort(inboundPort).toPort(inboundPort).ipProtocol(IpProtocol.TCP).cidrBlock(instance.getBrooklynCidrBlock()).build();
                builder.add((Object)ipPermission);
            }
        }
        return instance.addPermissionsToLocationAndReturnSecurityGroup(machine, (Iterable<IpPermission>)builder.build());
    }

    private List<IpPermission> getIpPermissions(JcloudsLocationSecurityGroupCustomizer instance, RangeSet<Integer> portRanges, IpProtocol protocol) {
        ImmutableList ipPermissions = ImmutableList.of();
        if (portRanges != null) {
            ipPermissions = FluentIterable.from((Iterable)portRanges.asRanges()).transform(this.portRangeToPermission(instance, protocol)).toList();
        }
        return ipPermissions;
    }

    private Function<Range<Integer>, IpPermission> portRangeToPermission(final JcloudsLocationSecurityGroupCustomizer instance, final IpProtocol protocol) {
        return new Function<Range<Integer>, IpPermission>(){

            @Nullable
            public IpPermission apply(@Nullable Range<Integer> integerRange) {
                IpPermission extraPermission = IpPermission.builder().fromPort(((Integer)integerRange.lowerEndpoint()).intValue()).toPort(((Integer)integerRange.upperEndpoint()).intValue()).ipProtocol(protocol).cidrBlock(instance.getBrooklynCidrBlock()).build();
                return extraPermission;
            }
        };
    }

    private String getSharedGroupId(JcloudsLocation location) {
        return Strings.isNullOrEmpty((String)this.locationName) ? location.getId() : this.locationName + "-" + location.getId();
    }

    @VisibleForTesting
    JcloudsLocationSecurityGroupCustomizer getInstance(String sharedGroupId) {
        return JcloudsLocationSecurityGroupCustomizer.getInstance(sharedGroupId);
    }
}

