/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Set;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.javax.annotation.Nullable;

public class Reservation<T extends RunningInstance>
extends ForwardingSet<T>
implements Comparable<Reservation<T>> {
    private final String region;
    private final ImmutableSet<String> groupNames;
    private final ImmutableSet<T> instances;
    @Nullable
    private final String ownerId;
    @Nullable
    private final String requesterId;
    @Nullable
    private final String reservationId;

    public static <T extends RunningInstance> Builder<T> builder() {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return Reservation.builder().fromReservation(this);
    }

    public Reservation(String region, Iterable<String> groupNames, Iterable<T> instances, @Nullable String ownerId, @Nullable String requesterId, @Nullable String reservationId) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.groupNames = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(groupNames, (Object)"groupNames")));
        this.instances = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(instances, (Object)"instances")));
        this.ownerId = ownerId;
        this.requesterId = requesterId;
        this.reservationId = reservationId;
    }

    protected Set<T> delegate() {
        return this.instances;
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    public Set<String> getGroupNames() {
        return this.groupNames;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    public String getReservationId() {
        return this.reservationId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.region, this.reservationId, super.hashCode()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Reservation that = (Reservation)Reservation.class.cast(obj);
        return super.equals((Object)that) && Objects.equal((Object)this.region, (Object)that.region) && Objects.equal((Object)this.reservationId, (Object)that.reservationId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("region", (Object)this.region).add("reservationId", (Object)this.reservationId).add("requesterId", (Object)this.requesterId).add("instances", this.instances).add("groupNames", this.groupNames).toString();
    }

    @Override
    public int compareTo(Reservation<T> other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.region), (Comparable)((Object)other.region)).compare((Object)this.reservationId, (Object)other.reservationId, (Comparator)Ordering.natural().nullsLast()).result();
    }

    public static class Builder<T extends RunningInstance> {
        private String region;
        private String ownerId;
        private String requesterId;
        private String reservationId;
        private ImmutableSet.Builder<T> instances = ImmutableSet.builder();
        private ImmutableSet.Builder<String> groupNames = ImmutableSet.builder();

        public Builder<T> region(String region) {
            this.region = region;
            return this;
        }

        public Builder<T> ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder<T> requesterId(String requesterId) {
            this.requesterId = requesterId;
            return this;
        }

        public Builder<T> reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public Builder<T> instance(T instance) {
            this.instances.add((Object)((RunningInstance)Preconditions.checkNotNull(instance, (Object)"instance")));
            return this;
        }

        public Builder<T> instances(Set<T> instances) {
            this.instances.addAll((Iterable)Preconditions.checkNotNull(instances, (Object)"instances"));
            return this;
        }

        public Builder<T> groupName(String groupName) {
            this.groupNames.add((Object)((String)Preconditions.checkNotNull((Object)groupName, (Object)"groupName")));
            return this;
        }

        public Builder<T> groupNames(Iterable<String> groupNames) {
            this.groupNames = ImmutableSet.builder().addAll((Iterable)Preconditions.checkNotNull(groupNames, (Object)"groupNames"));
            return this;
        }

        public Reservation<T> build() {
            return new Reservation(this.region, (Iterable<String>)this.groupNames.build(), this.instances.build(), this.ownerId, this.requesterId, this.reservationId);
        }

        public Builder<T> fromReservation(Reservation<T> in) {
            return this.region(((Reservation)in).region).ownerId(((Reservation)in).ownerId).requesterId(((Reservation)in).requesterId).reservationId(((Reservation)in).reservationId).instances((Set<T>)((Object)in)).groupNames((Iterable<String>)((Reservation)in).groupNames);
        }
    }
}

