/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.java;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.access.BrooklynAccessUtils;
import org.apache.brooklyn.entity.java.JmxmpSslSupport;
import org.apache.brooklyn.entity.java.UsesJmx;
import org.apache.brooklyn.feed.jmx.JmxHelper;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.BrooklynMavenArtifacts;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.maven.MavenArtifact;
import org.apache.brooklyn.util.maven.MavenRetriever;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxSupport
implements UsesJmx {
    private static final Logger log = LoggerFactory.getLogger(JmxSupport.class);
    private final Entity entity;
    private final String runDir;
    private Boolean isJmx;
    private Boolean isSecure;
    private UsesJmx.JmxAgentModes jmxAgentMode;
    private static boolean warnedAboutNotOnClasspath = false;

    public JmxSupport(Entity entity, @Nullable String runDir) {
        this.entity = (Entity)Preconditions.checkNotNull((Object)entity, (Object)"entity must be supplied");
        this.runDir = runDir;
    }

    @Nonnull
    public String getRunDir() {
        return (String)Preconditions.checkNotNull((Object)this.runDir, (Object)"runDir must have been supplied to perform this operation");
    }

    public Entity getEntity() {
        return this.entity;
    }

    <T> T getConfig(ConfigKey<T> key) {
        return (T)this.getEntity().getConfig(key);
    }

    <T> T getConfig(ConfigKey.HasConfigKey<T> key) {
        return (T)this.getEntity().getConfig(key);
    }

    <T> void setConfig(ConfigKey<T> key, T value) {
        this.getEntity().config().set(key, value);
    }

    public Maybe<SshMachineLocation> getMachine() {
        return Locations.findUniqueSshMachineLocation((Iterable)this.entity.getLocations());
    }

    public boolean isJmx() {
        this.init();
        return this.isJmx;
    }

    public UsesJmx.JmxAgentModes getJmxAgentMode() {
        this.init();
        if (this.jmxAgentMode == null) {
            return UsesJmx.JmxAgentModes.NONE;
        }
        return this.jmxAgentMode;
    }

    public boolean isSecure() {
        this.init();
        if (this.isSecure == null) {
            return false;
        }
        return this.isSecure;
    }

    protected synchronized void init() {
        if (this.isJmx != null) {
            return;
        }
        if (Boolean.FALSE.equals(this.entity.getConfig(USE_JMX))) {
            this.isJmx = false;
            return;
        }
        this.isJmx = true;
        this.jmxAgentMode = (UsesJmx.JmxAgentModes)((Object)this.entity.getConfig(JMX_AGENT_MODE));
        if (this.jmxAgentMode == null) {
            this.jmxAgentMode = UsesJmx.JmxAgentModes.AUTODETECT;
        }
        this.isSecure = (Boolean)this.entity.getConfig(JMX_SSL_ENABLED);
        if (this.isSecure == null) {
            this.isSecure = false;
        }
        if (this.jmxAgentMode == UsesJmx.JmxAgentModes.AUTODETECT) {
            if (this.isSecure()) {
                this.jmxAgentMode = UsesJmx.JmxAgentModes.JMXMP;
            } else {
                this.jmxAgentMode = UsesJmx.JmxAgentModes.JMXMP_AND_RMI;
                if (!ResourceUtils.create((Object)this).doesUrlExist(this.getJmxAgentJarUrl())) {
                    log.warn("JMX agent JAR not found (" + this.getJmxAgentJarUrl() + ") when auto-detecting JMX settings for " + this.entity + "; likely cause is an incomplete build (e.g. from Eclipse; run a maven build then retry in the IDE); reverting to NONE (use built-in Java JMX support, which will not go through firewalls)");
                    this.jmxAgentMode = UsesJmx.JmxAgentModes.NONE;
                }
            }
            this.entity.config().set(JMX_AGENT_MODE, (Object)this.jmxAgentMode);
        }
        if (this.isSecure.booleanValue() && this.jmxAgentMode != UsesJmx.JmxAgentModes.JMXMP) {
            String msg = "JMX SSL is specified, but it requires JMXMP which is disabled, when configuring " + this.entity;
            log.warn(msg);
            throw new IllegalStateException(msg);
        }
    }

    public void setJmxUrl() {
        ((EntityInternal)this.entity).sensors().set(JMX_URL, (Object)this.getJmxUrl());
    }

    public String getJmxUrl() {
        this.init();
        HostAndPort jmx = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this.entity, (int)((Integer)this.entity.getAttribute((AttributeSensor)JMX_PORT)));
        if (EnumSet.of(UsesJmx.JmxAgentModes.JMXMP, UsesJmx.JmxAgentModes.JMXMP_AND_RMI).contains((Object)this.getJmxAgentMode())) {
            return JmxHelper.toJmxmpUrl(jmx.getHost(), jmx.getPort());
        }
        if (this.getJmxAgentMode() == UsesJmx.JmxAgentModes.NONE) {
            this.fixPortsForModeNone();
        }
        HostAndPort rmi = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this.entity, (int)((Integer)this.entity.getAttribute((AttributeSensor)RMI_REGISTRY_PORT)));
        return JmxHelper.toRmiJmxUrl(jmx.getHost(), jmx.getPort(), rmi.getPort(), (String)this.entity.getAttribute((AttributeSensor)JMX_CONTEXT));
    }

    protected int fixPortsForModeNone() {
        assert (this.getJmxAgentMode() == UsesJmx.JmxAgentModes.NONE);
        Integer jmxRemotePort = (Integer)this.getEntity().getAttribute((AttributeSensor)JMX_PORT);
        Integer rmiRegistryPort = (Integer)this.getEntity().getAttribute((AttributeSensor)RMI_REGISTRY_PORT);
        if (rmiRegistryPort != null && rmiRegistryPort > 0) {
            if (jmxRemotePort == null || jmxRemotePort != rmiRegistryPort) {
                if (jmxRemotePort != null && jmxRemotePort > 0) {
                    log.warn("Ignoring JMX_PORT " + jmxRemotePort + " when configuring agentless JMX on " + this.getEntity() + "; will use RMI_REGISTRY_PORT " + rmiRegistryPort);
                }
                jmxRemotePort = rmiRegistryPort;
                this.getEntity().sensors().set((AttributeSensor)JMX_PORT, (Object)jmxRemotePort);
            }
        } else {
            if (jmxRemotePort == null || jmxRemotePort <= 0) {
                throw new IllegalStateException("Invalid JMX_PORT " + jmxRemotePort + " and RMI_REGISTRY_PORT " + rmiRegistryPort + " when configuring JMX " + (Object)((Object)this.getJmxAgentMode()) + " on " + this.getEntity());
            }
            this.getEntity().sensors().set((AttributeSensor)RMI_REGISTRY_PORT, (Object)jmxRemotePort);
        }
        return jmxRemotePort;
    }

    public List<String> getJmxJavaConfigOptions() {
        if (EnumSet.of(UsesJmx.JmxAgentModes.NONE, UsesJmx.JmxAgentModes.JMX_RMI).contains((Object)this.getJmxAgentMode())) {
            return MutableList.of();
        }
        return MutableList.of((Object)String.format("-javaagent:%s", this.getJmxAgentJarDestinationFilePath()));
    }

    public String getJmxAgentJarDestinationFilePath() {
        String result = (String)this.getEntity().getAttribute((AttributeSensor)JMX_AGENT_LOCAL_PATH);
        if (Strings.isNonBlank((CharSequence)result)) {
            return result;
        }
        result = this.getJmxAgentJarDestinationFilePathDefault();
        ((EntityInternal)this.getEntity()).sensors().set((AttributeSensor)JMX_AGENT_LOCAL_PATH, (Object)result);
        return result;
    }

    public String getJmxAgentJarDestinationFilePathDefault() {
        return Urls.mergePaths((String[])new String[]{this.getRunDir(), this.getJmxAgentJarBasename()});
    }

    @Nullable
    public MavenArtifact getJmxAgentJarMavenArtifact() {
        switch (this.getJmxAgentMode()) {
            case JMXMP: 
            case JMXMP_AND_RMI: {
                MavenArtifact result = BrooklynMavenArtifacts.artifact(null, (String)"brooklyn-jmxmp-agent", (String)"jar", (String)"with-dependencies");
                result.setCustomFileNameAfterArtifactMarker("shaded");
                result.setClassifierFileNameMarker("");
                return result;
            }
            case JMX_RMI_CUSTOM_AGENT: {
                return BrooklynMavenArtifacts.jar((String)"brooklyn-jmxrmi-agent");
            }
        }
        return null;
    }

    @Deprecated
    public String getJmxAgentJarBasename() {
        MavenArtifact artifact = this.getJmxAgentJarMavenArtifact();
        if (artifact == null) {
            throw new IllegalStateException("Either JMX is not enabled or there is an error in the configuration (JMX mode " + (Object)((Object)this.getJmxAgentMode()) + " does not support agent JAR)");
        }
        return artifact.getFilename();
    }

    public String getJmxAgentJarUrl() {
        MavenArtifact artifact = this.getJmxAgentJarMavenArtifact();
        if (artifact == null) {
            throw new IllegalStateException("Either JMX is not enabled or there is an error in the configuration (JMX mode " + (Object)((Object)this.getJmxAgentMode()) + " does not support agent JAR)");
        }
        String jar = "classpath://" + artifact.getFilename();
        if (ResourceUtils.create((Object)this).doesUrlExist(jar)) {
            return jar;
        }
        String result = MavenRetriever.localUrl((MavenArtifact)artifact);
        if (warnedAboutNotOnClasspath) {
            log.debug("JMX JAR for " + artifact + " is not on the classpath; taking from " + result);
        } else {
            log.warn("JMX JAR for " + artifact + " is not on the classpath; taking from " + result + " (subsequent similar messages will be logged at debug)");
            warnedAboutNotOnClasspath = true;
        }
        return result;
    }

    public void applyJmxJavaSystemProperties(MutableMap.Builder<String, Object> result) {
        if (!this.isJmx()) {
            return;
        }
        Integer jmxPort = (Integer)Preconditions.checkNotNull((Object)this.entity.getAttribute((AttributeSensor)JMX_PORT), (String)"jmx port must not be null for %s", (Object)this.entity);
        HostAndPort jmx = BrooklynAccessUtils.getBrooklynAccessibleAddress((Entity)this.entity, (int)jmxPort);
        Integer jmxRemotePort = (Integer)this.getEntity().getAttribute((AttributeSensor)JMX_PORT);
        String hostName = jmx.getHost();
        result.put((Object)"com.sun.management.jmxremote", null);
        result.put((Object)"java.rmi.server.hostname", (Object)hostName);
        switch (this.getJmxAgentMode()) {
            case JMXMP_AND_RMI: {
                Integer rmiRegistryPort = (Integer)Preconditions.checkNotNull((Object)this.entity.getAttribute((AttributeSensor)UsesJmx.RMI_REGISTRY_PORT), (String)"registry port (config val %s)", (Object)this.entity.getConfig((ConfigKey.HasConfigKey)UsesJmx.RMI_REGISTRY_PORT));
                result.put((Object)"brooklyn.jmxmp.rmi-port", (Object)rmiRegistryPort);
            }
            case JMXMP: {
                if (jmxRemotePort == null || jmxRemotePort <= 0) {
                    throw new IllegalStateException("Unsupported JMX port " + jmxRemotePort + " - when applying system properties (" + (Object)((Object)this.getJmxAgentMode()) + " / " + this.getEntity() + ")");
                }
                result.put((Object)"brooklyn.jmxmp.port", (Object)jmxRemotePort);
                result.remove((Object)"java.rmi.server.hostname");
                break;
            }
            case JMX_RMI_CUSTOM_AGENT: {
                if (jmxRemotePort == null || jmxRemotePort <= 0) {
                    throw new IllegalStateException("Unsupported JMX port " + jmxRemotePort + " - when applying system properties (" + (Object)((Object)this.getJmxAgentMode()) + " / " + this.getEntity() + ")");
                }
                result.put((Object)"brooklyn.jmx-agent.rmi-port", Preconditions.checkNotNull((Object)this.entity.getAttribute((AttributeSensor)UsesJmx.RMI_REGISTRY_PORT), (Object)"registry port"));
                result.put((Object)"brooklyn.jmx-agent.jmx-port", (Object)jmxRemotePort);
                break;
            }
            case NONE: {
                jmxRemotePort = this.fixPortsForModeNone();
            }
            case JMX_RMI: {
                result.put((Object)"com.sun.management.jmxremote.port", (Object)jmxRemotePort);
                result.put((Object)"java.rmi.server.useLocalHostname", (Object)"true");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported JMX mode - when applying system properties (" + (Object)((Object)this.getJmxAgentMode()) + " / " + this.getEntity() + ")");
            }
        }
        if (this.isSecure()) {
            this.getJmxSslSupport().applyAgentJmxJavaSystemProperties(result);
        } else {
            result.put((Object)"com.sun.management.jmxremote.ssl", (Object)false).put((Object)"com.sun.management.jmxremote.authenticate", (Object)false);
        }
    }

    public void install() {
        if (EnumSet.of(UsesJmx.JmxAgentModes.JMXMP_AND_RMI, UsesJmx.JmxAgentModes.JMXMP, UsesJmx.JmxAgentModes.JMX_RMI_CUSTOM_AGENT).contains((Object)this.getJmxAgentMode())) {
            Tasks.setBlockingDetails((String)"Copying JMX agent jar to server.");
            try {
                ((SshMachineLocation)this.getMachine().get()).copyTo(ResourceUtils.create((Object)this).getResourceFromUrl(this.getJmxAgentJarUrl()), this.getJmxAgentJarDestinationFilePath());
            }
            finally {
                Tasks.resetBlockingDetails();
            }
        }
        if (this.isSecure()) {
            this.getJmxSslSupport().install();
        }
    }

    protected JmxmpSslSupport getJmxSslSupport() {
        return new JmxmpSslSupport(this);
    }

    public void recommendJmxRmiCustomAgent() {
        Maybe jmx = ((EntityInternal)this.entity).config().getRaw(UsesJmx.JMX_AGENT_MODE);
        if (!jmx.isPresentAndNonNull()) {
            this.setConfig(UsesJmx.JMX_AGENT_MODE, UsesJmx.JmxAgentModes.JMX_RMI_CUSTOM_AGENT);
        } else if (jmx.get() != UsesJmx.JmxAgentModes.JMX_RMI_CUSTOM_AGENT) {
            log.warn("Entity " + this.entity + " may not function unless running JMX_RMI_CUSTOM_AGENT mode (asked to use " + jmx.get() + ")");
        }
    }
}

