/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.xml.ws.WebServiceException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessDriver;
import org.apache.brooklyn.entity.software.base.VanillaWindowsProcess;
import org.apache.brooklyn.entity.software.base.lifecycle.NativeWindowsScriptRunner;
import org.apache.brooklyn.entity.software.base.lifecycle.WinRmExecuteHelper;
import org.apache.brooklyn.location.winrm.WinRmMachineLocation;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.internal.winrm.WinRmTool;
import org.apache.brooklyn.util.core.internal.winrm.WinRmToolResponse;
import org.apache.brooklyn.util.core.mutex.WithMutexes;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.cxf.interceptor.Fault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSoftwareProcessWinRmDriver
extends AbstractSoftwareProcessDriver
implements NativeWindowsScriptRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSoftwareProcessWinRmDriver.class);
    AttributeSensor<String> WINDOWS_USERNAME = Sensors.newStringSensor((String)"windows.username", (String)"Default Windows username to be used when connecting to the Entity's VM");
    AttributeSensor<String> WINDOWS_PASSWORD = Sensors.newStringSensor((String)"windows.password", (String)"Default Windows password to be used when connecting to the Entity's VM");

    public AbstractSoftwareProcessWinRmDriver(EntityLocal entity, WinRmMachineLocation location) {
        super(entity, (Location)location);
        entity.sensors().set(this.WINDOWS_USERNAME, location.config().get(WinRmMachineLocation.USER));
        entity.sensors().set(this.WINDOWS_PASSWORD, location.config().get(WinRmMachineLocation.PASSWORD));
    }

    @Override
    protected String mergePaths(String ... s) {
        return super.mergePaths(s).replaceAll("/", "\\\\");
    }

    protected WinRmExecuteHelper newScript(String command, String psCommand, String phase, String taskNamePrefix) {
        return this.newScript(command, psCommand, phase, taskNamePrefix, null);
    }

    protected WinRmExecuteHelper newScript(String command, String psCommand, String phase, String taskNamePrefix, String ntDomain) {
        WinRmExecuteHelper result = this.newEmptyScript(taskNamePrefix);
        result.setNtDomain(ntDomain).setCommand(command).setPsCommand(psCommand).failOnNonZeroResultCode().gatherOutput();
        MutableMap env = MutableMap.of();
        env.put("INSTALL_DIR", this.getInstallDir());
        if (!"installing".equals(phase)) {
            env.put("RUN_DIR", this.getRunDir());
            env.putAll(this.getShellEnvironment());
        }
        result.setEnv((Map<String, String>)env);
        return result;
    }

    protected WinRmExecuteHelper newEmptyScript(String taskNamePrefix) {
        if (!Entities.isManagedActive((Entity)this.getEntity())) {
            throw new IllegalStateException(this.getEntity() + " is not managed here; cannot create script to run here (" + taskNamePrefix + ")");
        }
        WinRmExecuteHelper s = new WinRmExecuteHelper(this, taskNamePrefix + " " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
        return s;
    }

    @Override
    public void runPreInstallCommand() {
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(BrooklynConfigKeys.PRE_INSTALL_COMMAND))) || Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(VanillaWindowsProcess.PRE_INSTALL_POWERSHELL_COMMAND)))) {
            this.newScript((String)this.getEntity().getConfig(BrooklynConfigKeys.PRE_INSTALL_COMMAND), (String)this.getEntity().getConfig(VanillaWindowsProcess.PRE_INSTALL_POWERSHELL_COMMAND), "installing", "pre-install-command").useMutex(this.getLocation().mutexes(), "installation lock at host", "installing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this)).execute();
        }
        if (((Boolean)this.entity.getConfig(VanillaWindowsProcess.PRE_INSTALL_REBOOT_REQUIRED)).booleanValue()) {
            this.rebootAndWait();
        }
    }

    @Override
    public void setup() {
    }

    @Override
    public void runPostInstallCommand() {
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.entity.getConfig(BrooklynConfigKeys.POST_INSTALL_COMMAND))) || Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(VanillaWindowsProcess.POST_INSTALL_POWERSHELL_COMMAND)))) {
            this.newScript((String)this.getEntity().getConfig(BrooklynConfigKeys.POST_INSTALL_COMMAND), (String)this.getEntity().getConfig(VanillaWindowsProcess.POST_INSTALL_POWERSHELL_COMMAND), "installing", "post-install-command").useMutex(this.getLocation().mutexes(), "installation lock at host", "installing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this)).execute();
        }
    }

    @Override
    public void runPreCustomizeCommand() {
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(BrooklynConfigKeys.PRE_CUSTOMIZE_COMMAND))) || Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(VanillaWindowsProcess.PRE_CUSTOMIZE_POWERSHELL_COMMAND)))) {
            this.executeCommandInTask((String)this.getEntity().getConfig(BrooklynConfigKeys.PRE_CUSTOMIZE_COMMAND), (String)this.getEntity().getConfig(VanillaWindowsProcess.PRE_CUSTOMIZE_POWERSHELL_COMMAND), "customizing", "pre-customize-command");
        }
    }

    @Override
    public void runPostCustomizeCommand() {
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.entity.getConfig(BrooklynConfigKeys.POST_CUSTOMIZE_COMMAND))) || Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(VanillaWindowsProcess.POST_CUSTOMIZE_POWERSHELL_COMMAND)))) {
            this.executeCommandInTask((String)this.getEntity().getConfig(BrooklynConfigKeys.POST_CUSTOMIZE_COMMAND), (String)this.getEntity().getConfig(VanillaWindowsProcess.POST_CUSTOMIZE_POWERSHELL_COMMAND), "customizing", "post-customize-command");
        }
    }

    @Override
    public void runPreLaunchCommand() {
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.entity.getConfig(BrooklynConfigKeys.PRE_LAUNCH_COMMAND))) || Strings.isNonBlank((CharSequence)((CharSequence)this.entity.getConfig(VanillaWindowsProcess.PRE_LAUNCH_POWERSHELL_COMMAND)))) {
            this.executeCommandInTask((String)this.getEntity().getConfig(BrooklynConfigKeys.PRE_LAUNCH_COMMAND), (String)this.getEntity().getConfig(VanillaWindowsProcess.PRE_LAUNCH_POWERSHELL_COMMAND), "launching", "pre-launch-command");
        }
    }

    @Override
    public void runPostLaunchCommand() {
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.entity.getConfig(BrooklynConfigKeys.POST_LAUNCH_COMMAND))) || Strings.isNonBlank((CharSequence)((CharSequence)this.entity.getConfig(VanillaWindowsProcess.POST_LAUNCH_POWERSHELL_COMMAND)))) {
            this.executeCommandInTask((String)this.getEntity().getConfig(BrooklynConfigKeys.POST_LAUNCH_COMMAND), (String)this.getEntity().getConfig(VanillaWindowsProcess.POST_LAUNCH_POWERSHELL_COMMAND), "launching", "post-launch-command");
        }
    }

    @Override
    public void copyPreInstallResources() {
        WithMutexes mutexSupport = this.getLocation().mutexes();
        String mutexId = "installation lock at host";
        mutexSupport.acquireMutex(mutexId, "pre-installing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
        try {
            super.copyPreInstallResources();
        }
        catch (Exception e) {
            LOG.warn("Error copying pre-install resources", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            mutexSupport.releaseMutex(mutexId);
        }
    }

    @Override
    public void copyInstallResources() {
        WithMutexes mutexSupport = this.getLocation().mutexes();
        String mutexId = "installation lock at host";
        mutexSupport.acquireMutex(mutexId, "installing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
        try {
            super.copyInstallResources();
        }
        catch (Exception e) {
            LOG.warn("Error copying install resources", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            mutexSupport.releaseMutex(mutexId);
        }
    }

    @Override
    public void copyCustomizeResources() {
        WithMutexes mutexSupport = this.getLocation().mutexes();
        String mutexId = "installation lock at host";
        mutexSupport.acquireMutex(mutexId, "customizing " + JavaGroovyEquivalents.elvis((Object)this.entity, (Object)this));
        try {
            super.copyCustomizeResources();
        }
        catch (Exception e) {
            LOG.warn("Error copying customize resources", (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            mutexSupport.releaseMutex(mutexId);
        }
    }

    public WinRmMachineLocation getLocation() {
        return (WinRmMachineLocation)super.getLocation();
    }

    public WinRmMachineLocation getMachine() {
        return this.getLocation();
    }

    protected int executeCommandInTask(String command, String psCommand, String phase, String taskNamePrefix) {
        return this.executeCommandInTask(command, psCommand, phase, taskNamePrefix, null);
    }

    protected int executeCommandInTask(String command, String psCommand, String phase, String taskNamePrefix, String ntDomain) {
        WinRmExecuteHelper helper = this.newScript(command, psCommand, phase, taskNamePrefix, ntDomain);
        return helper.execute();
    }

    @Override
    public int executeNativeCommand(Map flags, String command, String phase) {
        return this.executeNativeOrPsCommand(flags, command, null, phase, true);
    }

    @Override
    public int executePsCommand(Map flags, String command, String phase) {
        return this.executeNativeOrPsCommand(flags, null, command, phase, true);
    }

    @Deprecated
    protected String getEntityVersionLabel() {
        return this.getEntityVersionLabel("_");
    }

    @Deprecated
    protected String getEntityVersionLabel(String separator) {
        return JavaGroovyEquivalents.elvis((String)this.entity.getEntityType().getSimpleName(), (String)this.entity.getClass().getName()) + (this.getVersion() != null ? separator + this.getVersion() : "");
    }

    @Override
    public int copyResource(Map<Object, Object> sshFlags, String sourceUrl, String target, boolean createParentDir) {
        int n;
        if (createParentDir) {
            this.createDirectory(this.getDirectory(target), "Creating resource directory");
        }
        InputStream stream = null;
        try {
            Tasks.setBlockingDetails((String)("retrieving resource " + sourceUrl + " for copying across"));
            stream = this.resource.getResourceFromUrl(sourceUrl);
            Tasks.setBlockingDetails((String)("copying resource " + sourceUrl + " to server"));
            LOG.debug("Copying " + sourceUrl + " to " + target + " on " + this.getLocation() + " for " + this.getEntity());
            n = this.copyTo(stream, target);
        }
        catch (Exception e) {
            try {
                throw Exceptions.propagate((Throwable)e);
            }
            catch (Throwable throwable) {
                Tasks.setBlockingDetails(null);
                if (stream != null) {
                    Streams.closeQuietly(stream);
                }
                throw throwable;
            }
        }
        Tasks.setBlockingDetails(null);
        if (stream != null) {
            Streams.closeQuietly((Closeable)stream);
        }
        return n;
    }

    @Override
    public int copyResource(Map<Object, Object> sshFlags, InputStream source, String target, boolean createParentDir) {
        if (createParentDir) {
            this.createDirectory(this.getDirectory(target), "Creating resource directory");
        }
        return this.copyTo(source, target);
    }

    @Override
    protected void createDirectory(String directoryName, String summaryForLogging) {
        this.getLocation().executePsScript("New-Item -path \"" + directoryName + "\" -type directory -ErrorAction SilentlyContinue");
    }

    @Override
    public Integer executeNativeOrPsCommand(Map flags, String regularCommand, String powerShellCommand, String summary, Boolean allowNoOp) {
        if (Strings.isBlank((CharSequence)regularCommand) && Strings.isBlank((CharSequence)powerShellCommand)) {
            if (allowNoOp.booleanValue()) {
                return new WinRmToolResponse("", "", 0).getStatusCode();
            }
            throw new IllegalStateException(String.format("Exactly one of cmd or psCmd must be set for %s of %s", summary, this.entity));
        }
        if (!Strings.isBlank((CharSequence)regularCommand) && !Strings.isBlank((CharSequence)powerShellCommand)) {
            throw new IllegalStateException(String.format("%s and %s cannot both be set for %s of %s", regularCommand, powerShellCommand, summary, this.entity));
        }
        ByteArrayOutputStream stdIn = new ByteArrayOutputStream();
        OutputStream stdOut = flags.get("out") != null ? (OutputStream)flags.get("out") : new ByteArrayOutputStream();
        OutputStream stdErr = flags.get("err") != null ? (OutputStream)flags.get("err") : new ByteArrayOutputStream();
        Task currentTask = Tasks.current();
        if (currentTask != null) {
            if (BrooklynTaskTags.stream((Task)Tasks.current(), (String)"stdin") == null) {
                this.writeToStreamIfEmpty(stdIn, Strings.isBlank((CharSequence)regularCommand) ? powerShellCommand : regularCommand);
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdin", (ByteArrayOutputStream)stdIn));
            }
            if (BrooklynTaskTags.stream((Task)currentTask, (String)"stdout") == null) {
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stdout", (ByteArrayOutputStream)stdOut));
                flags.put("out", stdOut);
                Tasks.addTagDynamically((Object)BrooklynTaskTags.tagForStreamSoft((String)"stderr", (ByteArrayOutputStream)stdErr));
                flags.put("err", stdErr);
            }
        }
        ImmutableMap.Builder winrmProps = ImmutableMap.builder();
        if (flags.get(WinRmTool.COMPUTER_NAME) != null) {
            winrmProps.put((Object)WinRmTool.COMPUTER_NAME, flags.get(WinRmTool.COMPUTER_NAME));
        }
        if (flags.get(WinRmTool.ENVIRONMENT) != null) {
            winrmProps.put((Object)WinRmTool.ENVIRONMENT, flags.get(WinRmTool.ENVIRONMENT));
        }
        if (stdOut != null) {
            winrmProps.put((Object)ShellTool.PROP_OUT_STREAM, (Object)stdOut);
        }
        if (stdErr != null) {
            winrmProps.put((Object)ShellTool.PROP_ERR_STREAM, (Object)stdErr);
        }
        WinRmToolResponse response = Strings.isBlank((CharSequence)regularCommand) ? this.getLocation().executePsScript((Map)winrmProps.build(), (List)ImmutableList.of((Object)powerShellCommand)) : this.getLocation().executeCommand((Map)winrmProps.build(), (List)ImmutableList.of((Object)regularCommand));
        if (currentTask != null) {
            if (stdOut instanceof ByteArrayOutputStream) {
                this.writeToStreamIfEmpty((ByteArrayOutputStream)stdOut, response.getStdOut());
            }
            if (stdErr instanceof ByteArrayOutputStream) {
                this.writeToStreamIfEmpty((ByteArrayOutputStream)stdErr, response.getStdErr());
            }
        }
        return response.getStatusCode();
    }

    private void writeToStreamIfEmpty(ByteArrayOutputStream stream, String string) {
        try {
            if (stream.size() == 0) {
                stream.write(string.getBytes());
            }
        }
        catch (IOException e) {
            LOG.warn("Problem populating one of the std streams for task of entity " + this.getEntity(), (Throwable)e);
        }
    }

    public int execute(List<String> script) {
        return this.getLocation().executeCommand(script).getStatusCode();
    }

    public int executePsScriptNoRetry(List<String> psScript) {
        return this.getLocation().executePsScript((Map)ImmutableMap.of((Object)WinRmTool.PROP_EXEC_TRIES, (Object)1), psScript).getStatusCode();
    }

    public int executePsScript(List<String> psScript) {
        return this.getLocation().executePsScript(psScript).getStatusCode();
    }

    public int copyTo(File source, String destination) {
        return this.getLocation().copyTo(source, destination);
    }

    public int copyTo(InputStream source, String destination) {
        return this.getLocation().copyTo(source, destination);
    }

    public void rebootAndWait() {
        this.rebootAndWait(null);
    }

    public void rebootAndWait(String hostname) {
        try {
            if (hostname != null) {
                this.getLocation().executePsScript((Map)ImmutableMap.of((Object)WinRmTool.COMPUTER_NAME, (Object)hostname), (List)ImmutableList.of((Object)"Restart-Computer -Force"));
            } else {
                this.getLocation().executePsScript((List)ImmutableList.of((Object)"Restart-Computer -Force"));
            }
        }
        catch (Exception e) {
            Throwable interestingCause = this.findExceptionCausedByWindowsRestart(e);
            if (interestingCause != null) {
                LOG.debug("Restarting... exception while closing winrm session from the restart command {}", (Object)this.getEntity(), (Object)e);
            }
            throw e;
        }
        this.waitForWinRmStatus(false, (Duration)this.entity.getConfig(VanillaWindowsProcess.REBOOT_BEGUN_TIMEOUT));
        this.waitForWinRmStatus(true, (Duration)this.entity.getConfig(VanillaWindowsProcess.REBOOT_COMPLETED_TIMEOUT)).getWithError();
    }

    protected Throwable findExceptionCausedByWindowsRestart(Exception e) {
        return Exceptions.getFirstThrowableOfType((Throwable)e, WebServiceException.class) != null ? Exceptions.getFirstThrowableOfType((Throwable)e, WebServiceException.class) : Exceptions.getFirstThrowableOfType((Throwable)e, Fault.class);
    }

    private String getDirectory(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("\\"));
    }

    private ReferenceWithError<Boolean> waitForWinRmStatus(final boolean requiredStatus, Duration timeout) {
        Callable<Boolean> checker = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    return AbstractSoftwareProcessWinRmDriver.this.execute((List<String>)ImmutableList.of((Object)"hostname")) == 0 == requiredStatus;
                }
                catch (Exception e) {
                    return !requiredStatus;
                }
            }
        };
        return new Repeater().every(1L, TimeUnit.SECONDS).until((Callable)checker).limitTimeTo(timeout).runKeepingError();
    }
}

