/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.jclouds.googlecomputeengine.compute.domain.internal.AutoValue_RegionAndName;

public abstract class RegionAndName {
    public abstract String regionId();

    public abstract String name();

    RegionAndName() {
    }

    public static RegionAndName fromSlashEncoded(String name) {
        Iterable parts = Splitter.on((char)'/').split((CharSequence)Preconditions.checkNotNull((Object)name, (Object)"name"));
        Preconditions.checkArgument((Iterables.size((Iterable)parts) == 2 ? 1 : 0) != 0, (Object)"name must be in format regionId/name");
        return RegionAndName.fromRegionAndName((String)Iterables.get((Iterable)parts, (int)0), (String)Iterables.get((Iterable)parts, (int)1));
    }

    public static RegionAndName fromRegionAndName(String regionId, String name) {
        return new AutoValue_RegionAndName(regionId, name);
    }

    public String slashEncode() {
        return this.regionId() + "/" + this.name();
    }
}

