/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import com.google.common.base.Preconditions;
import org.jclouds.googlecomputeengine.options.AutoValue_AddressCreationOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class AddressCreationOptions {
    public abstract String name();

    @Nullable
    public abstract String address();

    @Nullable
    public abstract String description();

    @SerializedNames(value={"name", "address", "description"})
    static AddressCreationOptions create(String name, String address, String description) {
        return new AutoValue_AddressCreationOptions(name, address, description);
    }

    public static class Builder {
        private String name;
        private String address;
        private String description;

        public Builder(String name) {
            this.name = name;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public AddressCreationOptions build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"AddressCreationOptions name cannot be null");
            return AddressCreationOptions.create(this.name, this.address, this.description);
        }
    }
}

