/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import java.net.URI;
import org.jclouds.googlecomputeengine.options.AutoValue_DiskCreationOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class DiskCreationOptions {
    @Nullable
    public abstract URI type();

    @Nullable
    public abstract Integer sizeGb();

    @Nullable
    public abstract URI sourceSnapshot();

    @Nullable
    public abstract String description();

    @SerializedNames(value={"type", "sizeGb", "sourceSnapshot", "description"})
    static DiskCreationOptions create(URI type, Integer sizeGb, URI sourceSnapshot, String description) {
        return new AutoValue_DiskCreationOptions(type, sizeGb, sourceSnapshot, description);
    }

    DiskCreationOptions() {
    }

    public static class Builder {
        private URI type;
        private Integer sizeGb;
        private URI sourceSnapshot;
        private String description;

        public Builder type(URI type) {
            this.type = type;
            return this;
        }

        public Builder sizeGb(Integer sizeGb) {
            this.sizeGb = sizeGb;
            return this;
        }

        public Builder sourceSnapshot(URI sourceSnapshot) {
            this.sourceSnapshot = sourceSnapshot;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public DiskCreationOptions build() {
            return DiskCreationOptions.create(this.type, this.sizeGb, this.sourceSnapshot, this.description);
        }
    }
}

