/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.entitlement.WebEntitlementContext;
import org.apache.brooklyn.rest.api.LogoutApi;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.security.provider.DelegatingSecurityProvider;
import org.apache.brooklyn.rest.util.MultiSessionAttributeAdapter;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.eclipse.jetty.server.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutResource
extends AbstractBrooklynRestResource
implements LogoutApi {
    private static final Logger log = LoggerFactory.getLogger(LogoutResource.class);
    public static final String DID_LOGOUT = "org.apache.brooklyn.server.DidLogout";
    @Context
    HttpServletRequest req;
    @Context
    UriInfo uri;

    @Deprecated
    public Response unAuthorize() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @Deprecated
    public Response logoutUser(String user) {
        WebEntitlementContext ctx = (WebEntitlementContext)Entitlements.getEntitlementContext();
        if (user.equals(ctx.user())) {
            this.doLogout();
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.temporaryRedirect((URI)this.uri.getBaseUriBuilder().path(LogoutApi.class).path(LogoutApi.class, "redirect").build(new Object[0])).entity((Object)"User requested to log out does not match actual user logged in").build();
    }

    public Response logout(String unauthorize, String requestedUser) {
        MultiSessionAttributeAdapter session = MultiSessionAttributeAdapter.of(this.req, false);
        WebEntitlementContext ctx = (WebEntitlementContext)Entitlements.getEntitlementContext();
        String currentUser = ctx == null ? null : ctx.user();
        log.debug("Logging out: {}, session id {} ({}), unauthorized={}", new Object[]{currentUser, session != null ? session.getId() + " " : "", session, unauthorize});
        MutableMap body = MutableMap.of();
        body.addIfNotNull((Object)"currentUser", (Object)currentUser);
        body.addIfNotNull((Object)"requestedUser", (Object)requestedUser);
        body.addIfNotNull((Object)"sessionId", (Object)(session == null ? null : session.getId()));
        body.addIfNotNull((Object)"requestedSessionId", (Object)this.req.getRequestedSessionId());
        if (requestedUser != null && !requestedUser.equals(currentUser)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)body.add((Object)"message", (Object)"The user requested to be logged out is not the user currently logged in")).build();
        }
        this.doLogout();
        if (unauthorize != null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)body.add((Object)"message", (Object)unauthorize)).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)body.add((Object)"message", (Object)("Logged out user " + currentUser))).build();
    }

    private void doLogout() {
        MultiSessionAttributeAdapter multi = MultiSessionAttributeAdapter.of(this.req);
        multi.configureWhetherToSetInAll(true).removeAttribute("brooklyn.user");
        new DelegatingSecurityProvider(this.mgmt()).logout(multi.getPreferredSession());
        try {
            this.req.logout();
        }
        catch (ServletException e) {
            Exceptions.propagate((Throwable)e);
        }
        this.req.setAttribute(DID_LOGOUT, (Object)true);
        multi.getPreferredSession().invalidate();
        if (multi.getOriginalSession() instanceof Session && ((Session)multi.getOriginalSession()).isValid()) {
            throw new IllegalStateException(MultiSessionAttributeAdapter.info(multi.getOriginalSession()) + " is valid after invaildating " + MultiSessionAttributeAdapter.info(multi.getPreferredSession()));
        }
    }
}

