/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.rest.domain.EffectorSummary;

@Path(value="/applications/{application}/entities/{entity}/effectors")
@Api(value="Entity Effectors")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface EffectorApi {
    @GET
    @ApiOperation(value="Fetch the list of effectors", response=EffectorSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find application or entity"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<EffectorSummary> list(@ApiParam(name="application", value="Application name", required=true) @PathParam(value="application") String var1, @ApiParam(name="entity", value="Entity name", required=true) @PathParam(value="entity") String var2);

    @POST
    @Path(value="/{effector}")
    @ApiOperation(value="Trigger an effector", notes="Returns the return value (status 200) if it completes, or an activity task ID (status 202) if it times out", response=String.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Accepted"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find application, entity or effector"), @ApiResponse(code=500, message="Internal Server Error")})
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response invoke(@ApiParam(name="application", value="Application ID or name", required=true) @PathParam(value="application") String var1, @ApiParam(name="entity", value="Entity ID or name", required=true) @PathParam(value="entity") String var2, @ApiParam(name="effector", value="Name of the effector to trigger", required=true) @PathParam(value="effector") String var3, @ApiParam(name="timeout", value="Delay before server should respond with activity task ID rather than result (in millis if no unit specified): 'never' (blocking) is default; '0' means 'always' return task activity ID; and e.g. '1000' or '1s' will return a result if available within one second otherwise status 202 and the activity task ID", required=false, defaultValue="never") @QueryParam(value="timeout") String var4, @ApiParam(name="parameters", value="Effector parameters (as key value pairs)", required=false) @Valid Map<String, Object> var5);
}

