/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.brooklyn.rest.domain.UsageStatistics;

@Path(value="/usage")
@Api(value="Usage")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface UsageApi {
    @GET
    @Path(value="/applications")
    @ApiOperation(value="Retrieve usage information about all applications", response=UsageStatistics.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<UsageStatistics> listApplicationsUsage(@ApiParam(name="start", value="timestamp of start marker for usage reporting, in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="start") String var1, @ApiParam(name="end", value="timestamp of end marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="end") String var2);

    @GET
    @Path(value="/applications/{application}")
    @ApiOperation(value="Retrieve usage information about a specified application", response=UsageStatistics.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public UsageStatistics getApplicationUsage(@ApiParam(name="application", value="Application id", required=true) @PathParam(value="application") String var1, @ApiParam(name="start", value="timestamp of start marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="start") String var2, @ApiParam(name="end", value="timestamp of end marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="end") String var3);

    @GET
    @Path(value="/machines")
    @ApiOperation(value="Retrieve usage information about all machine locations, optionally filtering for a specific application and/or time range", response=UsageStatistics.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<UsageStatistics> listMachinesUsage(@ApiParam(name="application", value="Application id", required=false) @QueryParam(value="application") String var1, @ApiParam(name="start", value="timestamp of start marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="start") String var2, @ApiParam(name="end", value="timestamp of end marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="end") String var3);

    @GET
    @Path(value="/machines/{machine}")
    @ApiOperation(value="Retrieve usage information about a specific machine location", response=UsageStatistics.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Machine not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public UsageStatistics getMachineUsage(@ApiParam(name="machine", value="Machine id", required=true) @PathParam(value="machine") String var1, @ApiParam(name="start", value="timestamp of start marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="start") String var2, @ApiParam(name="end", value="timestamp of end marker for usage reporting in format UTC millis or yyyy-MM-dd'T'HH:mm:ssZ", required=false) @QueryParam(value="end") String var3);
}

