/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.couchdb;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.entity.EntityFunctions;
import org.apache.brooklyn.entity.nosql.couchdb.CouchDBNode;
import org.apache.brooklyn.entity.nosql.couchdb.CouchDBNodeDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.entity.webapp.WebAppServiceMethods;
import org.apache.brooklyn.feed.http.HttpFeed;
import org.apache.brooklyn.feed.http.HttpPollConfig;
import org.apache.brooklyn.feed.http.HttpValueFunctions;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Functionals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDBNodeImpl
extends SoftwareProcessImpl
implements CouchDBNode {
    private static final Logger log = LoggerFactory.getLogger(CouchDBNodeImpl.class);
    private volatile HttpFeed httpFeed;

    @Override
    public Integer getHttpPort() {
        return (Integer)this.getAttribute((AttributeSensor)CouchDBNode.HTTP_PORT);
    }

    @Override
    public Integer getHttpsPort() {
        return (Integer)this.getAttribute((AttributeSensor)CouchDBNode.HTTPS_PORT);
    }

    public String getClusterName() {
        return (String)this.getAttribute((AttributeSensor)CouchDBNode.CLUSTER_NAME);
    }

    public Class<CouchDBNodeDriver> getDriverInterface() {
        return CouchDBNodeDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        boolean retrieveUsageMetrics = (Boolean)this.getConfig(RETRIEVE_USAGE_METRICS);
        this.httpFeed = HttpFeed.builder().entity((Entity)this).period(500L, TimeUnit.MILLISECONDS).baseUri(String.format("http://%s:%d/_stats", this.getAttribute(HOSTNAME), this.getHttpPort())).poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(REQUEST_COUNT).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"httpd", "requests", "sum"}, Integer.class))).onFailureOrException(EntityFunctions.attribute((Entity)this, (AttributeSensor)REQUEST_COUNT))).enabled(retrieveUsageMetrics)).poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig((AttributeSensor)ERROR_COUNT).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"httpd_status_codes", "404", "sum"}, Integer.class))).onFailureOrException(Functions.constant((Object)-1))).enabled(retrieveUsageMetrics)).poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(TOTAL_PROCESSING_TIME).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"couchdb", "request_time", "sum"}, Integer.class))).onFailureOrException(Functions.constant((Object)-1))).enabled(retrieveUsageMetrics)).poll((HttpPollConfig)((HttpPollConfig)((HttpPollConfig)new HttpPollConfig(MAX_PROCESSING_TIME).onSuccess(Functionals.chain((Function)HttpValueFunctions.jsonContents((String[])new String[]{"couchdb", "request_time", "max"}, Double.class), (Function)TypeCoercions.function(Integer.class)))).onFailureOrException(Functions.constant((Object)-1))).enabled(retrieveUsageMetrics)).build();
        WebAppServiceMethods.connectWebAppServerPolicies((Entity)this);
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        this.disconnectServiceUpIsRunning();
    }

    protected void postStop() {
        super.postStop();
        this.sensors().set(REQUESTS_PER_SECOND_LAST, (Object)0.0);
        this.sensors().set(REQUESTS_PER_SECOND_IN_WINDOW, (Object)0.0);
    }
}

