/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.mongodb.sharding;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.entity.group.DynamicClusterImpl;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBClientSupport;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBReplicaSet;
import org.apache.brooklyn.entity.nosql.mongodb.MongoDBServer;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBRouter;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBRouterCluster;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBShardCluster;
import org.apache.brooklyn.entity.nosql.mongodb.sharding.MongoDBShardedDeployment;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBShardClusterImpl
extends DynamicClusterImpl
implements MongoDBShardCluster {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBShardClusterImpl.class);
    private Set<Entity> addedMembers = Sets.newConcurrentHashSet();
    private Set<Entity> addingMembers = Sets.newConcurrentHashSet();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    protected EntitySpec<?> getMemberSpec() {
        EntitySpec result = super.getMemberSpec();
        if (result == null) {
            result = EntitySpec.create(MongoDBReplicaSet.class);
        }
        result.configure((ConfigKey)DynamicClusterImpl.INITIAL_SIZE, this.getConfig(MongoDBShardedDeployment.SHARD_REPLICASET_SIZE));
        return result;
    }

    public void start(Collection<? extends Location> locations) {
        this.subscriptions().subscribeToMembers((Group)this, (Sensor)Startable.SERVICE_UP, (SensorEventListener)new SensorEventListener<Boolean>(){

            public void onEvent(SensorEvent<Boolean> event) {
                MongoDBShardClusterImpl.this.addShards();
            }
        });
        super.start(locations);
        MongoDBRouterCluster routers = (MongoDBRouterCluster)this.getParent().getAttribute(MongoDBShardedDeployment.ROUTER_CLUSTER);
        this.subscriptions().subscribe((Entity)routers, MongoDBRouterCluster.ANY_RUNNING_ROUTER, (SensorEventListener)new SensorEventListener<MongoDBRouter>(){

            public void onEvent(SensorEvent<MongoDBRouter> event) {
                if (event.getValue() != null) {
                    MongoDBShardClusterImpl.this.addShards();
                }
            }
        });
    }

    public void stop() {
        this.executor.shutdownNow();
        super.stop();
    }

    public void onManagementStopped() {
        super.onManagementStopped();
        this.executor.shutdownNow();
    }

    protected void addShards() {
        MongoDBRouter router = (MongoDBRouter)((MongoDBRouterCluster)this.getParent().getAttribute(MongoDBShardedDeployment.ROUTER_CLUSTER)).getAttribute(MongoDBRouterCluster.ANY_RUNNING_ROUTER);
        if (router == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Not adding shards because no running router in {}", (Object)this);
            }
            return;
        }
        for (Entity member : this.getMembers()) {
            if (!((Boolean)member.getAttribute(Startable.SERVICE_UP)).booleanValue() || this.addingMembers.contains(member)) continue;
            LOG.info("{} adding shard {}", new Object[]{this, member});
            this.addingMembers.add(member);
            this.addShardAsync(member);
        }
    }

    protected void addShardAsync(final Entity replicaSet) {
        final Duration timeout = Duration.minutes((Number)20);
        final Stopwatch stopwatch = Stopwatch.createStarted();
        final AtomicInteger attempts = new AtomicInteger();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                boolean reschedule;
                MongoDBRouter router = (MongoDBRouter)((MongoDBRouterCluster)MongoDBShardClusterImpl.this.getParent().getAttribute(MongoDBShardedDeployment.ROUTER_CLUSTER)).getAttribute(MongoDBRouterCluster.ANY_RUNNING_ROUTER);
                if (router == null) {
                    LOG.debug("Rescheduling adding shard {} because no running router for cluster {}", (Object)replicaSet, (Object)this);
                    reschedule = true;
                } else {
                    MongoDBClientSupport client;
                    try {
                        client = MongoDBClientSupport.forServer(router);
                    }
                    catch (UnknownHostException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                    try {
                        MongoDBServer primary = (MongoDBServer)replicaSet.getAttribute(MongoDBReplicaSet.PRIMARY_ENTITY);
                        if (primary != null) {
                            String addr = String.format("%s:%d", primary.getAttribute(MongoDBServer.SUBNET_HOSTNAME), primary.getAttribute((AttributeSensor)MongoDBServer.PORT));
                            String replicaSetURL = ((MongoDBReplicaSet)replicaSet).getName() + "/" + addr;
                            boolean added = client.addShardToRouter(replicaSetURL);
                            if (added) {
                                LOG.info("{} added shard {} via {}", new Object[]{MongoDBShardClusterImpl.this, replicaSetURL, router});
                                MongoDBShardClusterImpl.this.addedMembers.add(replicaSet);
                                reschedule = false;
                            } else {
                                LOG.debug("Rescheduling addition of shard {} because add failed via router {}", (Object)replicaSetURL, (Object)router);
                                reschedule = true;
                            }
                        } else {
                            LOG.debug("Rescheduling addition of shard {} because primary is null", (Object)replicaSet);
                            reschedule = true;
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Failed to add shard to router {}:  ", (Object)router, (Object)e);
                        throw Exceptions.propagate((Throwable)e);
                    }
                }
                if (reschedule) {
                    int numAttempts = attempts.incrementAndGet();
                    if (numAttempts > 1 && timeout.toMilliseconds() > stopwatch.elapsed(TimeUnit.MILLISECONDS)) {
                        MongoDBShardClusterImpl.this.executor.schedule(this, 3L, TimeUnit.SECONDS);
                    } else {
                        LOG.warn("Timeout after {} attempts ({}) adding shard {}; aborting", new Object[]{numAttempts, Time.makeTimeStringRounded((Stopwatch)stopwatch), replicaSet});
                        MongoDBShardClusterImpl.this.addingMembers.remove(replicaSet);
                    }
                }
            }
        });
    }
}

