/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.followthesun;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.trait.Resizable;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.policy.followthesun.FollowTheSunPool;
import org.apache.brooklyn.policy.loadbalancing.Movable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowTheSunPoolImpl
extends AbstractEntity
implements FollowTheSunPool {
    private static final Logger LOG = LoggerFactory.getLogger(FollowTheSunPool.class);
    private Group containerGroup;
    private Group itemGroup;
    private final Set<Entity> containers = Collections.synchronizedSet(new HashSet());
    private final Set<Entity> items = Collections.synchronizedSet(new HashSet());
    private final SensorEventListener<Object> eventHandler = new SensorEventListener<Object>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onEvent(SensorEvent<Object> event) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} received event {}", (Object)FollowTheSunPoolImpl.this, event);
            }
            Entity source = event.getSource();
            Object value = event.getValue();
            Sensor sensor = event.getSensor();
            if (sensor.equals(AbstractGroup.MEMBER_ADDED)) {
                if (source.equals(FollowTheSunPoolImpl.this.containerGroup)) {
                    FollowTheSunPoolImpl.this.onContainerAdded((Entity)value);
                    return;
                } else {
                    if (!source.equals(FollowTheSunPoolImpl.this.itemGroup)) throw new IllegalStateException("unexpected event source=" + source);
                    FollowTheSunPoolImpl.this.onItemAdded((Entity)value);
                }
                return;
            } else if (sensor.equals(AbstractGroup.MEMBER_REMOVED)) {
                if (source.equals(FollowTheSunPoolImpl.this.containerGroup)) {
                    FollowTheSunPoolImpl.this.onContainerRemoved((Entity)value);
                    return;
                } else {
                    if (!source.equals(FollowTheSunPoolImpl.this.itemGroup)) throw new IllegalStateException("unexpected event source=" + source);
                    FollowTheSunPoolImpl.this.onItemRemoved((Entity)value);
                }
                return;
            } else if (sensor.equals(Startable.SERVICE_UP)) {
                if (((Boolean)value).booleanValue()) {
                    FollowTheSunPoolImpl.this.onContainerUp(source);
                    return;
                } else {
                    FollowTheSunPoolImpl.this.onContainerDown(source);
                }
                return;
            } else {
                if (!sensor.equals(Movable.CONTAINER)) throw new IllegalStateException("Unhandled event type " + sensor + ": " + event);
                FollowTheSunPoolImpl.this.onItemMoved(source, (Entity)value);
            }
        }
    };

    @Override
    public void setContents(Group containerGroup, Group itemGroup) {
        this.containerGroup = containerGroup;
        this.itemGroup = itemGroup;
        this.subscriptions().subscribe((Entity)containerGroup, (Sensor)AbstractGroup.MEMBER_ADDED, this.eventHandler);
        this.subscriptions().subscribe((Entity)containerGroup, (Sensor)AbstractGroup.MEMBER_REMOVED, this.eventHandler);
        this.subscriptions().subscribe((Entity)itemGroup, (Sensor)AbstractGroup.MEMBER_ADDED, this.eventHandler);
        this.subscriptions().subscribe((Entity)itemGroup, (Sensor)AbstractGroup.MEMBER_REMOVED, this.eventHandler);
        for (Entity existingContainer : containerGroup.getMembers()) {
            this.onContainerAdded(existingContainer);
        }
        for (Entity existingItem : itemGroup.getMembers()) {
            this.onItemAdded(existingItem);
        }
    }

    @Override
    public Group getContainerGroup() {
        return this.containerGroup;
    }

    @Override
    public Group getItemGroup() {
        return this.itemGroup;
    }

    public Integer getCurrentSize() {
        return this.containerGroup.getCurrentSize();
    }

    public Integer resize(Integer desiredSize) {
        if (this.containerGroup instanceof Resizable) {
            return ((Resizable)this.containerGroup).resize(desiredSize);
        }
        throw new UnsupportedOperationException("Container group is not resizable");
    }

    private void onContainerAdded(Entity newContainer) {
        this.subscriptions().subscribe(newContainer, (Sensor)Startable.SERVICE_UP, this.eventHandler);
        if (!(newContainer instanceof Startable) || Boolean.TRUE.equals(newContainer.getAttribute(Startable.SERVICE_UP))) {
            this.onContainerUp(newContainer);
        }
    }

    private void onContainerUp(Entity newContainer) {
        if (this.containers.add(newContainer)) {
            this.sensors().emit((Sensor)CONTAINER_ADDED, (Object)newContainer);
        }
    }

    private void onContainerDown(Entity oldContainer) {
        if (this.containers.remove(oldContainer)) {
            this.sensors().emit((Sensor)CONTAINER_REMOVED, (Object)oldContainer);
        }
    }

    private void onContainerRemoved(Entity oldContainer) {
        this.subscriptions().unsubscribe(oldContainer);
        this.onContainerDown(oldContainer);
    }

    private void onItemAdded(Entity item) {
        if (this.items.add(item)) {
            this.subscriptions().subscribe(item, Movable.CONTAINER, this.eventHandler);
            this.sensors().emit((Sensor)ITEM_ADDED, (Object)item);
        }
    }

    private void onItemRemoved(Entity item) {
        if (this.items.remove(item)) {
            this.subscriptions().unsubscribe(item);
            this.sensors().emit((Sensor)ITEM_REMOVED, (Object)item);
        }
    }

    private void onItemMoved(Entity item, Entity container) {
        this.sensors().emit((Sensor)ITEM_MOVED, (Object)new FollowTheSunPool.ContainerItemPair(container, item));
    }
}

