/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.api.mgmt.rebind;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.mgmt.rebind.ChangeListener;
import org.apache.brooklyn.api.mgmt.rebind.PersistenceExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.RebindExceptionHandler;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoPersister;
import org.apache.brooklyn.api.mgmt.rebind.mementos.BrooklynMementoRawData;
import org.apache.brooklyn.util.time.Duration;

public interface RebindManager {
    public boolean isRebindActive();

    public void setPersister(BrooklynMementoPersister var1);

    public void setPersister(BrooklynMementoPersister var1, PersistenceExceptionHandler var2);

    @VisibleForTesting
    public BrooklynMementoPersister getPersister();

    public PersistenceExceptionHandler getPersisterExceptionHandler();

    @Beta
    public List<Application> rebind(ClassLoader var1, RebindExceptionHandler var2, ManagementNodeState var3);

    public BrooklynMementoRawData retrieveMementoRawData();

    public ChangeListener getChangeListener();

    public void startPersistence();

    public void stopPersistence();

    public void startReadOnly(ManagementNodeState var1);

    public void stopReadOnly();

    @Beta
    public void stopEntityTasksAndCleanUp(String var1, Duration var2, Duration var3);

    public boolean isReadOnly();

    public void reset();

    public void start();

    public void stop();

    @VisibleForTesting
    public void waitForPendingComplete(Duration var1, boolean var2) throws InterruptedException, TimeoutException;

    @VisibleForTesting
    public boolean hasPending();

    @VisibleForTesting
    public void forcePersistNow(boolean var1, @Nullable PersistenceExceptionHandler var2);

    public boolean isAwaitingInitialRebind();

    public Map<String, Object> getMetrics();

    public static enum RebindFailureMode {
        FAIL_FAST,
        FAIL_AT_END,
        CONTINUE;

    }
}

