/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.volumes;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.integrationspec.template.spec.volumes.Cinder;
import org.apache.camel.v1.integrationspec.template.spec.volumes.cinder.SecretRef;
import org.apache.camel.v1.integrationspec.template.spec.volumes.cinder.SecretRefBuilder;
import org.apache.camel.v1.integrationspec.template.spec.volumes.cinder.SecretRefFluent;

public class CinderFluent<A extends CinderFluent<A>>
extends BaseFluent<A> {
    private String fsType;
    private Boolean readOnly;
    private SecretRefBuilder secretRef;
    private String volumeID;

    public CinderFluent() {
    }

    public CinderFluent(Cinder instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Cinder instance) {
        Cinder cinder = instance = instance != null ? instance : new Cinder();
        if (instance != null) {
            this.withFsType(instance.getFsType());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
            this.withVolumeID(instance.getVolumeID());
        }
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)((Object)this);
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)((Object)this);
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public SecretRef buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretRef secretRef) {
        this._visitables.remove((Object)"secretRef");
        if (secretRef != null) {
            this.secretRef = new SecretRefBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(SecretRef item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editCinderSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretRefBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(SecretRef item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public String getVolumeID() {
        return this.volumeID;
    }

    public A withVolumeID(String volumeID) {
        this.volumeID = volumeID;
        return (A)((Object)this);
    }

    public boolean hasVolumeID() {
        return this.volumeID != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CinderFluent that = (CinderFluent)((Object)o);
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals((Object)this.secretRef, (Object)that.secretRef)) {
            return false;
        }
        return Objects.equals(this.volumeID, that.volumeID);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fsType, this.readOnly, this.secretRef, this.volumeID, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.volumeID != null) {
            sb.append("volumeID:");
            sb.append(this.volumeID);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class SecretRefNested<N>
    extends SecretRefFluent<SecretRefNested<N>>
    implements Nested<N> {
        SecretRefBuilder builder;

        SecretRefNested(SecretRef item) {
            this.builder = new SecretRefBuilder(this, item);
        }

        public N and() {
            return (N)CinderFluent.this.withSecretRef(this.builder.build());
        }

        public N endCinderSecretRef() {
            return this.and();
        }
    }
}

