/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.buildspec.tasks.package_.Configuration;
import org.apache.camel.v1.buildspec.tasks.package_.Maven;
import org.apache.camel.v1.buildspec.tasks.package_.Runtime;
import org.apache.camel.v1.buildspec.tasks.package_.Sources;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"baseImage", "buildDir", "configuration", "dependencies", "maven", "name", "runtime", "sources", "steps"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Package
implements KubernetesResource {
    @JsonProperty(value="baseImage")
    @JsonPropertyDescription(value="the base image layer")
    @JsonSetter(nulls=Nulls.SKIP)
    private String baseImage;
    @JsonProperty(value="buildDir")
    @JsonPropertyDescription(value="workspace directory to use")
    @JsonSetter(nulls=Nulls.SKIP)
    private String buildDir;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="The configuration that should be used to perform the Build.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="dependencies")
    @JsonPropertyDescription(value="the list of dependencies to use for this build")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> dependencies;
    @JsonProperty(value="maven")
    @JsonPropertyDescription(value="the configuration required by Maven for the application build phase")
    @JsonSetter(nulls=Nulls.SKIP)
    private Maven maven;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="name of the task")
    @JsonSetter(nulls=Nulls.SKIP)
    private String name;
    @JsonProperty(value="runtime")
    @JsonPropertyDescription(value="the configuration required for the runtime application")
    @JsonSetter(nulls=Nulls.SKIP)
    private Runtime runtime;
    @JsonProperty(value="sources")
    @JsonPropertyDescription(value="the sources to add at build time")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Sources> sources;
    @JsonProperty(value="steps")
    @JsonPropertyDescription(value="the list of steps to execute (see pkg/builder/)")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> steps;

    public String getBaseImage() {
        return this.baseImage;
    }

    public void setBaseImage(String baseImage) {
        this.baseImage = baseImage;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public void setBuildDir(String buildDir) {
        this.buildDir = buildDir;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public Maven getMaven() {
        return this.maven;
    }

    public void setMaven(Maven maven) {
        this.maven = maven;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public List<Sources> getSources() {
        return this.sources;
    }

    public void setSources(List<Sources> sources) {
        this.sources = sources;
    }

    public List<String> getSteps() {
        return this.steps;
    }

    public void setSteps(List<String> steps) {
        this.steps = steps;
    }

    public String toString() {
        return "Package(baseImage=" + this.getBaseImage() + ", buildDir=" + this.getBuildDir() + ", configuration=" + this.getConfiguration() + ", dependencies=" + this.getDependencies() + ", maven=" + this.getMaven() + ", name=" + this.getName() + ", runtime=" + this.getRuntime() + ", sources=" + this.getSources() + ", steps=" + this.getSteps() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Package)) {
            return false;
        }
        Package other = (Package)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$baseImage = this.getBaseImage();
        String other$baseImage = other.getBaseImage();
        if (this$baseImage == null ? other$baseImage != null : !this$baseImage.equals(other$baseImage)) {
            return false;
        }
        String this$buildDir = this.getBuildDir();
        String other$buildDir = other.getBuildDir();
        if (this$buildDir == null ? other$buildDir != null : !this$buildDir.equals(other$buildDir)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<String> this$dependencies = this.getDependencies();
        List<String> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        Maven this$maven = this.getMaven();
        Maven other$maven = other.getMaven();
        if (this$maven == null ? other$maven != null : !((Object)this$maven).equals(other$maven)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Runtime this$runtime = this.getRuntime();
        Runtime other$runtime = other.getRuntime();
        if (this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime)) {
            return false;
        }
        List<Sources> this$sources = this.getSources();
        List<Sources> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        List<String> this$steps = this.getSteps();
        List<String> other$steps = other.getSteps();
        return !(this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Package;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $baseImage = this.getBaseImage();
        result = result * 59 + ($baseImage == null ? 43 : $baseImage.hashCode());
        String $buildDir = this.getBuildDir();
        result = result * 59 + ($buildDir == null ? 43 : $buildDir.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<String> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        Maven $maven = this.getMaven();
        result = result * 59 + ($maven == null ? 43 : ((Object)$maven).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Runtime $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
        List<Sources> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        List<String> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        return result;
    }
}

