/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.autorelationship;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.modeler.dialog.autorelationship.InferredRelationship;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.commons.collections.Predicate;

public class InferRelationshipsControllerBase
extends CayenneController {
    public static final String SELECTED_PROPERTY = "selected";
    protected DataMap dataMap;
    protected List<InferredRelationship> inferredRelationships;
    protected List<DbEntity> entities;
    protected Set<InferredRelationship> selectedEntities;
    protected int index = 0;
    protected ObjectNameGenerator strategy;
    protected transient InferredRelationship currentEntity;

    public InferRelationshipsControllerBase(CayenneController parent, DataMap dataMap) {
        super(parent);
        this.dataMap = dataMap;
        this.entities = new ArrayList<DbEntity>(dataMap.getDbEntities());
        this.selectedEntities = new HashSet<InferredRelationship>();
    }

    public void setRelationships() {
        this.inferredRelationships = new ArrayList<InferredRelationship>();
        for (DbEntity entity : this.entities) {
            this.createRelationships(entity);
        }
        this.createJoins();
        this.createNames();
    }

    protected void createRelationships(DbEntity entity) {
        for (DbAttribute attribute : entity.getAttributes()) {
            String name = attribute.getName();
            if (name.length() < 4 || !name.substring(name.length() - 3, name.length()).equalsIgnoreCase("_ID")) continue;
            String baseName = name.substring(0, name.length() - 3);
            for (DbEntity targetEntity : this.entities) {
                if (targetEntity == entity || !baseName.equalsIgnoreCase(targetEntity.getName()) || attribute.isPrimaryKey() || targetEntity.getAttributes().isEmpty()) continue;
                if (!attribute.isForeignKey()) {
                    InferredRelationship myir = new InferredRelationship();
                    myir.setSource(entity);
                    myir.setTarget(targetEntity);
                    this.inferredRelationships.add(myir);
                }
                this.createReversRelationship(targetEntity, entity);
            }
        }
    }

    public void createReversRelationship(DbEntity eSourse, DbEntity eTarget) {
        InferredRelationship myir = new InferredRelationship();
        for (DbRelationship relationship : eSourse.getRelationships()) {
            for (DbJoin join : relationship.getJoins()) {
                if (!join.getSource().getEntity().equals(eSourse) || !join.getTarget().getEntity().equals(eTarget)) continue;
                return;
            }
        }
        myir.setSource(eSourse);
        myir.setTarget(eTarget);
        this.inferredRelationships.add(myir);
    }

    public String getJoin(InferredRelationship irItem) {
        return irItem.getJoinSource().getName() + " : " + irItem.getJoinTarget().getName();
    }

    public String getToMany(InferredRelationship irItem) {
        if (irItem.isToMany()) {
            return "to many";
        }
        return "to one";
    }

    protected DbAttribute getJoinAttribute(DbEntity sEntity, DbEntity tEntity) {
        if (sEntity.getAttributes().size() == 1) {
            return sEntity.getAttributes().iterator().next();
        }
        for (DbAttribute attr : sEntity.getAttributes()) {
            if (!attr.getName().equalsIgnoreCase(tEntity.getName() + "_ID")) continue;
            return attr;
        }
        for (DbAttribute attr : sEntity.getAttributes()) {
            if (!attr.getName().equalsIgnoreCase(sEntity.getName() + "_ID") || attr.isPrimaryKey()) continue;
            return attr;
        }
        for (DbAttribute attr : sEntity.getAttributes()) {
            if (!attr.isPrimaryKey()) continue;
            return attr;
        }
        return null;
    }

    protected void createJoins() {
        Iterator<InferredRelationship> it = this.inferredRelationships.iterator();
        while (it.hasNext()) {
            InferredRelationship inferred = it.next();
            DbAttribute src = this.getJoinAttribute(inferred.getSource(), inferred.getTarget());
            if (src == null) {
                it.remove();
                continue;
            }
            DbAttribute target = this.getJoinAttribute(inferred.getTarget(), inferred.getSource());
            if (target == null) {
                it.remove();
                continue;
            }
            inferred.setJoinSource(src);
            if (src.isPrimaryKey()) {
                inferred.setToMany(true);
            }
            inferred.setJoinTarget(target);
        }
    }

    protected void createNames() {
        for (InferredRelationship myir : this.inferredRelationships) {
            DbRelationship localRelationship = new DbRelationship();
            localRelationship.setToMany(myir.isToMany());
            if (myir.getJoinSource().isPrimaryKey()) {
                localRelationship.addJoin(new DbJoin(localRelationship, myir.getJoinSource().getName(), myir.getJoinTarget().getName()));
                localRelationship.setSourceEntity(myir.getSource());
                localRelationship.setTargetEntityName(myir.getTarget().getName());
            } else {
                localRelationship.addJoin(new DbJoin(localRelationship, myir.getJoinTarget().getName(), myir.getJoinSource().getName()));
                localRelationship.setSourceEntity(myir.getTarget());
                localRelationship.setTargetEntityName(myir.getSource().getName());
            }
            myir.setName(this.strategy.relationshipName(localRelationship));
        }
    }

    public List<InferredRelationship> getSelectedEntities() {
        ArrayList<InferredRelationship> selected = new ArrayList<InferredRelationship>(this.selectedEntities.size());
        for (InferredRelationship entity : this.inferredRelationships) {
            if (!this.selectedEntities.contains(entity)) continue;
            selected.add(entity);
        }
        return selected;
    }

    public boolean updateSelection(Predicate predicate) {
        boolean modified = false;
        for (InferredRelationship entity : this.inferredRelationships) {
            boolean select = predicate.evaluate(entity);
            if (select) {
                if (!this.selectedEntities.add(entity)) continue;
                modified = true;
                continue;
            }
            if (!this.selectedEntities.remove(entity)) continue;
            modified = true;
        }
        if (modified) {
            this.firePropertyChange(SELECTED_PROPERTY, null, null);
        }
        return modified;
    }

    public boolean isSelected() {
        return this.currentEntity != null ? this.selectedEntities.contains(this.currentEntity) : false;
    }

    public void setSelected(boolean selectedFlag) {
        if (this.currentEntity == null) {
            return;
        }
        if (selectedFlag) {
            if (this.selectedEntities.add(this.currentEntity)) {
                this.firePropertyChange(SELECTED_PROPERTY, null, null);
            }
        } else if (this.selectedEntities.remove(this.currentEntity)) {
            this.firePropertyChange(SELECTED_PROPERTY, null, null);
        }
    }

    public int getSelectedEntitiesSize() {
        return this.selectedEntities.size();
    }

    public List getEntities() {
        return this.inferredRelationships;
    }

    public InferredRelationship getCurrentEntity() {
        return this.currentEntity;
    }

    public void setCurrentEntity(InferredRelationship currentEntity) {
        this.currentEntity = currentEntity;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    @Override
    public Component getView() {
        return null;
    }

    public void setNamingStrategy(ObjectNameGenerator namestr) {
        this.strategy = namestr;
    }
}

