/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils2.BasicDynaClass;
import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.beanutils2.ConvertUtils;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaClass;
import org.apache.commons.beanutils2.DynaProperty;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.TestBean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DynaBeanUtilsTest {
    protected DynaBean bean;
    protected TestBean nested;
    protected String[] describes = new String[]{"booleanProperty", "booleanSecond", "byteProperty", "doubleProperty", "dupProperty", "floatProperty", "intArray", "intIndexed", "intProperty", "listIndexed", "longProperty", "mapProperty", "mappedProperty", "mappedIntProperty", "nested", "nullProperty", "shortProperty", "stringArray", "stringIndexed", "stringProperty"};

    protected static DynaClass createDynaClass() {
        int[] intArray = new int[]{};
        String[] stringArray = new String[]{};
        return new BasicDynaClass("TestDynaClass", null, new DynaProperty[]{new DynaProperty("booleanProperty", Boolean.TYPE), new DynaProperty("booleanSecond", Boolean.TYPE), new DynaProperty("byteProperty", Byte.TYPE), new DynaProperty("doubleProperty", Double.TYPE), new DynaProperty("dupProperty", stringArray.getClass()), new DynaProperty("floatProperty", Float.TYPE), new DynaProperty("intArray", intArray.getClass()), new DynaProperty("intIndexed", intArray.getClass()), new DynaProperty("intProperty", Integer.TYPE), new DynaProperty("listIndexed", List.class), new DynaProperty("longProperty", Long.TYPE), new DynaProperty("mapProperty", Map.class), new DynaProperty("mappedProperty", Map.class), new DynaProperty("mappedIntProperty", Map.class), new DynaProperty("nested", TestBean.class), new DynaProperty("nullProperty", String.class), new DynaProperty("shortProperty", Short.TYPE), new DynaProperty("stringArray", stringArray.getClass()), new DynaProperty("stringIndexed", stringArray.getClass()), new DynaProperty("stringProperty", String.class)});
    }

    protected void checkIntArray(int[] actual, int[] expected) {
        Assertions.assertNotNull((Object)actual, (String)"actual array not null");
        Assertions.assertEquals((int)expected.length, (int)actual.length, (String)"actual array length");
        for (int i = 0; i < actual.length; ++i) {
            Assertions.assertEquals((int)expected[i], (int)actual[i], (String)("actual array value[" + i + "]"));
        }
    }

    protected void checkMap(Map<?, ?> actual, Map<?, ?> expected) {
        Assertions.assertNotNull(actual, (String)"actual map not null");
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"actual map size");
        for (Object key : expected.keySet()) {
            Assertions.assertEquals(expected.get(key), actual.get(key), (String)("actual map value(" + key + ")"));
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        ConvertUtils.deregister();
        DynaClass dynaClass = DynaBeanUtilsTest.createDynaClass();
        this.bean = dynaClass.newInstance();
        this.bean.set("booleanProperty", (Object)true);
        this.bean.set("booleanSecond", (Object)true);
        this.bean.set("byteProperty", (Object)121);
        this.bean.set("doubleProperty", (Object)321.0);
        this.bean.set("floatProperty", (Object)Float.valueOf(123.0f));
        String[] dupProperty = new String[]{"Dup 0", "Dup 1", "Dup 2", "Dup 3", "Dup 4"};
        this.bean.set("dupProperty", (Object)dupProperty);
        int[] intArray = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intArray", (Object)intArray);
        int[] intIndexed = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intIndexed", (Object)intIndexed);
        this.bean.set("intProperty", (Object)123);
        ArrayList<String> listIndexed = new ArrayList<String>();
        listIndexed.add("String 0");
        listIndexed.add("String 1");
        listIndexed.add("String 2");
        listIndexed.add("String 3");
        listIndexed.add("String 4");
        this.bean.set("listIndexed", listIndexed);
        this.bean.set("longProperty", (Object)321L);
        HashMap<String, String> mapProperty = new HashMap<String, String>();
        mapProperty.put("First Key", "First Value");
        mapProperty.put("Second Key", "Second Value");
        this.bean.set("mapProperty", mapProperty);
        HashMap<String, String> mappedProperty = new HashMap<String, String>();
        mappedProperty.put("First Key", "First Value");
        mappedProperty.put("Second Key", "Second Value");
        this.bean.set("mappedProperty", mappedProperty);
        HashMap<String, Integer> mappedIntProperty = new HashMap<String, Integer>();
        mappedIntProperty.put("One", 1);
        mappedIntProperty.put("Two", 2);
        this.bean.set("mappedIntProperty", mappedIntProperty);
        this.nested = new TestBean();
        this.bean.set("nested", (Object)this.nested);
        this.bean.set("shortProperty", (Object)987);
        String[] stringArray = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringArray", (Object)stringArray);
        String[] stringIndexed = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringIndexed", (Object)stringIndexed);
        this.bean.set("stringProperty", (Object)"This is a string");
    }

    @AfterEach
    public void tearDown() {
        this.bean = null;
        this.nested = null;
    }

    @Test
    public void testCloneDynaBean() throws Exception {
        DynaClass dynaClass = DynaBeanUtilsTest.createDynaClass();
        DynaBean orig = dynaClass.newInstance();
        orig.set("booleanProperty", (Object)Boolean.FALSE);
        orig.set("byteProperty", (Object)111);
        orig.set("doubleProperty", (Object)333.33);
        orig.set("dupProperty", (Object)new String[]{"New 0", "New 1", "New 2"});
        orig.set("intArray", (Object)new int[]{100, 200, 300});
        orig.set("intProperty", (Object)333);
        orig.set("longProperty", (Object)3333L);
        orig.set("shortProperty", (Object)33);
        orig.set("stringArray", (Object)new String[]{"New 0", "New 1"});
        orig.set("stringProperty", (Object)"Custom string");
        DynaBean clonedBean = (DynaBean)BeanUtils.cloneBean((Object)orig);
        Assertions.assertEquals((Object)false, (Object)((Boolean)clonedBean.get("booleanProperty")), (String)"Cloned boolean property");
        Assertions.assertEquals((byte)111, (byte)((Byte)clonedBean.get("byteProperty")), (String)"Cloned byte property");
        Assertions.assertEquals((double)333.33, (double)((Double)clonedBean.get("doubleProperty")), (double)0.005, (String)"Cloned double property");
        Assertions.assertEquals((int)333, (int)((Integer)clonedBean.get("intProperty")), (String)"Cloned int property");
        Assertions.assertEquals((long)3333L, (long)((Long)clonedBean.get("longProperty")), (String)"Cloned long property");
        Assertions.assertEquals((short)33, (short)((Short)clonedBean.get("shortProperty")), (String)"Cloned short property");
        Assertions.assertEquals((Object)"Custom string", (Object)((String)clonedBean.get("stringProperty")), (String)"Cloned string property");
        String[] dupProperty = (String[])clonedBean.get("dupProperty");
        Assertions.assertNotNull((Object)dupProperty, (String)"dupProperty present");
        Assertions.assertEquals((int)3, (int)dupProperty.length, (String)"dupProperty length");
        Assertions.assertEquals((Object)"New 0", (Object)dupProperty[0], (String)"dupProperty[0]");
        Assertions.assertEquals((Object)"New 1", (Object)dupProperty[1], (String)"dupProperty[1]");
        Assertions.assertEquals((Object)"New 2", (Object)dupProperty[2], (String)"dupProperty[2]");
        int[] intArray = (int[])clonedBean.get("intArray");
        Assertions.assertNotNull((Object)intArray, (String)"intArray present");
        Assertions.assertEquals((int)3, (int)intArray.length, (String)"intArray length");
        Assertions.assertEquals((int)100, (int)intArray[0], (String)"intArray[0]");
        Assertions.assertEquals((int)200, (int)intArray[1], (String)"intArray[1]");
        Assertions.assertEquals((int)300, (int)intArray[2], (String)"intArray[2]");
        String[] stringArray = (String[])clonedBean.get("stringArray");
        Assertions.assertNotNull((Object)stringArray, (String)"stringArray present");
        Assertions.assertEquals((int)2, (int)stringArray.length, (String)"stringArray length");
        Assertions.assertEquals((Object)"New 0", (Object)stringArray[0], (String)"stringArray[0]");
        Assertions.assertEquals((Object)"New 1", (Object)stringArray[1], (String)"stringArray[1]");
    }

    @Test
    public void testCopyPropertiesDynaBean() throws Exception {
        DynaClass dynaClass = DynaBeanUtilsTest.createDynaClass();
        DynaBean orig = dynaClass.newInstance();
        orig.set("booleanProperty", (Object)Boolean.FALSE);
        orig.set("byteProperty", (Object)111);
        orig.set("doubleProperty", (Object)333.33);
        orig.set("dupProperty", (Object)new String[]{"New 0", "New 1", "New 2"});
        orig.set("intArray", (Object)new int[]{100, 200, 300});
        orig.set("intProperty", (Object)333);
        orig.set("longProperty", (Object)3333L);
        orig.set("shortProperty", (Object)33);
        orig.set("stringArray", (Object)new String[]{"New 0", "New 1"});
        orig.set("stringProperty", (Object)"Custom string");
        BeanUtils.copyProperties((Object)this.bean, (Object)orig);
        Assertions.assertEquals((Object)false, (Object)((Boolean)this.bean.get("booleanProperty")), (String)"Copied boolean property");
        Assertions.assertEquals((byte)111, (byte)((Byte)this.bean.get("byteProperty")), (String)"Copied byte property");
        Assertions.assertEquals((double)333.33, (double)((Double)this.bean.get("doubleProperty")), (double)0.005, (String)"Copied double property");
        Assertions.assertEquals((int)333, (int)((Integer)this.bean.get("intProperty")), (String)"Copied int property");
        Assertions.assertEquals((long)3333L, (long)((Long)this.bean.get("longProperty")), (String)"Copied long property");
        Assertions.assertEquals((short)33, (short)((Short)this.bean.get("shortProperty")), (String)"Copied short property");
        Assertions.assertEquals((Object)"Custom string", (Object)((String)this.bean.get("stringProperty")), (String)"Copied string property");
        String[] dupProperty = (String[])this.bean.get("dupProperty");
        Assertions.assertNotNull((Object)dupProperty, (String)"dupProperty present");
        Assertions.assertEquals((int)3, (int)dupProperty.length, (String)"dupProperty length");
        Assertions.assertEquals((Object)"New 0", (Object)dupProperty[0], (String)"dupProperty[0]");
        Assertions.assertEquals((Object)"New 1", (Object)dupProperty[1], (String)"dupProperty[1]");
        Assertions.assertEquals((Object)"New 2", (Object)dupProperty[2], (String)"dupProperty[2]");
        int[] intArray = (int[])this.bean.get("intArray");
        Assertions.assertNotNull((Object)intArray, (String)"intArray present");
        Assertions.assertEquals((int)3, (int)intArray.length, (String)"intArray length");
        Assertions.assertEquals((int)100, (int)intArray[0], (String)"intArray[0]");
        Assertions.assertEquals((int)200, (int)intArray[1], (String)"intArray[1]");
        Assertions.assertEquals((int)300, (int)intArray[2], (String)"intArray[2]");
        String[] stringArray = (String[])this.bean.get("stringArray");
        Assertions.assertNotNull((Object)stringArray, (String)"stringArray present");
        Assertions.assertEquals((int)2, (int)stringArray.length, (String)"stringArray length");
        Assertions.assertEquals((Object)"New 0", (Object)stringArray[0], (String)"stringArray[0]");
        Assertions.assertEquals((Object)"New 1", (Object)stringArray[1], (String)"stringArray[1]");
    }

    @Test
    public void testCopyPropertiesMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("booleanProperty", "false");
        map.put("byteProperty", "111");
        map.put("doubleProperty", "333.0");
        map.put("dupProperty", new String[]{"New 0", "New 1", "New 2"});
        map.put("floatProperty", "222.0");
        map.put("intArray", new String[]{"0", "100", "200"});
        map.put("intProperty", "111");
        map.put("longProperty", "444");
        map.put("shortProperty", "555");
        map.put("stringProperty", "New String Property");
        BeanUtils.copyProperties((Object)this.bean, map);
        Assertions.assertEquals((Object)false, (Object)((Boolean)this.bean.get("booleanProperty")), (String)"booleanProperty");
        Assertions.assertEquals((byte)111, (byte)((Byte)this.bean.get("byteProperty")), (String)"byteProperty");
        Assertions.assertEquals((double)333.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005, (String)"doubleProperty");
        Assertions.assertEquals((float)222.0f, (float)((Float)this.bean.get("floatProperty")).floatValue(), (float)0.005f, (String)"floatProperty");
        Assertions.assertEquals((int)111, (int)((Integer)this.bean.get("intProperty")), (String)"intProperty");
        Assertions.assertEquals((long)444L, (long)((Long)this.bean.get("longProperty")), (String)"longProperty");
        Assertions.assertEquals((short)555, (short)((Short)this.bean.get("shortProperty")), (String)"shortProperty");
        Assertions.assertEquals((Object)"New String Property", (Object)((String)this.bean.get("stringProperty")), (String)"stringProperty");
        String[] dupProperty = (String[])this.bean.get("dupProperty");
        Assertions.assertNotNull((Object)dupProperty, (String)"dupProperty present");
        Assertions.assertEquals((int)3, (int)dupProperty.length, (String)"dupProperty length");
        Assertions.assertEquals((Object)"New 0", (Object)dupProperty[0], (String)"dupProperty[0]");
        Assertions.assertEquals((Object)"New 1", (Object)dupProperty[1], (String)"dupProperty[1]");
        Assertions.assertEquals((Object)"New 2", (Object)dupProperty[2], (String)"dupProperty[2]");
        int[] intArray = (int[])this.bean.get("intArray");
        Assertions.assertNotNull((Object)intArray, (String)"intArray present");
        Assertions.assertEquals((int)3, (int)intArray.length, (String)"intArray length");
        Assertions.assertEquals((int)0, (int)intArray[0], (String)"intArray[0]");
        Assertions.assertEquals((int)100, (int)intArray[1], (String)"intArray[1]");
        Assertions.assertEquals((int)200, (int)intArray[2], (String)"intArray[2]");
    }

    @Test
    public void testCopyPropertiesStandard() throws Exception {
        TestBean orig = new TestBean();
        orig.setBooleanProperty(false);
        orig.setByteProperty((byte)111);
        orig.setDoubleProperty(333.33);
        orig.setDupProperty(new String[]{"New 0", "New 1", "New 2"});
        orig.setIntArray(new int[]{100, 200, 300});
        orig.setIntProperty(333);
        orig.setLongProperty(3333L);
        orig.setShortProperty((short)33);
        orig.setStringArray(new String[]{"New 0", "New 1"});
        orig.setStringProperty("Custom string");
        BeanUtils.copyProperties((Object)this.bean, (Object)orig);
        Assertions.assertEquals((Object)false, (Object)((Boolean)this.bean.get("booleanProperty")), (String)"Copied boolean property");
        Assertions.assertEquals((byte)111, (byte)((Byte)this.bean.get("byteProperty")), (String)"Copied byte property");
        Assertions.assertEquals((double)333.33, (double)((Double)this.bean.get("doubleProperty")), (double)0.005, (String)"Copied double property");
        Assertions.assertEquals((int)333, (int)((Integer)this.bean.get("intProperty")), (String)"Copied int property");
        Assertions.assertEquals((long)3333L, (long)((Long)this.bean.get("longProperty")), (String)"Copied long property");
        Assertions.assertEquals((short)33, (short)((Short)this.bean.get("shortProperty")), (String)"Copied short property");
        Assertions.assertEquals((Object)"Custom string", (Object)((String)this.bean.get("stringProperty")), (String)"Copied string property");
        String[] dupProperty = (String[])this.bean.get("dupProperty");
        Assertions.assertNotNull((Object)dupProperty, (String)"dupProperty present");
        Assertions.assertEquals((int)3, (int)dupProperty.length, (String)"dupProperty length");
        Assertions.assertEquals((Object)"New 0", (Object)dupProperty[0], (String)"dupProperty[0]");
        Assertions.assertEquals((Object)"New 1", (Object)dupProperty[1], (String)"dupProperty[1]");
        Assertions.assertEquals((Object)"New 2", (Object)dupProperty[2], (String)"dupProperty[2]");
        int[] intArray = (int[])this.bean.get("intArray");
        Assertions.assertNotNull((Object)intArray, (String)"intArray present");
        Assertions.assertEquals((int)3, (int)intArray.length, (String)"intArray length");
        Assertions.assertEquals((int)100, (int)intArray[0], (String)"intArray[0]");
        Assertions.assertEquals((int)200, (int)intArray[1], (String)"intArray[1]");
        Assertions.assertEquals((int)300, (int)intArray[2], (String)"intArray[2]");
        String[] stringArray = (String[])this.bean.get("stringArray");
        Assertions.assertNotNull((Object)stringArray, (String)"stringArray present");
        Assertions.assertEquals((int)2, (int)stringArray.length, (String)"stringArray length");
        Assertions.assertEquals((Object)"New 0", (Object)stringArray[0], (String)"stringArray[0]");
        Assertions.assertEquals((Object)"New 1", (Object)stringArray[1], (String)"stringArray[1]");
    }

    @Test
    public void testCopyPropertyByte() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)123);
        Assertions.assertEquals((byte)123, (byte)((Byte)this.bean.get("byteProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)123);
        Assertions.assertEquals((byte)123, (byte)((Byte)this.bean.get("byteProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)123L);
        Assertions.assertEquals((byte)123, (byte)((Byte)this.bean.get("byteProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"byteProperty", (Object)123);
        Assertions.assertEquals((byte)123, (byte)((Byte)this.bean.get("byteProperty")));
    }

    @Test
    public void testCopyPropertyDouble() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)123.0);
        Assertions.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)Float.valueOf(123.0f));
        Assertions.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)123L);
        Assertions.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"doubleProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005);
    }

    @Test
    public void testCopyPropertyFloat() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)123.0);
        Assertions.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)Float.valueOf(123.0f));
        Assertions.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)123L);
        Assertions.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
        BeanUtils.setProperty((Object)this.bean, (String)"floatProperty", (Object)123);
        Assertions.assertEquals((double)123.0, (double)((Float)this.bean.get("floatProperty")).floatValue(), (double)0.005);
    }

    @Test
    public void testCopyPropertyInteger() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((int)123, (int)((Integer)this.bean.get("intProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((int)123, (int)((Integer)this.bean.get("intProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123L);
        Assertions.assertEquals((int)123, (int)((Integer)this.bean.get("intProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((int)123, (int)((Integer)this.bean.get("intProperty")));
    }

    @Test
    public void testCopyPropertyLong() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((long)123L, (long)((Long)this.bean.get("longProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((long)123L, (long)((Long)this.bean.get("longProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123L);
        Assertions.assertEquals((long)123L, (long)((Long)this.bean.get("longProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"longProperty", (Object)123);
        Assertions.assertEquals((long)123L, (long)((Long)this.bean.get("longProperty")));
    }

    @Test
    public void testCopyPropertyNestedIndexedArray() throws Exception {
        int[] origArray = new int[]{0, 10, 20, 30, 40};
        int[] intArray = new int[]{0, 0, 0};
        ((TestBean)this.bean.get("nested")).setIntArray(intArray);
        int[] intChanged = new int[]{0, 0, 0};
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)1);
        this.checkIntArray((int[])this.bean.get("intArray"), origArray);
        intChanged[1] = 1;
        this.checkIntArray(((TestBean)this.bean.get("nested")).getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)2);
        this.checkIntArray((int[])this.bean.get("intArray"), origArray);
        intChanged[1] = 2;
        this.checkIntArray(((TestBean)this.bean.get("nested")).getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)3L);
        this.checkIntArray((int[])this.bean.get("intArray"), origArray);
        intChanged[1] = 3;
        this.checkIntArray(((TestBean)this.bean.get("nested")).getIntArray(), intChanged);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intArray[1]", (Object)"4");
        this.checkIntArray((int[])this.bean.get("intArray"), origArray);
        intChanged[1] = 4;
        this.checkIntArray(((TestBean)this.bean.get("nested")).getIntArray(), intChanged);
    }

    @Test
    public void testCopyPropertyNestedMappedMap() throws Exception {
        HashMap<String, String> origMap = new HashMap<String, String>();
        origMap.put("First Key", "First Value");
        origMap.put("Second Key", "Second Value");
        HashMap<String, String> changedMap = new HashMap<String, String>();
        changedMap.put("First Key", "First Value");
        changedMap.put("Second Key", "Second Value");
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.mapProperty(Second Key)", (Object)"New Second Value");
        this.checkMap((Map)this.bean.get("mapProperty"), origMap);
        changedMap.put("Second Key", "New Second Value");
        this.checkMap(((TestBean)this.bean.get("nested")).getMapProperty(), changedMap);
    }

    @Test
    public void testCopyPropertyNestedSimple() throws Exception {
        this.bean.set("intProperty", (Object)0);
        this.nested.setIntProperty(0);
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)1);
        Assertions.assertEquals((int)0, (int)((Integer)this.bean.get("intProperty")));
        Assertions.assertEquals((int)1, (int)this.nested.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)2);
        Assertions.assertEquals((int)0, (int)((Integer)this.bean.get("intProperty")));
        Assertions.assertEquals((int)2, (int)this.nested.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)3L);
        Assertions.assertEquals((int)0, (int)((Integer)this.bean.get("intProperty")));
        Assertions.assertEquals((int)3, (int)this.nested.getIntProperty());
        BeanUtils.copyProperty((Object)this.bean, (String)"nested.intProperty", (Object)"4");
        Assertions.assertEquals((int)0, (int)((Integer)this.bean.get("intProperty")));
        Assertions.assertEquals((int)4, (int)this.nested.getIntProperty());
    }

    @Test
    public void testCopyPropertyNull() throws Exception {
        this.bean.set("nullProperty", (Object)"non-null value");
        BeanUtils.copyProperty((Object)this.bean, (String)"nullProperty", null);
        Assertions.assertNull((Object)this.bean.get("nullProperty"), (String)"nullProperty is null");
    }

    @Test
    public void testCopyPropertyShort() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)123);
        Assertions.assertEquals((short)123, (short)((Short)this.bean.get("shortProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)123);
        Assertions.assertEquals((short)123, (short)((Short)this.bean.get("shortProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)123L);
        Assertions.assertEquals((short)123, (short)((Short)this.bean.get("shortProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"shortProperty", (Object)123);
        Assertions.assertEquals((short)123, (short)((Short)this.bean.get("shortProperty")));
    }

    @Test
    public void testDescribe() throws Exception {
        Map map = PropertyUtils.describe((Object)this.bean);
        for (String describe : this.describes) {
            Assertions.assertTrue((boolean)map.containsKey(describe), (String)("Property '" + describe + "' is present"));
        }
        Assertions.assertFalse((boolean)map.containsKey("writeOnlyProperty"), (String)"Property 'writeOnlyProperty' is not present");
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("booleanProperty"), (String)"Value of 'booleanProperty'");
        Assertions.assertEquals((Object)121, map.get("byteProperty"), (String)"Value of 'byteProperty'");
        Assertions.assertEquals((Object)321.0, map.get("doubleProperty"), (String)"Value of 'doubleProperty'");
        Assertions.assertEquals((Object)Float.valueOf(123.0f), map.get("floatProperty"), (String)"Value of 'floatProperty'");
        Assertions.assertEquals((Object)123, map.get("intProperty"), (String)"Value of 'intProperty'");
        Assertions.assertEquals((Object)321L, map.get("longProperty"), (String)"Value of 'longProperty'");
        Assertions.assertEquals((Object)987, map.get("shortProperty"), (String)"Value of 'shortProperty'");
        Assertions.assertEquals((Object)"This is a string", (Object)((String)map.get("stringProperty")), (String)"Value of 'stringProperty'");
    }

    @Test
    public void testGetArrayProperty() throws Exception {
        String[] arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"stringArray");
        String[] comp = (String[])this.bean.get("stringArray");
        Assertions.assertEquals((int)comp.length, (int)arr.length, (String)("String array length = " + comp.length));
        arr = BeanUtils.getArrayProperty((Object)this.bean, (String)"intArray");
        int[] iarr = (int[])this.bean.get("intArray");
        Assertions.assertEquals((int)iarr.length, (int)arr.length, (String)("String array length = " + iarr.length));
    }

    @Test
    public void testGetGeneralProperty() throws Exception {
        String val = BeanUtils.getProperty((Object)this.bean, (String)"nested.intIndexed[2]");
        String comp = String.valueOf(this.bean.get("intIndexed", 2));
        Assertions.assertEquals((Object)val, (Object)comp, (String)("nested.intIndexed[2] == " + comp));
    }

    @Test
    public void testGetIndexedProperty1() throws Exception {
        String val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed[3]");
        String comp = String.valueOf(this.bean.get("intIndexed", 3));
        Assertions.assertEquals((Object)val, (Object)comp, (String)("intIndexed[3] == " + comp));
        val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed[3]");
        comp = (String)this.bean.get("stringIndexed", 3);
        Assertions.assertEquals((Object)val, (Object)comp, (String)("stringIndexed[3] == " + comp));
    }

    @Test
    public void testGetIndexedProperty2() throws Exception {
        String val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)3);
        String comp = String.valueOf(this.bean.get("intIndexed", 3));
        Assertions.assertEquals((Object)val, (Object)comp, (String)("intIndexed,3 == " + comp));
        val = BeanUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)3);
        comp = (String)this.bean.get("stringIndexed", 3);
        Assertions.assertEquals((Object)val, (Object)comp, (String)("stringIndexed,3 == " + comp));
    }

    @Test
    public void testGetNestedProperty() throws Exception {
        String val = BeanUtils.getNestedProperty((Object)this.bean, (String)"nested.stringProperty");
        String comp = this.nested.getStringProperty();
        Assertions.assertEquals((Object)val, (Object)comp, (String)("nested.StringProperty == " + comp));
    }

    @Test
    public void testGetSimpleProperty() throws Exception {
        String val = BeanUtils.getSimpleProperty((Object)this.bean, (String)"shortProperty");
        String comp = String.valueOf(this.bean.get("shortProperty"));
        Assertions.assertEquals((Object)val, (Object)comp, (String)("shortProperty == " + comp));
    }

    @Test
    public void testPopulateArrayElements() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("intIndexed[0]", "100");
        map.put("intIndexed[2]", "120");
        map.put("intIndexed[4]", "140");
        BeanUtils.populate((Object)this.bean, map);
        Integer intIndexed0 = (Integer)this.bean.get("intIndexed", 0);
        Assertions.assertEquals((int)100, (int)intIndexed0, (String)"intIndexed[0] is 100");
        Integer intIndexed1 = (Integer)this.bean.get("intIndexed", 1);
        Assertions.assertEquals((int)10, (int)intIndexed1, (String)"intIndexed[1] is 10");
        Integer intIndexed2 = (Integer)this.bean.get("intIndexed", 2);
        Assertions.assertEquals((int)120, (int)intIndexed2, (String)"intIndexed[2] is 120");
        Integer intIndexed3 = (Integer)this.bean.get("intIndexed", 3);
        Assertions.assertEquals((int)30, (int)intIndexed3, (String)"intIndexed[3] is 30");
        Integer intIndexed4 = (Integer)this.bean.get("intIndexed", 4);
        Assertions.assertEquals((int)140, (int)intIndexed4, (String)"intIndexed[4] is 140");
        map.clear();
        map.put("stringIndexed[1]", "New String 1");
        map.put("stringIndexed[3]", "New String 3");
        BeanUtils.populate((Object)this.bean, map);
        Assertions.assertEquals((Object)"String 0", (Object)((String)this.bean.get("stringIndexed", 0)), (String)"stringIndexed[0] is \"String 0\"");
        Assertions.assertEquals((Object)"New String 1", (Object)((String)this.bean.get("stringIndexed", 1)), (String)"stringIndexed[1] is \"New String 1\"");
        Assertions.assertEquals((Object)"String 2", (Object)((String)this.bean.get("stringIndexed", 2)), (String)"stringIndexed[2] is \"String 2\"");
        Assertions.assertEquals((Object)"New String 3", (Object)((String)this.bean.get("stringIndexed", 3)), (String)"stringIndexed[3] is \"New String 3\"");
        Assertions.assertEquals((Object)"String 4", (Object)((String)this.bean.get("stringIndexed", 4)), (String)"stringIndexed[4] is \"String 4\"");
    }

    @Test
    public void testPopulateArrayProperties() throws Exception {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        String[] intArrayIn = new String[]{"123", "456", "789"};
        map.put("intArray", intArrayIn);
        String[] stringArray = new String[]{"New String 0", "New String 1"};
        map.put("stringArray", stringArray);
        BeanUtils.populate((Object)this.bean, map);
        int[] intArray = (int[])this.bean.get("intArray");
        Assertions.assertNotNull((Object)intArray, (String)"intArray is present");
        Assertions.assertEquals((int)3, (int)intArray.length, (String)"intArray length");
        Assertions.assertEquals((int)123, (int)intArray[0], (String)"intArray[0]");
        Assertions.assertEquals((int)456, (int)intArray[1], (String)"intArray[1]");
        Assertions.assertEquals((int)789, (int)intArray[2], (String)"intArray[2]");
        stringArray = (String[])this.bean.get("stringArray");
        Assertions.assertNotNull((Object)stringArray, (String)"stringArray is present");
        Assertions.assertEquals((int)2, (int)stringArray.length, (String)"stringArray length");
        Assertions.assertEquals((Object)"New String 0", (Object)stringArray[0], (String)"stringArray[0]");
        Assertions.assertEquals((Object)"New String 1", (Object)stringArray[1], (String)"stringArray[1]");
    }

    @Test
    public void testPopulateMapped() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mappedProperty(First Key)", "New First Value");
        map.put("mappedProperty(Third Key)", "New Third Value");
        BeanUtils.populate((Object)this.bean, map);
        Assertions.assertEquals((Object)"New First Value", (Object)((String)this.bean.get("mappedProperty", "First Key")), (String)"mappedProperty(First Key)");
        Assertions.assertEquals((Object)"Second Value", (Object)((String)this.bean.get("mappedProperty", "Second Key")), (String)"mappedProperty(Second Key)");
        Assertions.assertEquals((Object)"New Third Value", (Object)((String)this.bean.get("mappedProperty", "Third Key")), (String)"mappedProperty(Third Key)");
        Assertions.assertNull((Object)this.bean.get("mappedProperty", "Fourth Key"), (String)"mappedProperty(Fourth Key");
    }

    @Test
    public void testPopulateNested() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nested.booleanProperty", "false");
        map.put("nested.doubleProperty", "432.0");
        map.put("nested.intProperty", "543");
        map.put("nested.shortProperty", "654");
        BeanUtils.populate((Object)this.bean, map);
        TestBean nested = (TestBean)this.bean.get("nested");
        Assertions.assertFalse((boolean)nested.getBooleanProperty(), (String)"booleanProperty is false");
        Assertions.assertTrue((boolean)nested.isBooleanSecond(), (String)"booleanSecond is true");
        Assertions.assertEquals((double)432.0, (double)nested.getDoubleProperty(), (double)0.005, (String)"doubleProperty is 432.0");
        Assertions.assertEquals((float)123.0f, (float)nested.getFloatProperty(), (float)0.005f, (String)"floatProperty is 123.0");
        Assertions.assertEquals((int)543, (int)nested.getIntProperty(), (String)"intProperty is 543");
        Assertions.assertEquals((long)321L, (long)nested.getLongProperty(), (String)"longProperty is 321");
        Assertions.assertEquals((short)654, (short)nested.getShortProperty(), (String)"shortProperty is 654");
        Assertions.assertEquals((Object)"This is a string", (Object)nested.getStringProperty(), (String)"stringProperty is \"This is a string\"");
    }

    @Test
    public void testPopulateScalar() throws Exception {
        this.bean.set("nullProperty", (Object)"non-null value");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("booleanProperty", "false");
        map.put("doubleProperty", "432.0");
        map.put("intProperty", "543");
        map.put("nullProperty", null);
        map.put("shortProperty", "654");
        BeanUtils.populate((Object)this.bean, map);
        Boolean booleanProperty = (Boolean)this.bean.get("booleanProperty");
        Assertions.assertFalse((boolean)booleanProperty, (String)"booleanProperty is false");
        Boolean booleanSecond = (Boolean)this.bean.get("booleanSecond");
        Assertions.assertTrue((boolean)booleanSecond, (String)"booleanSecond is true");
        Double doubleProperty = (Double)this.bean.get("doubleProperty");
        Assertions.assertEquals((double)432.0, (double)doubleProperty, (double)0.005, (String)"doubleProperty is 432.0");
        Float floatProperty = (Float)this.bean.get("floatProperty");
        Assertions.assertEquals((float)123.0f, (float)floatProperty.floatValue(), (float)0.005f, (String)"floatProperty is 123.0");
        Integer intProperty = (Integer)this.bean.get("intProperty");
        Assertions.assertEquals((int)543, (int)intProperty, (String)"intProperty is 543");
        Long longProperty = (Long)this.bean.get("longProperty");
        Assertions.assertEquals((long)321L, (long)longProperty, (String)"longProperty is 321");
        Assertions.assertNull((Object)this.bean.get("nullProperty"), (String)"nullProperty is null");
        Short shortProperty = (Short)this.bean.get("shortProperty");
        Assertions.assertEquals((short)654, (short)shortProperty, (String)"shortProperty is 654");
        Assertions.assertEquals((Object)"This is a string", (Object)((String)this.bean.get("stringProperty")), (String)"stringProperty is \"This is a string\"");
    }

    @Test
    public void testSetPropertyNull() throws Exception {
        this.bean.set("nullProperty", (Object)"non-null value");
        BeanUtils.setProperty((Object)this.bean, (String)"nullProperty", null);
        Assertions.assertNull((Object)this.bean.get("nullProperty"), (String)"nullProperty is null");
    }

    @Test
    public void testSetPropertyNullValues() throws Exception {
        Object oldValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray", null);
        Object newValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        Assertions.assertNotNull((Object)newValue, (String)"stringArray is not null");
        Assertions.assertInstanceOf(String[].class, (Object)newValue, (String)"stringArray of correct type");
        Assertions.assertEquals((int)1, (int)((String[])newValue).length, (String)"stringArray length");
        PropertyUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)oldValue);
        oldValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        BeanUtils.setProperty((Object)this.bean, (String)"stringArray[2]", null);
        newValue = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringArray");
        Assertions.assertNotNull((Object)newValue, (String)"stringArray is not null");
        Assertions.assertInstanceOf(String[].class, (Object)newValue, (String)"stringArray of correct type");
        Assertions.assertEquals((int)5, (int)((String[])newValue).length, (String)"stringArray length");
        Assertions.assertNull((Object)((String[])newValue)[2], (String)"stringArray[2] is null");
        PropertyUtils.setProperty((Object)this.bean, (String)"stringArray", (Object)oldValue);
        BeanUtils.setProperty((Object)this.bean, (String)"stringProperty", null);
        Assertions.assertNull((Object)BeanUtils.getProperty((Object)this.bean, (String)"stringProperty"), (String)"stringProperty is now null");
    }

    @Test
    public void testSetPropertyOnPrimitiveWrappers() throws Exception {
        BeanUtils.setProperty((Object)this.bean, (String)"intProperty", (Object)1);
        Assertions.assertEquals((int)1, (int)((Integer)this.bean.get("intProperty")));
        BeanUtils.setProperty((Object)this.bean, (String)"stringProperty", (Object)1);
        Assertions.assertEquals((int)1, (int)Integer.parseInt((String)this.bean.get("stringProperty")));
    }
}

