/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import org.apache.commons.beanutils2.DynaProperty;
import org.apache.commons.beanutils2.LazyDynaClass;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LazyDynaClassTest {
    protected LazyDynaClass dynaClass;
    protected String testProperty = "myProperty";

    @BeforeEach
    public void setUp() throws Exception {
        this.dynaClass = new LazyDynaClass();
    }

    @AfterEach
    public void tearDown() {
        this.dynaClass = null;
    }

    @Test
    public void testAddProperty1() {
        this.dynaClass.add(this.testProperty);
        DynaProperty dynaProperty = this.dynaClass.getDynaProperty(this.testProperty);
        Assertions.assertEquals((Object)this.testProperty, (Object)dynaProperty.getName(), (String)"name is correct");
        Assertions.assertEquals(Object.class, (Object)dynaProperty.getType(), (String)"type is correct");
    }

    @Test
    public void testAddProperty2() {
        this.dynaClass.add(this.testProperty, String.class);
        DynaProperty dynaProperty = this.dynaClass.getDynaProperty(this.testProperty);
        Assertions.assertEquals((Object)this.testProperty, (Object)dynaProperty.getName(), (String)"name is correct");
        Assertions.assertEquals(String.class, (Object)dynaProperty.getType(), (String)"type is correct");
    }

    @Test
    public void testAddProperty3() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.dynaClass.add(this.testProperty, String.class, true, true));
    }

    @Test
    public void testAddPropertyNullName1() {
        Assertions.assertThrows(NullPointerException.class, () -> this.dynaClass.add((String)null));
    }

    @Test
    public void testAddPropertyNullName2() {
        Assertions.assertThrows(NullPointerException.class, () -> this.dynaClass.add(null, String.class));
    }

    @Test
    public void testAddPropertyNullName3() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.dynaClass.add(null, String.class, true, true));
    }

    @Test
    public void testAddPropertyRestricted1() {
        this.dynaClass.setRestricted(true);
        Assertions.assertTrue((boolean)this.dynaClass.isRestricted(), (String)"MutableDynaClass is restricted");
        Assertions.assertThrows(IllegalStateException.class, () -> this.dynaClass.add(this.testProperty));
    }

    @Test
    public void testAddPropertyRestricted2() {
        this.dynaClass.setRestricted(true);
        Assertions.assertTrue((boolean)this.dynaClass.isRestricted(), (String)"MutableDynaClass is restricted");
        Assertions.assertThrows(IllegalStateException.class, () -> this.dynaClass.add(this.testProperty, String.class));
    }

    @Test
    public void testAddPropertyRestricted3() {
        this.dynaClass.setRestricted(true);
        Assertions.assertTrue((boolean)this.dynaClass.isRestricted(), (String)"MutableDynaClass is restricted");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.dynaClass.add(this.testProperty, String.class, true, true));
    }

    @Test
    public void testGetPropertyDoesntExist1() {
        this.dynaClass.setReturnNull(false);
        Assertions.assertFalse((boolean)this.dynaClass.isReturnNull(), (String)"returnNull is 'false'");
        DynaProperty dynaProperty = this.dynaClass.getDynaProperty(this.testProperty);
        Assertions.assertEquals((Object)this.testProperty, (Object)dynaProperty.getName(), (String)"name is correct");
        Assertions.assertEquals(Object.class, (Object)dynaProperty.getType(), (String)"type is correct");
        Assertions.assertFalse((boolean)this.dynaClass.isDynaProperty(this.testProperty), (String)"property doesn't exist");
    }

    @Test
    public void testGetPropertyDoesntExist2() {
        this.dynaClass.setReturnNull(true);
        Assertions.assertTrue((boolean)this.dynaClass.isReturnNull(), (String)"returnNull is 'true'");
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"property is null");
    }

    @Test
    public void testRemoveProperty() {
        this.dynaClass.setReturnNull(true);
        this.dynaClass.add(this.testProperty);
        Assertions.assertTrue((boolean)this.dynaClass.isDynaProperty(this.testProperty), (String)"Property exists");
        Assertions.assertNotNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"property is Not null");
        this.dynaClass.remove(this.testProperty);
        Assertions.assertFalse((boolean)this.dynaClass.isDynaProperty(this.testProperty), (String)"Property doesn't exist");
        Assertions.assertNull((Object)this.dynaClass.getDynaProperty(this.testProperty), (String)"property is null");
    }

    @Test
    public void testRemovePropertyDoesntExist() {
        Assertions.assertFalse((boolean)this.dynaClass.isDynaProperty(this.testProperty), (String)"property doesn't exist");
        this.dynaClass.remove(this.testProperty);
        Assertions.assertFalse((boolean)this.dynaClass.isDynaProperty(this.testProperty), (String)"property still doesn't exist");
    }

    @Test
    public void testRemovePropertyNullName() {
        Assertions.assertThrows(NullPointerException.class, () -> this.dynaClass.remove(null));
    }

    @Test
    public void testRemovePropertyRestricted() {
        this.dynaClass.add(this.testProperty);
        Assertions.assertTrue((boolean)this.dynaClass.isDynaProperty(this.testProperty), (String)"Property exists");
        this.dynaClass.setRestricted(true);
        Assertions.assertTrue((boolean)this.dynaClass.isRestricted(), (String)"MutableDynaClass is restricted");
        Assertions.assertThrows(IllegalStateException.class, () -> this.dynaClass.remove(this.testProperty));
    }
}

