/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import java.lang.reflect.Method;
import org.apache.commons.beanutils2.MethodUtils;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.bugs.other.Jira298BeanFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Jira298Test {
    private static final Log LOG = LogFactory.getLog(Jira298Test.class);

    @BeforeEach
    protected void setUp() throws Exception {
    }

    @AfterEach
    protected void tearDown() throws Exception {
    }

    @Test
    public void testIssue_BEANUTILS_298_MethodUtils_getAccessibleMethod() throws Exception {
        Jira298BeanFactory.IX bean = Jira298BeanFactory.createImplX();
        Object result = null;
        Method m2 = MethodUtils.getAccessibleMethod(bean.getClass(), (String)"getName", (Class[])new Class[0]);
        result = m2.invoke((Object)bean, new Object[0]);
        Assertions.assertEquals((Object)"BaseX name value", (Object)result);
    }

    @Test
    public void testIssue_BEANUTILS_298_PropertyUtils_getProperty() throws Exception {
        Jira298BeanFactory.IX bean = Jira298BeanFactory.createImplX();
        Object result = PropertyUtils.getProperty((Object)bean, (String)"name");
        Assertions.assertEquals((Object)"BaseX name value", (Object)result);
    }

    @Test
    public void testIssue_BEANUTILS_298_PropertyUtils_setProperty() throws Exception {
        Jira298BeanFactory.IX bean = Jira298BeanFactory.createImplX();
        Assertions.assertEquals((Object)"BaseX name value", (Object)bean.getName());
        PropertyUtils.setProperty((Object)bean, (String)"name", (Object)"new name");
        Assertions.assertEquals((Object)"new name", (Object)bean.getName());
    }
}

