/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.converters.IntegerConverter;
import org.apache.commons.beanutils2.converters.IntegerConverterTest;
import org.apache.commons.beanutils2.converters.NumberConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

abstract class AbstractNumberConverterTest<T extends Number> {
    protected Number[] numbers = new Number[4];

    AbstractNumberConverterTest() {
    }

    protected abstract Class<T> getExpectedType();

    protected abstract NumberConverter<T> makeConverter();

    protected abstract NumberConverter<T> makeConverter(T var1);

    @Test
    public void testBooleanToNumberDefault() {
        NumberConverter<T> converter = this.makeConverter();
        Assertions.assertEquals((int)0, (int)((Number)converter.convert(this.getExpectedType(), (Object)Boolean.FALSE)).intValue(), (String)"Boolean.FALSE to Number ");
        Assertions.assertEquals((int)1, (int)((Number)converter.convert(this.getExpectedType(), (Object)Boolean.TRUE)).intValue(), (String)"Boolean.TRUE to Number ");
    }

    @Test
    public void testCalendarToNumber() {
        NumberConverter converter = this.makeConverter();
        Calendar calendarValue = Calendar.getInstance();
        long longValue = calendarValue.getTime().getTime();
        Assertions.assertEquals((Long)longValue, (Long)((Long)converter.convert(Long.class, (Object)calendarValue)), (String)"Calendar to Long");
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(Integer.class, (Object)calendarValue), (String)"Calendar to Integer - expected a ConversionException");
    }

    @Test
    public void testConvertNull() {
        Assertions.assertThrows(ConversionException.class, () -> this.makeConverter().convert(this.getExpectedType(), null), (String)"Expected ConversionException");
    }

    @Test
    public void testConvertNumber() {
        String[] message = new String[]{"from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double", "from BigDecimal", "from BigInteger", "from Integer array"};
        Object[] number = new Object[]{(byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2, new BigDecimal("17.2"), new BigInteger("33"), new Integer[]{3, 2, 1}};
        for (int i = 0; i < number.length; ++i) {
            Object val = this.makeConverter().convert(this.getExpectedType(), number[i]);
            Assertions.assertNotNull((Object)val, (String)("Convert " + message[i] + " should not be null"));
            Assertions.assertTrue((boolean)this.getExpectedType().isInstance(val), (String)("Convert " + message[i] + " should return a " + this.getExpectedType().getName()));
        }
    }

    @Test
    public void testDateToNumber() {
        NumberConverter converter = this.makeConverter();
        Date dateValue = new Date();
        long longValue = dateValue.getTime();
        Assertions.assertEquals((Long)longValue, (Long)((Long)converter.convert(Long.class, (Object)dateValue)), (String)"Date to Long");
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(Integer.class, (Object)dateValue), (String)"Date to Integer - expected a ConversionException");
    }

    @Test
    public void testInvalidDefault() {
        Number defaultvalue = this.numbers[0];
        NumberConverter<Number> converter = this.makeConverter(defaultvalue);
        Assertions.assertEquals((Object)defaultvalue, (Object)converter.convert(this.getExpectedType(), null), (String)"Invalid null ");
        Assertions.assertEquals((Object)defaultvalue, (Object)converter.convert(this.getExpectedType(), (Object)"XXXX"), (String)"Default XXXX ");
    }

    @Test
    public void testInvalidException() {
        NumberConverter<T> converter = this.makeConverter();
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(this.getExpectedType(), null), (String)"Null test, expected ConversionException");
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(this.getExpectedType(), (Object)"XXXX"), (String)"Invalid test, expected ConversionException");
    }

    @Test
    public void testInvalidType() {
        NumberConverter<T> converter = this.makeConverter();
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(Object.class, (Object)this.numbers[0]), (String)"Invalid type test, expected ConversionException");
    }

    @Test
    public void testInvalidTypeWithDefault() {
        NumberConverter<Number> converter = this.makeConverter(this.numbers[0]);
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(Object.class, (Object)this.numbers[0]), (String)"Invalid type with default test, expected ConversionException");
    }

    @Test
    public void testNumberToStringDefault() {
        NumberConverter<T> converter = this.makeConverter();
        Assertions.assertEquals((Object)this.numbers[0].toString(), (Object)converter.convert(String.class, (Object)this.numbers[0]), () -> "Default Convert " + this.numbers[0]);
        Assertions.assertEquals((Object)this.numbers[1].toString(), (Object)converter.convert(String.class, (Object)this.numbers[1]), () -> "Default Convert " + this.numbers[1]);
    }

    @Test
    public void testNumberToStringLocale() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        NumberConverter<T> converter = this.makeConverter();
        converter.setUseLocaleFormat(true);
        Assertions.assertEquals((Object)"-12", (Object)converter.convert(String.class, (Object)this.numbers[0]), () -> "Default Locale " + this.numbers[0]);
        Assertions.assertEquals((Object)"13", (Object)converter.convert(String.class, (Object)this.numbers[1]), () -> "Default Locale " + this.numbers[1]);
        converter.setLocale(Locale.GERMAN);
        Assertions.assertEquals((Object)"-22", (Object)converter.convert(String.class, (Object)this.numbers[2]), () -> "Locale.GERMAN " + this.numbers[2]);
        Assertions.assertEquals((Object)"23", (Object)converter.convert(String.class, (Object)this.numbers[3]), () -> "Locale.GERMAN " + this.numbers[3]);
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testNumberToStringPattern() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        NumberConverter<T> converter = this.makeConverter();
        converter.setPattern("[0,0.0];(0,0.0)");
        Assertions.assertEquals((Object)"(12.0)", (Object)converter.convert(String.class, (Object)this.numbers[0]), () -> "Default Locale " + this.numbers[0]);
        Assertions.assertEquals((Object)"[13.0]", (Object)converter.convert(String.class, (Object)this.numbers[1]), () -> "Default Locale " + this.numbers[1]);
        converter.setLocale(Locale.GERMAN);
        Assertions.assertEquals((Object)"(22,0)", (Object)converter.convert(String.class, (Object)this.numbers[2]), () -> "Locale.GERMAN " + this.numbers[2]);
        Assertions.assertEquals((Object)"[23,0]", (Object)converter.convert(String.class, (Object)this.numbers[3]), () -> "Locale.GERMAN " + this.numbers[3]);
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testOtherToStringDefault() {
        NumberConverter<T> converter = this.makeConverter();
        Assertions.assertEquals((Object)"ABC", (Object)converter.convert(String.class, (Object)new StringBuilder("ABC")), (String)"Default Convert ");
    }

    @Test
    public void testStringArrayToInteger() {
        Integer defaultValue = -1;
        IntegerConverter converter = new IntegerConverterTest().makeConverter(defaultValue);
        Assertions.assertEquals((Integer)5, (Integer)((Integer)converter.convert(Integer.class, (Object)new String[]{"5", "4", "3"})), (String)"Valid First");
        Assertions.assertEquals((Integer)defaultValue, (Integer)((Integer)converter.convert(Integer.class, (Object)new String[]{"FOO", "1", "2"})), (String)"Invalid First");
        Assertions.assertEquals((Integer)defaultValue, (Integer)((Integer)converter.convert(Integer.class, (Object)new String[]{null, "1", "2"})), (String)"Null First");
        Assertions.assertEquals((Integer)9, (Integer)((Integer)converter.convert(Integer.class, (Object)new long[]{9L, 2L, 6L})), (String)"Long Array");
    }

    @Test
    public void testStringToNumberDefault() {
        NumberConverter<T> converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        Assertions.assertEquals((Object)this.numbers[0], (Object)converter.convert(this.getExpectedType(), (Object)this.numbers[0].toString()), () -> "Default Convert " + this.numbers[0]);
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(this.getExpectedType(), (Object)"12x"), (String)"Expected invalid value to cause ConversionException");
    }

    @Test
    public void testStringToNumberDefaultType() {
        NumberConverter<T> converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        Assertions.assertEquals((Object)this.numbers[0], (Object)converter.convert(null, (Object)this.numbers[0].toString()), () -> "Default Convert " + this.numbers[0]);
    }

    @Test
    public void testStringToNumberLocale() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        NumberConverter<T> converter = this.makeConverter();
        converter.setUseLocaleFormat(true);
        Assertions.assertEquals((Object)this.numbers[0], (Object)converter.convert(this.getExpectedType(), (Object)"-0,012"), () -> "Default Locale " + this.numbers[0]);
        Assertions.assertEquals((Object)this.numbers[1], (Object)converter.convert(this.getExpectedType(), (Object)"0,013"), () -> "Default Locale " + this.numbers[1]);
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(this.getExpectedType(), (Object)"0,02x"), (String)"Expected invalid value to cause ConversionException");
        converter.setLocale(Locale.GERMAN);
        Assertions.assertEquals((Object)this.numbers[2], (Object)converter.convert(this.getExpectedType(), (Object)"-0.022"), () -> "Locale.GERMAN " + this.numbers[2]);
        Assertions.assertEquals((Object)this.numbers[3], (Object)converter.convert(this.getExpectedType(), (Object)"0.023"), () -> "Locale.GERMAN " + this.numbers[3]);
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(this.getExpectedType(), (Object)"0.02x"), (String)"Expected invalid value to cause ConversionException");
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testStringToNumberPattern() {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        NumberConverter<T> converter = this.makeConverter();
        converter.setPattern("[0,0];(0,0)");
        Assertions.assertEquals((Object)this.numbers[0], (Object)converter.convert(this.getExpectedType(), (Object)"(1,2)"), () -> "Default Locale " + this.numbers[0]);
        Assertions.assertEquals((Object)this.numbers[1], (Object)converter.convert(this.getExpectedType(), (Object)"[1,3]"), () -> "Default Locale " + this.numbers[1]);
        converter.setLocale(Locale.GERMAN);
        Assertions.assertEquals((Object)this.numbers[2], (Object)converter.convert(this.getExpectedType(), (Object)"(2.2)"), () -> "Locale.GERMAN " + this.numbers[2]);
        Assertions.assertEquals((Object)this.numbers[3], (Object)converter.convert(this.getExpectedType(), (Object)"[2.3]"), () -> "Locale.GERMAN " + this.numbers[3]);
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(this.getExpectedType(), (Object)"1,2"), (String)"Expected invalid value to cause ConversionException");
        Object obj = new Object(){

            public String toString() {
                return "dsdgsdsdg";
            }
        };
        Assertions.assertThrows(ConversionException.class, () -> converter.convert(this.getExpectedType(), obj), (String)"Expected invalid value to cause ConversionException");
        Locale.setDefault(defaultLocale);
    }

    @Test
    public void testToString() {
        Assertions.assertNotNull((Object)this.makeConverter().toString());
    }
}

