/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.CharacterConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CharacterConverterTest {
    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testConvertToChar() {
        CharacterConverter converter = new CharacterConverter();
        Assertions.assertEquals((Character)Character.valueOf('F'), (Character)((Character)converter.convert(Character.TYPE, (Object)"FOO")), (String)"Wrong result");
    }

    @Test
    public void testConvertToCharacter() {
        CharacterConverter converter = new CharacterConverter();
        Assertions.assertEquals((Character)Character.valueOf('N'), (Character)((Character)converter.convert(Character.class, (Object)Character.valueOf('N'))), (String)"Character Test");
        Assertions.assertEquals((Character)Character.valueOf('F'), (Character)((Character)converter.convert(Character.class, (Object)"FOO")), (String)"String Test");
        Assertions.assertEquals((Character)Character.valueOf('3'), (Character)((Character)converter.convert(Character.class, (Object)321)), (String)"Integer Test");
    }

    @Test
    public void testConvertToCharacterNullNoDefault() {
        CharacterConverter converter = new CharacterConverter();
        Assertions.assertThrows(ConversionException.class, () -> CharacterConverterTest.lambda$testConvertToCharacterNullNoDefault$0((Converter)converter));
    }

    @Test
    public void testConvertToString() {
        CharacterConverter converter;
        CharacterConverter raw = converter = new CharacterConverter();
        Assertions.assertEquals((Object)"N", (Object)raw.convert(String.class, (Object)Character.valueOf('N')), (String)"Character Test");
        Assertions.assertEquals((Object)"F", (Object)raw.convert(String.class, (Object)"FOO"), (String)"String Test");
        Assertions.assertEquals((Object)"3", (Object)raw.convert(String.class, (Object)321), (String)"Integer Test");
        Assertions.assertEquals(null, (Object)raw.convert(String.class, null), (String)"Null Test");
    }

    @Test
    public void testConvertToUnsupportedType() {
        CharacterConverter converter = new CharacterConverter();
        Assertions.assertThrows(ConversionException.class, () -> CharacterConverterTest.lambda$testConvertToUnsupportedType$1((Converter)converter));
    }

    @Test
    public void testDefault() {
        CharacterConverter converter = new CharacterConverter('C');
        Assertions.assertEquals((Character)Character.valueOf('C'), (Character)((Character)converter.convert(Character.class, null)), (String)"Default Test");
    }

    private static /* synthetic */ void lambda$testConvertToUnsupportedType$1(Converter converter) throws Throwable {
        converter.convert(Integer.class, (Object)"Test");
    }

    private static /* synthetic */ void lambda$testConvertToCharacterNullNoDefault$0(Converter converter) throws Throwable {
        converter.convert(Character.class, null);
    }
}

