/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ClassReloader
extends ClassLoader {
    public ClassReloader(ClassLoader parent) {
        super(parent);
    }

    public Class<?> reload(Class<?> clazz) throws FileNotFoundException, IOException {
        String className = clazz.getName();
        String classFile = className.replace('.', '/') + ".class";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream classStream = this.getParent().getResourceAsStream(classFile);){
            int bytesRead;
            if (classStream == null) {
                throw new FileNotFoundException(classFile);
            }
            byte[] buf = new byte[1024];
            while ((bytesRead = classStream.read(buf)) != -1) {
                baos.write(buf, 0, bytesRead);
            }
        }
        byte[] classData = baos.toByteArray();
        Class<?> newClass = this.defineClass(className, classData, 0, classData.length);
        this.resolveClass(newClass);
        return newClass;
    }
}

