/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.sql.converters;

import java.sql.Date;
import java.util.Calendar;
import org.apache.commons.beanutils2.converters.AbstractDateConverterTest;
import org.apache.commons.beanutils2.sql.converters.SqlDateConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SqlDateConverterTest
extends AbstractDateConverterTest<Date> {
    @Override
    protected Class<Date> getExpectedType() {
        return Date.class;
    }

    protected SqlDateConverter makeConverter() {
        return new SqlDateConverter();
    }

    protected SqlDateConverter makeConverter(Date defaultValue) {
        return new SqlDateConverter(defaultValue);
    }

    @Override
    @Test
    public void testDefaultStringToTypeConvert() {
        SqlDateConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        String testString = "2006-05-16";
        Object expected = this.toType("2006-05-16", "yyyy-MM-dd", null);
        this.validConversion(converter, expected, "2006-05-16");
        this.invalidConversion(converter, "01/01/2006");
    }

    @Test
    public void testDefaultTypeToStringConvert() {
        SqlDateConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        String expected = "2006-05-16";
        Object testVal = this.toType("2006-05-16", "yyyy-MM-dd", null);
        this.stringConversion(converter, "2006-05-16", testVal);
        Object result = converter.convert(String.class, (Object)2);
        Assertions.assertEquals((Object)"2", (Object)result, (String)"Default toString()");
    }

    @Override
    protected Date toType(Calendar value) {
        return new Date(this.getTimeInMillis(value));
    }
}

