/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ConfigurationNodeVisitor;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDefaultConfigurationNode {
    private static final String[] FIELD_NAMES = new String[]{"UID", "NAME", "FIRSTNAME", "LASTLOGIN"};
    private static final String[] FIELD_TYPES = new String[]{"long", "string", "string", "date"};
    private static final String[] FIELD_ATTRS = new String[]{"primarykey,unique", "notnull", "notnull", null};
    DefaultConfigurationNode node;

    @Before
    public void setUp() throws Exception {
        this.node = new DefaultConfigurationNode();
        this.node.setName("table");
        this.node.setReference((Object)"TestReference");
        this.node.addAttribute((ConfigurationNode)new DefaultConfigurationNode("type", (Object)"system"));
        this.node.addChild((ConfigurationNode)new DefaultConfigurationNode("name", (Object)"users"));
        for (int i = 0; i < FIELD_NAMES.length; ++i) {
            DefaultConfigurationNode field = new DefaultConfigurationNode("field");
            field.addChild((ConfigurationNode)new DefaultConfigurationNode("name", (Object)FIELD_NAMES[i]));
            field.addAttribute((ConfigurationNode)new DefaultConfigurationNode("type", (Object)FIELD_TYPES[i]));
            if (FIELD_ATTRS[i] != null) {
                StringTokenizer tok = new StringTokenizer(FIELD_ATTRS[i], ", ");
                while (tok.hasMoreTokens()) {
                    field.addAttribute((ConfigurationNode)new DefaultConfigurationNode("attribute", (Object)tok.nextToken()));
                }
            }
            this.node.addChild((ConfigurationNode)field);
        }
    }

    @Test
    public void testNewNode() {
        this.node = new DefaultConfigurationNode();
        Assert.assertNull((String)"name is not null", (Object)this.node.getName());
        Assert.assertNull((String)"value is not null", (Object)this.node.getValue());
        Assert.assertNull((String)"reference is not null", (Object)this.node.getReference());
        Assert.assertTrue((String)"Children are not empty", (boolean)this.node.getChildren().isEmpty());
        Assert.assertTrue((String)"Named children are not empty", (boolean)this.node.getChildren("test").isEmpty());
        Assert.assertEquals((String)"Children cound is not 0", (long)0L, (long)this.node.getChildrenCount());
        Assert.assertEquals((String)"Named children count is not 0", (long)0L, (long)this.node.getChildrenCount("test"));
        Assert.assertTrue((String)"Attributes are not empty", (boolean)this.node.getAttributes().isEmpty());
        Assert.assertTrue((String)"Named attributes are not empty", (boolean)this.node.getAttributes("test").isEmpty());
        Assert.assertNull((String)"Node has a parent", (Object)this.node.getParentNode());
        Assert.assertFalse((String)"Node is defined", (boolean)this.node.isDefined());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetAttributeNonExisting() {
        this.node = new DefaultConfigurationNode();
        this.node.getAttribute(0);
    }

    @Test
    public void testGetReference() {
        Assert.assertEquals((String)"Reference was not stored", (Object)"TestReference", (Object)this.node.getReference());
    }

    @Test
    public void testGetChildren() {
        Assert.assertEquals((String)"Number of children incorrect", (long)(FIELD_NAMES.length + 1), (long)this.node.getChildrenCount());
        List children = this.node.getChildren();
        Iterator<ConfigurationNode> it = children.iterator();
        DefaultConfigurationNode child = (DefaultConfigurationNode)it.next();
        Assert.assertEquals((String)"Wrong node", (Object)"name", (Object)child.getName());
        this.checkFieldNodes(it);
    }

    @Test
    public void testGetChildrenByName() {
        List children = this.node.getChildren("field");
        Assert.assertEquals((String)"Incorrect number of child nodes", (long)FIELD_NAMES.length, (long)children.size());
        Assert.assertEquals((String)"Incorrect result of getChildrenCount()", (long)FIELD_NAMES.length, (long)this.node.getChildrenCount("field"));
        this.checkFieldNodes(children.iterator());
        Assert.assertTrue((String)"Found non existing nodes", (boolean)this.node.getChildren("test").isEmpty());
        Assert.assertEquals((String)"Wrong children list for null", (Object)this.node.getChildren(), (Object)this.node.getChildren(null));
    }

    @Test
    public void testAddChild() {
        int cnt = this.node.getChildrenCount();
        DefaultConfigurationNode ndNew = new DefaultConfigurationNode("test", (Object)"xyz");
        this.node.addChild((ConfigurationNode)ndNew);
        Assert.assertEquals((String)"New node was not added", (long)(cnt + 1), (long)this.node.getChildrenCount());
        List children = this.node.getChildren();
        Assert.assertEquals((String)"Incorrect number of children", (long)this.node.getChildrenCount(), (long)children.size());
        Assert.assertSame((String)"Node was not added to end", (Object)ndNew, children.get(cnt));
        Assert.assertEquals((String)"Incorrect number of named children", (long)1L, (long)this.node.getChildrenCount(ndNew.getName()));
        Assert.assertFalse((String)"Child is an attribute", (boolean)ndNew.isAttribute());
        Assert.assertSame((String)"Parent was not set", (Object)this.node, (Object)ndNew.getParentNode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddChildNull() {
        this.node.addChild(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddUndefinedChild() {
        this.node.addChild((ConfigurationNode)new DefaultConfigurationNode());
    }

    @Test
    public void testRemoveChild() {
        DefaultConfigurationNode child = (DefaultConfigurationNode)this.node.getChildren().get(3);
        int cnt = this.node.getChildrenCount();
        this.node.removeChild((ConfigurationNode)child);
        Assert.assertEquals((String)"Child was not removed", (long)(cnt - 1), (long)this.node.getChildrenCount());
        for (ConfigurationNode nd : this.node.getChildren()) {
            Assert.assertNotSame((String)"Found removed node", (Object)child, (Object)nd);
        }
        Assert.assertNull((String)"Parent reference was not removed", (Object)child.getParentNode());
    }

    @Test
    public void testRemoveNonExistingChild() {
        int cnt = this.node.getChildrenCount();
        this.node.removeChild((ConfigurationNode)new DefaultConfigurationNode("test"));
        this.node.removeChild((ConfigurationNode)new DefaultConfigurationNode());
        this.node.removeChild((ConfigurationNode)null);
        this.node.removeChild("non existing child node");
        this.node.removeChild((String)null);
        Assert.assertEquals((String)"Children were changed", (long)cnt, (long)this.node.getChildrenCount());
    }

    @Test
    public void testRemoveChildByName() {
        int cnt = this.node.getChildrenCount();
        this.node.removeChild("name");
        Assert.assertEquals((String)"Child was not removed", (long)(cnt - 1), (long)this.node.getChildrenCount());
        Assert.assertEquals((String)"Still found name child", (long)0L, (long)this.node.getChildrenCount("name"));
        this.node.removeChild("field");
        Assert.assertEquals((String)"Still remaining nodes", (long)0L, (long)this.node.getChildrenCount());
    }

    @Test
    public void testRemoveChildren() {
        this.node.removeChildren();
        Assert.assertEquals((String)"Children count is not 0", (long)0L, (long)this.node.getChildrenCount());
        Assert.assertTrue((String)"Children are not empty", (boolean)this.node.getChildren().isEmpty());
    }

    @Test
    public void testGetChild() {
        ConfigurationNode child = this.node.getChild(2);
        Assert.assertEquals((String)"Wrong child returned", (Object)child, this.node.getChildren().get(2));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetChildInvalidIndex() {
        this.node.getChild(4724);
    }

    @Test
    public void testGetAttributes() {
        Assert.assertEquals((String)"Number of attributes incorrect", (long)1L, (long)this.node.getAttributeCount());
        List attributes = this.node.getAttributes();
        Iterator it = attributes.iterator();
        DefaultConfigurationNode attr = (DefaultConfigurationNode)it.next();
        Assert.assertEquals((String)"Wrong node", (Object)"type", (Object)attr.getName());
        Assert.assertFalse((String)"More attributes", (boolean)it.hasNext());
    }

    @Test
    public void testGetAttributesByName() {
        Assert.assertEquals((String)"Incorrect number of attributes", (long)1L, (long)this.node.getAttributeCount("type"));
        DefaultConfigurationNode field = (DefaultConfigurationNode)this.node.getChildren().get(1);
        Assert.assertEquals((String)"Incorrect number of attributes", (long)2L, (long)field.getAttributeCount("attribute"));
        List attrs = field.getAttributes("attribute");
        Assert.assertEquals((String)"Wrong value", (Object)"primarykey", (Object)((DefaultConfigurationNode)attrs.get(0)).getValue());
        Assert.assertEquals((String)"Wrong value", (Object)"unique", (Object)((DefaultConfigurationNode)attrs.get(1)).getValue());
    }

    @Test
    public void testAddAttribute() {
        int cnt = this.node.getAttributeCount();
        DefaultConfigurationNode ndNew = new DefaultConfigurationNode("test", (Object)"xyz");
        this.node.addAttribute((ConfigurationNode)ndNew);
        Assert.assertEquals((String)"New node was not added", (long)(cnt + 1), (long)this.node.getAttributeCount());
        List attrs = this.node.getAttributes();
        Assert.assertEquals((String)"Incorrect number of attributes", (long)this.node.getAttributeCount(), (long)attrs.size());
        Assert.assertSame((String)"Node was not added to end", (Object)ndNew, attrs.get(cnt));
        Assert.assertEquals((String)"Incorrect number of named attributes", (long)1L, (long)this.node.getAttributeCount(ndNew.getName()));
        Assert.assertTrue((String)"Child is no attribute", (boolean)ndNew.isAttribute());
        Assert.assertSame((String)"Parent was not set", (Object)this.node, (Object)ndNew.getParentNode());
    }

    @Test
    public void testRemoveAttribute() {
        DefaultConfigurationNode attr = (DefaultConfigurationNode)this.node.getAttributes().get(0);
        int cnt = this.node.getAttributeCount();
        this.node.removeAttribute((ConfigurationNode)attr);
        Assert.assertEquals((String)"Attribute was not removed", (long)(cnt - 1), (long)this.node.getAttributeCount());
        for (ConfigurationNode nd : this.node.getAttributes()) {
            Assert.assertNotSame((String)"Found removed node", (Object)attr, (Object)nd);
        }
        Assert.assertNull((String)"Parent reference was not removed", (Object)attr.getParentNode());
    }

    @Test
    public void testRemoveAttributeByName() {
        ConfigurationNode field = this.node.getChild(1);
        Assert.assertEquals((String)"Incorrect number of attributes", (long)3L, (long)field.getAttributeCount());
        field.removeAttribute("attribute");
        Assert.assertEquals((String)"Not all nodes removed", (long)1L, (long)field.getAttributeCount());
        Assert.assertTrue((String)"Remaining attributes", (boolean)field.getAttributes("attribute").isEmpty());
        field.removeAttribute("type");
        Assert.assertEquals((String)"Remaining attributes", (long)0L, (long)field.getAttributeCount());
    }

    @Test
    public void testRemoveAttributes() {
        this.node.removeAttributes();
        Assert.assertEquals((String)"Not all attributes removed", (long)0L, (long)this.node.getAttributeCount());
        Assert.assertTrue((String)"Attributes not empty", (boolean)this.node.getAttributes().isEmpty());
    }

    @Test(expected=IllegalStateException.class)
    public void testChangeAttributeState() {
        ConfigurationNode attr = this.node.getAttribute(0);
        attr.setAttribute(false);
    }

    @Test
    public void testVisit() {
        CountNodeVisitor visitor = new CountNodeVisitor();
        this.node.visit((ConfigurationNodeVisitor)visitor);
        Assert.assertEquals((String)"Not all nodes visited", (long)19L, (long)visitor.beforeCalls);
        Assert.assertEquals((String)"Different number of before and after calls", (long)visitor.beforeCalls, (long)visitor.afterCalls);
    }

    @Test
    public void testVisitWithTerminate() {
        CountNodeVisitor visitor = new CountNodeVisitor(10);
        this.node.visit((ConfigurationNodeVisitor)visitor);
        Assert.assertEquals((String)"Incorrect number of nodes visited", (long)visitor.maxCalls, (long)visitor.beforeCalls);
        Assert.assertEquals((String)"Different number of before and after calls", (long)visitor.beforeCalls, (long)visitor.afterCalls);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVisitWithNullVisitor() {
        this.node.visit(null);
    }

    @Test
    public void testClone() {
        this.node.setValue((Object)"TestValue");
        DefaultConfigurationNode clone = (DefaultConfigurationNode)this.node.clone();
        Assert.assertEquals((String)"Value not cloned", (Object)"TestValue", (Object)clone.getValue());
        Assert.assertEquals((String)"Name not cloned", (Object)"table", (Object)clone.getName());
        Assert.assertEquals((String)"Reference not cloned", (Object)"TestReference", (Object)clone.getReference());
        Assert.assertEquals((String)"Children were cloned", (long)0L, (long)clone.getChildrenCount());
        Assert.assertEquals((String)"Attributes were cloned", (long)0L, (long)clone.getAttributeCount());
    }

    private void checkFieldNodes(Iterator<ConfigurationNode> itFields) {
        for (int i = 0; i < FIELD_NAMES.length; ++i) {
            DefaultConfigurationNode child = (DefaultConfigurationNode)itFields.next();
            Assert.assertEquals((String)"Wrong node", (Object)"field", (Object)child.getName());
            List nameNodes = child.getChildren("name");
            Assert.assertEquals((String)"Wrong number of name nodes", (long)1L, (long)nameNodes.size());
            DefaultConfigurationNode nameNode = (DefaultConfigurationNode)nameNodes.get(0);
            Assert.assertEquals((String)"Wrong field name", (Object)FIELD_NAMES[i], (Object)nameNode.getValue());
        }
    }

    public static class CountNodeVisitor
    implements ConfigurationNodeVisitor {
        public int beforeCalls;
        public int afterCalls;
        public int maxCalls;

        public CountNodeVisitor() {
            this(Integer.MAX_VALUE);
        }

        public CountNodeVisitor(int maxNumberOfVisits) {
            this.maxCalls = maxNumberOfVisits;
        }

        public void visitBeforeChildren(ConfigurationNode node) {
            ++this.beforeCalls;
        }

        public void visitAfterChildren(ConfigurationNode node) {
            ++this.afterCalls;
        }

        public boolean terminate() {
            return this.beforeCalls >= this.maxCalls;
        }
    }
}

