/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.fileupload.DefaultFileItem;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class DefaultFileItemTest {
    private static final String CONTENT_TYPE_TEXT = "text/plain";
    private static final String CONTENT_TYPE_FILE = "application/octet-stream";
    private static final int THRESHOLD = 16;
    static final String CHARSET_ISO_8859_1 = StandardCharsets.ISO_8859_1.name();
    static final String CHARSET_US_ASCII = StandardCharsets.US_ASCII.name();
    static final String CHARSET_UTF8 = StandardCharsets.UTF_8.name();
    static final String CHARSET_KOI8_R = "KOI8_R";
    static final String CHARSET_WIN1251 = "Cp1251";
    static final int[] SWISS_GERMAN_STUFF_UNICODE = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] SWISS_GERMAN_STUFF_ISO8859_1 = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] SWISS_GERMAN_STUFF_UTF8 = new int[]{71, 114, 195, 188, 101, 122, 105, 95, 122, 195, 164, 109, 195, 164};
    static final int[] RUSSIAN_STUFF_UNICODE = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};
    static final int[] RUSSIAN_STUFF_UTF8 = new int[]{208, 146, 209, 129, 208, 181, 208, 188, 95, 208, 191, 209, 128, 208, 184, 208, 178, 208, 181, 209, 130};
    static final int[] RUSSIAN_STUFF_KOI8R = new int[]{247, 211, 197, 205, 95, 208, 210, 201, 215, 197, 212};
    static final int[] RUSSIAN_STUFF_WIN1251 = new int[]{194, 241, 229, 236, 95, 239, 240, 232, 226, 229, 242};

    private static String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    protected FileItemFactory createFactory(File repository) {
        return new DefaultFileItemFactory(16, repository);
    }

    private void doTestAboveThreshold(File repository) throws IOException {
        FileItemFactory factory = this.createFactory(repository);
        String textFieldName = "textField";
        String textFieldValue = "01234567890123456789";
        byte[] testFieldValueBytes = "01234567890123456789".getBytes();
        FileItem item = factory.createItem("textField", CONTENT_TYPE_TEXT, true, null);
        Assert.assertNotNull((Object)item);
        try (OutputStream os = item.getOutputStream();){
            os.write(testFieldValueBytes);
        }
        Assert.assertFalse((boolean)item.isInMemory());
        Assert.assertEquals((long)item.getSize(), (long)testFieldValueBytes.length);
        Assert.assertTrue((boolean)Arrays.equals(item.get(), testFieldValueBytes));
        Assert.assertEquals((Object)item.getString(), (Object)"01234567890123456789");
        Assert.assertTrue((boolean)(item instanceof DefaultFileItem));
        DefaultFileItem dfi = (DefaultFileItem)item;
        File storeLocation = dfi.getStoreLocation();
        Assert.assertNotNull((Object)storeLocation);
        Assert.assertTrue((boolean)storeLocation.exists());
        Assert.assertEquals((long)storeLocation.length(), (long)testFieldValueBytes.length);
        if (repository != null) {
            Assert.assertEquals((Object)storeLocation.getParentFile(), (Object)repository);
        }
        item.delete();
    }

    @Test
    public void testAboveThresholdDefaultRepository() throws IOException {
        this.doTestAboveThreshold(null);
    }

    @Test
    public void testAboveThresholdSpecifiedRepository() throws IOException {
        String tempPath = System.getProperty("java.io.tmpdir");
        String tempDirName = "testAboveThresholdSpecifiedRepository";
        File tempDir = new File(tempPath, "testAboveThresholdSpecifiedRepository");
        FileUtils.forceMkdir((File)tempDir);
        this.doTestAboveThreshold(tempDir);
        Assert.assertTrue((boolean)tempDir.delete());
    }

    @Test
    public void testBelowThreshold() throws IOException {
        FileItemFactory factory = this.createFactory(null);
        String textFieldName = "textField";
        String textFieldValue = "0123456789";
        byte[] testFieldValueBytes = "0123456789".getBytes();
        FileItem item = factory.createItem("textField", CONTENT_TYPE_TEXT, true, null);
        Assert.assertNotNull((Object)item);
        try (OutputStream os = item.getOutputStream();){
            os.write(testFieldValueBytes);
        }
        Assert.assertTrue((boolean)item.isInMemory());
        Assert.assertEquals((long)item.getSize(), (long)testFieldValueBytes.length);
        Assert.assertTrue((boolean)Arrays.equals(item.get(), testFieldValueBytes));
        Assert.assertEquals((Object)item.getString(), (Object)"0123456789");
    }

    @Test
    public void testContentCharSet() throws Exception {
        FileItemFactory factory = this.createFactory(null);
        String teststr = DefaultFileItemTest.constructString(SWISS_GERMAN_STUFF_UNICODE);
        FileItem item = factory.createItem("doesnotmatter", "text/plain; charset=" + CHARSET_ISO_8859_1, true, null);
        try (OutputStream out = item.getOutputStream();){
            for (int element : SWISS_GERMAN_STUFF_ISO8859_1) {
                out.write(element);
            }
        }
        Assert.assertEquals((String)teststr, (Object)teststr, (Object)item.getString());
        item = factory.createItem("doesnotmatter", "text/plain; charset=" + CHARSET_UTF8, true, null);
        out = item.getOutputStream();
        try {
            for (int element : SWISS_GERMAN_STUFF_UTF8) {
                out.write(element);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        Assert.assertEquals((String)teststr, (Object)teststr, (Object)item.getString());
        teststr = DefaultFileItemTest.constructString(RUSSIAN_STUFF_UNICODE);
        item = factory.createItem("doesnotmatter", "text/plain; charset=KOI8_R", true, null);
        out = item.getOutputStream();
        try {
            for (int element : RUSSIAN_STUFF_KOI8R) {
                out.write(element);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        Assert.assertEquals((String)teststr, (Object)teststr, (Object)item.getString());
        item = factory.createItem("doesnotmatter", "text/plain; charset=Cp1251", true, null);
        out = item.getOutputStream();
        try {
            for (int element : RUSSIAN_STUFF_WIN1251) {
                out.write(element);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        Assert.assertEquals((String)teststr, (Object)teststr, (Object)item.getString());
        item = factory.createItem("doesnotmatter", "text/plain; charset=" + CHARSET_UTF8, true, null);
        out = item.getOutputStream();
        try {
            for (int element : RUSSIAN_STUFF_UTF8) {
                out.write(element);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        Assert.assertEquals((String)teststr, (Object)teststr, (Object)item.getString());
    }

    @Test
    public void testFileFieldConstruction() {
        FileItemFactory factory = this.createFactory(null);
        String fileFieldName = "fileField";
        String fileName = "originalFileName";
        FileItem item = factory.createItem("fileField", CONTENT_TYPE_FILE, false, "originalFileName");
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)item.getFieldName(), (Object)"fileField");
        Assert.assertEquals((Object)item.getContentType(), (Object)CONTENT_TYPE_FILE);
        Assert.assertFalse((boolean)item.isFormField());
        Assert.assertEquals((Object)item.getName(), (Object)"originalFileName");
    }

    @Test
    public void testTextFieldConstruction() {
        FileItemFactory factory = this.createFactory(null);
        String textFieldName = "textField";
        FileItem item = factory.createItem("textField", CONTENT_TYPE_TEXT, true, null);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)item.getFieldName(), (Object)"textField");
        Assert.assertEquals((Object)item.getContentType(), (Object)CONTENT_TYPE_TEXT);
        Assert.assertTrue((boolean)item.isFormField());
        Assert.assertNull((Object)item.getName());
    }
}

