/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache;

import javax.cache.Cache;
import javax.cache.processor.MutableEntry;

public class JCSMutableEntry<K, V>
implements MutableEntry<K, V> {
    private final Cache<K, V> cache;
    private final K key;

    public JCSMutableEntry(Cache<K, V> cache, K key) {
        this.cache = cache;
        this.key = key;
    }

    public boolean exists() {
        return this.cache.containsKey(this.key);
    }

    public void remove() {
        this.cache.remove(this.key);
    }

    public void setValue(V value) {
        this.cache.put(this.key, value);
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return (V)this.cache.get(this.key);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException(clazz.getName() + " not supported in unwrap");
    }
}

