/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.indexed;

import java.io.IOException;
import org.apache.commons.jcs3.auxiliary.disk.DiskTestObject;
import org.apache.commons.jcs3.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.indexed.DiskTestObjectUtil;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexDiskCacheUnitTestAbstract;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;

public class IndexDiskCacheSizeUnitTest
extends IndexDiskCacheUnitTestAbstract {
    @Override
    public IndexedDiskCacheAttributes getCacheAttributes() {
        IndexedDiskCacheAttributes ret = new IndexedDiskCacheAttributes();
        ret.setDiskLimitType(IDiskCacheAttributes.DiskLimitType.SIZE);
        return ret;
    }

    public void testRecycleBin() throws IOException {
        CacheElement element;
        int i;
        IndexedDiskCacheAttributes cattr = this.getCacheAttributes();
        cattr.setCacheName("testRemoveItems");
        cattr.setOptimizeAtRemoveCount(7);
        cattr.setMaxKeySize(8);
        cattr.setMaxPurgatorySize(0);
        cattr.setDiskPath("target/test-sandbox/BreakIndexTest");
        IndexedDiskCache disk = new IndexedDiskCache(cattr);
        String[] test = new String[]{"a", "bb", "ccc", "dddd", "eeeee", "ffffff", "ggggggg", "hhhhhhhhh", "iiiiiiiiii"};
        String[] expect = new String[]{null, "bb", "ccc", null, null, "ffffff", null, "hhhhhhhhh", "iiiiiiiiii"};
        DiskTestObject value = (DiskTestObject)DiskTestObjectUtil.createCacheElementsWithTestObjects(1, 1, cattr.getCacheName())[0].getVal();
        for (i = 0; i < 6; ++i) {
            element = new CacheElement("testRecycleBin", (Object)("key:" + test[i]), (Object)value);
            disk.processUpdate((ICacheElement)element);
        }
        for (i = 3; i < 5; ++i) {
            disk.remove((Object)("key:" + test[i]));
        }
        for (i = 7; i < 9; ++i) {
            element = new CacheElement("testRecycleBin", (Object)("key:" + test[i]), (Object)value);
            disk.processUpdate((ICacheElement)element);
        }
        try {
            for (i = 0; i < 9; ++i) {
                String expectedValue;
                element = disk.get((Object)("key:" + test[i]));
                if (element != null) {
                    // empty if block
                }
                if ((expectedValue = expect[i]) == null) {
                    IndexDiskCacheSizeUnitTest.assertNull((String)"Expected a null element", (Object)element);
                    continue;
                }
                IndexDiskCacheSizeUnitTest.assertNotNull((String)("The element for key [key:" + test[i] + "] should not be null. i = " + i), (Object)element);
                IndexDiskCacheSizeUnitTest.assertEquals((String)"Elements contents do not match expected", (Object)element.getVal(), (Object)value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            IndexDiskCacheSizeUnitTest.fail((String)("Should not get an exception: " + e.toString()));
        }
        disk.removeAll();
    }
}

