/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine;

import java.io.IOException;
import junit.extensions.ActiveTestSuite;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.CacheEventQueue;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheListener;

public class EventQueueConcurrentLoadTest
extends TestCase {
    private static CacheEventQueue<String, String> queue;
    private static CacheListenerImpl<String, String> listen;
    private static final int maxFailure = 3;
    private static final int waitBeforeRetry = 100;
    private static final int idleTime = 2;

    public EventQueueConcurrentLoadTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        ActiveTestSuite suite = new ActiveTestSuite();
        suite.addTest((Test)new EventQueueConcurrentLoadTest("testRunPutTest1"){

            public void runTest() throws Exception {
                this.runPutTest(200, 200);
            }
        });
        suite.addTest((Test)new EventQueueConcurrentLoadTest("testRunPutTest2"){

            public void runTest() throws Exception {
                this.runPutTest(1200, 1400);
            }
        });
        suite.addTest((Test)new EventQueueConcurrentLoadTest("testRunRemoveTest1"){

            public void runTest() throws Exception {
                this.runRemoveTest(2200);
            }
        });
        suite.addTest((Test)new EventQueueConcurrentLoadTest("testRunPutTest4"){

            public void runTest() throws Exception {
                this.runPutTest(5200, 6600);
            }
        });
        suite.addTest((Test)new EventQueueConcurrentLoadTest("testRunRemoveTest2"){

            public void runTest() throws Exception {
                this.runRemoveTest(5200);
            }
        });
        suite.addTest((Test)new EventQueueConcurrentLoadTest("testRunPutDelayTest"){

            public void runTest() throws Exception {
                this.runPutDelayTest(100, 6700);
            }
        });
        return suite;
    }

    public void setUp() {
        listen = new CacheListenerImpl();
        queue = new CacheEventQueue(listen, 1L, "testCache1", 3, 100);
        queue.setWaitToDieMillis(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPutTest(int end, int expectedPutCount) throws Exception {
        for (int i = 0; i <= end; ++i) {
            CacheElement elem = new CacheElement("testCache1", (Object)(i + ":key"), (Object)(i + "data"));
            queue.addPutEvent((ICacheElement)elem);
        }
        while (!queue.isEmpty()) {
            EventQueueConcurrentLoadTest eventQueueConcurrentLoadTest = this;
            synchronized (eventQueueConcurrentLoadTest) {
                System.out.println("queue is still busy, waiting 250 millis");
                ((Object)((Object)this)).wait(250L);
            }
        }
        System.out.println("queue is empty, comparing putCount");
        EventQueueConcurrentLoadTest.assertTrue((String)("The put count [" + EventQueueConcurrentLoadTest.listen.putCount + "] is below the expected minimum threshold [" + expectedPutCount + "]"), (EventQueueConcurrentLoadTest.listen.putCount >= expectedPutCount - 1 ? 1 : 0) != 0);
    }

    public void runRemoveTest(int end) throws Exception {
        for (int i = 0; i <= end; ++i) {
            queue.addRemoveEvent((Object)(i + ":key"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPutDelayTest(int end, int expectedPutCount) throws Exception {
        while (!queue.isEmpty()) {
            EventQueueConcurrentLoadTest eventQueueConcurrentLoadTest = this;
            synchronized (eventQueueConcurrentLoadTest) {
                System.out.println("queue is busy, waiting 250 millis to begin");
                ((Object)((Object)this)).wait(250L);
            }
        }
        System.out.println("queue is empty, begin");
        CacheElement elem = new CacheElement("testCache1", (Object)"a:key", (Object)"adata");
        queue.addPutEvent((ICacheElement)elem);
        for (int i = 0; i <= end; ++i) {
            EventQueueConcurrentLoadTest eventQueueConcurrentLoadTest = this;
            synchronized (eventQueueConcurrentLoadTest) {
                if (i % 2 == 0) {
                    ((Object)((Object)this)).wait(2L);
                } else {
                    ((Object)((Object)this)).wait(1L);
                }
            }
            CacheElement elem2 = new CacheElement("testCache1", (Object)(i + ":key"), (Object)(i + "data"));
            queue.addPutEvent((ICacheElement)elem2);
        }
        while (!queue.isEmpty()) {
            EventQueueConcurrentLoadTest eventQueueConcurrentLoadTest = this;
            synchronized (eventQueueConcurrentLoadTest) {
                System.out.println("queue is still busy, waiting 250 millis");
                ((Object)((Object)this)).wait(250L);
            }
        }
        System.out.println("queue is empty, comparing putCount");
        Thread.sleep(1000L);
        EventQueueConcurrentLoadTest.assertTrue((String)("The put count [" + EventQueueConcurrentLoadTest.listen.putCount + "] is below the expected minimum threshold [" + expectedPutCount + "]"), (EventQueueConcurrentLoadTest.listen.putCount >= expectedPutCount - 1 ? 1 : 0) != 0);
    }

    protected static class CacheListenerImpl<K, V>
    implements ICacheListener<K, V> {
        protected int putCount;
        protected int removeCount;

        protected CacheListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePut(ICacheElement<K, V> item) throws IOException {
            CacheListenerImpl cacheListenerImpl = this;
            synchronized (cacheListenerImpl) {
                ++this.putCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRemove(String cacheName, K key) throws IOException {
            CacheListenerImpl cacheListenerImpl = this;
            synchronized (cacheListenerImpl) {
                ++this.removeCount;
            }
        }

        public void handleRemoveAll(String cacheName) throws IOException {
        }

        public void handleDispose(String cacheName) throws IOException {
        }

        public void setListenerId(long id) throws IOException {
        }

        public long getListenerId() throws IOException {
            return 0L;
        }
    }
}

